#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h> // socklen_t
#include <netinet/in.h>
#include <arpa/inet.h> // for the address entering part
#include <pthread.h>
#include <signal.h>
#include <cerrno>

#include "OWRTRelay.h"

//using namespace std;

#define BUFF_LEN 256
#define BUCKET_SIZE 16384

// This is the TCP Relay Daemon (can be either client or server, client ideally resides near the user)
void StartDaemon()
{

}

void error(const char *msg)
{
    perror(msg);
    exit(1);
}


int main(int argc, char *argv[])
{
	srand(time(NULL));
	signal(SIGPIPE, SIG_IGN);



	int sockfd, newsockfd;
	socklen_t clilen;
	//char buffer[BUFF_LEN];
	struct sockaddr_in serv_addr, cli_addr;

	if (argc < 7)
	{
		fprintf(stderr,"ERROR, not enough arguments\n");
		exit(1);
	}/*
	fprintf(stdout, " Arg [0]: %s\n", argv[0] );
	fprintf(stdout, " Arg [1]: %s\n", argv[1] );
	fprintf(stdout, " Arg [2]: %s\n", argv[2] );
	fprintf(stdout, " Arg [3]: %s\n", argv[3] );
	fprintf(stdout, " Arg [4]: %s\n", argv[4] );
	fprintf(stdout, " Arg [5]: %s\n", argv[5] );
	fprintf(stdout, " Arg [6]: %s\n", argv[6] );*/

	// Set the Argument Globals
	bsysTypeServerARG = true; // default to assume server
	if(std::string(argv[1]).compare(std::string("client")) == 0)
		bsysTypeServerARG = false;

	listenPortARG = atoi(argv[2]);
	targetAddressARG = argv[3];
	targetPortARG = atoi(argv[4]);
	offsetValueARG = atoi(argv[5]);
	xorValueARG = atoi(argv[6]);

	if(bsysTypeServerARG)
		pTHELOG = fopen("SvrRelayLog.log", "a"); // append...

	// date/time
	time_t t = time(NULL);
	struct tm tm = *localtime(&t);



	if(bsysTypeServerARG)
	{
		fprintf(pTHELOG, "------------------------------------------------------------\n");
		fprintf(pTHELOG, "\n  Relay is running as a SERVER  listening on port %i\n", listenPortARG);
		fprintf(pTHELOG, "  Traffic Will be Forwarded to:  %s:%i\n", targetAddressARG, targetPortARG);
		fprintf(pTHELOG, "  Offset Value: %i\t XOR Value: %i\n\n", offsetValueARG, xorValueARG);
		fprintf(pTHELOG, "   now: %d-%d-%d %d:%d:%d\n\n\n", tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec);
		fflush(pTHELOG);
	}
	else
	{
		fprintf(stdout, "\n  Relay is running as a CLIENT  listening on port %i\n", listenPortARG);
		fprintf(stdout, "  Traffic Will be Forwarded to:  %s:%i\n", targetAddressARG, targetPortARG);
		fprintf(stdout, "  Offset Value: %i\t XOR Value: %i\n\n", offsetValueARG, xorValueARG);
	}



	//  Address Family - AF_INET (this is IP version 4)
	//  Type - SOCK_STREAM (this means connection oriented TCP protocol)
	//  Protocol - 0 [ or IPPROTO_IP This is IP protocol]
	sockfd = socket(AF_INET, SOCK_STREAM, 0);

	if (sockfd < 0)
        error("ERROR opening socket");


	// clears out the "serv_addr" POD, just in case i guess
	bzero((char *) &serv_addr, sizeof(serv_addr));

	// set some address criteria these set where we listen to and on which port
	serv_addr.sin_family = AF_INET; // IPV4 type connection
	serv_addr.sin_addr.s_addr = INADDR_ANY; // which address this destination will be associated with (0.0.0.0)
	serv_addr.sin_port = htons(listenPortARG);

	if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0)
		error("ERROR on binding");

	listen(sockfd,5);
	clilen = sizeof(cli_addr);
	while(true)
	{
	//fprintf(stdout, "Waiting for Connection. numConns(%i)\n", numConnections);
		newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen); // Blocking Call!!!
		if (newsockfd < 0)
		{
			fprintf(stdout, "ERROR on accept, continuing...");
			continue;
		}

		if(bsysTypeServerARG)
		{
			std::string clistr = getClientIP( newsockfd );

			time_t t1 = time(NULL);
			struct tm tm1 = *localtime(&t1);
			fprintf(pTHELOG, "   now: %d-%d-%d %d:%d:%d\n", tm1.tm_year + 1900, tm1.tm_mon + 1, tm1.tm_mday, tm1.tm_hour, tm1.tm_min, tm1.tm_sec);

			fprintf(pTHELOG, "   SYN From: %s \n\n", clistr.c_str() );
			fflush(pTHELOG);
		}

		//fprintf(stdout, "Trying to open a new thread process.\n");
		if(OpenNewConn()) // if there's enough slots to serve out another connection...
		{
			int randy = rand();
			// Create the Reverse "Helper" thread
			struct LRInfoHolder aHolder;
			aHolder.thd_grp_ID = randy % 256;
			aHolder.socket_desc_fromLeft = newsockfd;

			pthread_t thd4uploading;
			if( pthread_create( &thd4uploading , NULL ,  connection_handler_LR , (void*) &aHolder) < 0)
			{
				perror("could not create thread");
				return 1;
			}
			else
				pthread_detach(thd4uploading);
		}
		else // not enough slots available
		{
	//fprintf(stdout, "Not Enough Slots Available.\n");
			close(newsockfd); // This will do a FIN, ACK as opposed to RST in java, leave for now
		}
	}
	close(sockfd); // server socket, shouldn't ever really get here i guess
	return 0;
}

// sets up the "next" socket connection and then prepares to forward all stuff uploading
void *connection_handler_LR(void *LRinfo) // upload
{
	//Get the socket descriptor
	int socket_desc_fromLeft = ((LRInfoHolder*)LRinfo)->socket_desc_fromLeft; //*(int*)&sock123;
	int socket_desc_toRight;
	struct sockaddr_in socketaddress_toRight;
	int randyHere = ((LRInfoHolder*)LRinfo)->thd_grp_ID;

	//Create socket
	socket_desc_toRight = socket(AF_INET , SOCK_STREAM , 0);
	if (socket_desc_toRight == -1)
	{
		printf("Could not create socket");
		return NULL;
	}
	socketaddress_toRight.sin_addr.s_addr = inet_addr(targetAddressARG);
	socketaddress_toRight.sin_family = AF_INET;
	socketaddress_toRight.sin_port = htons( targetPortARG );

	//Connect to the next leg...
	if (connect(socket_desc_toRight , (struct sockaddr *)&socketaddress_toRight , sizeof(socketaddress_toRight)) < 0)
	{
		puts("connect error in LR thread");
		//close(socket_desc_fromLeft);
		return NULL;
	}

	// Create the Reverse "Helper" thread
	struct RLInfoHolder aHolder;
	aHolder.socket_desc_toLeft = socket_desc_fromLeft;
	aHolder.socket_desc_fromRight = socket_desc_toRight;
	aHolder.thd_grp_ID = randyHere;
	pthread_t thd2;
	if( pthread_create( &thd2 , NULL ,  connection_handler_RL , (void*) &aHolder) < 0)
	{
		fprintf(stdout, "could not create helper thread, killing 1st thread\n");
		return NULL;
	}
	else
		pthread_detach(thd2);


	// Now that we've connected up, i can write and read from it, here we'll read fromLeft and send toRight
	// The helper thread however will do just the opposite...


	int bytesRead;
	int bytesWritten;
	char theBuffer[BUCKET_SIZE]; // char, no byte arrays exist in c/c++............
	bzero(theBuffer,BUCKET_SIZE);
//fprintf(stdout, "(LR) UPLOAD THREAD STARTING. (%i)\n", randyHere);
	while(true)
	{
		bytesRead = read(socket_desc_fromLeft, theBuffer, BUCKET_SIZE);
		//bytesRead = recv(socket_desc_fromLeft, theBuffer, BUCKET_SIZE,  MSG_DONTWAIT);
		if (bytesRead == 0)
		{
			/*
			if (recv(socket_desc_fromLeft, theBuffer, BUCKET_SIZE, MSG_PEEK | MSG_DONTWAIT) == 0)// if recv returns zero, that means the connection has been closed
			{
				fprintf(stdout, "(LR) Zero Bytes Read, killing\n");
				break;
			}*/
			//fprintf(stdout, "(LR) UP Breaking from read == 0 \n");
			break;
		}
		if (bytesRead < 0)
		{
		//fprintf(stdout, "(LR)Read Error in thread.\n");
			break;
		}

		//fprintf(stdout, "Read %i Bytes\n", bytesRead);

		//MagicModify(theBuffer, bytesRead);
		//
					if(bsysTypeServerARG) // server
						{
							for(int i=0; i<bytesRead; ++i )
							{
								theBuffer[i] = theBuffer[i] ^ xorValueARG;
								theBuffer[i] = theBuffer[i] - offsetValueARG;
							}
						}
						else // client
						{
							for(int i=0; i<bytesRead; ++i )
							{
								theBuffer[i] = theBuffer[i] + offsetValueARG;
								theBuffer[i] = theBuffer[i] ^ xorValueARG;
							}
						}
					//

		bytesWritten = write(socket_desc_toRight, theBuffer, bytesRead);
		if (bytesWritten == -1) // 1st check for broken pipe
		{
		    if (errno == EPIPE)
		    {
		    //fprintf(stdout, "(LR)Broken Pipe (Upload)!\n");
		    	break;
		    }
		}
		else if(bytesWritten != bytesRead)
		{
		//fprintf(stdout, "Error in Thread LtoR; bytesWritten != bytesRead\n");
			break;
		}
		//fprintf(stdout, "Wrote %i Bytes\n", bytesWritten);
	}

//fprintf(stdout, "(LR) UPLOAD THREAD DEAD. (%i)\n", randyHere);

	//close(socket_desc_fromLeft);
	//close(socket_desc_toRight);
	shutdown(socket_desc_fromLeft, SHUT_RDWR);
	shutdown(socket_desc_toRight, SHUT_RDWR);
	CloseConn();
	return NULL;
}

void *connection_handler_RL(void *RLinfo) // download
{
	int socket_desc_fromRight = ((RLInfoHolder*)RLinfo)->socket_desc_fromRight;
	int socket_desc_toLeft    = ((RLInfoHolder*)RLinfo)->socket_desc_toLeft;
	int randyHere = ((RLInfoHolder*)RLinfo)->thd_grp_ID;

		int bytesRead;
		int bytesWritten;
		char theBuffer[BUCKET_SIZE]; // char, no byte arrays exist in c/c++............
		bzero(theBuffer,BUCKET_SIZE);
	//fprintf(stdout, "(RL) DOWNLOAD THREAD STARTING. (%i)\n", randyHere);
		while(true)
		{
			bytesRead = read(socket_desc_fromRight, theBuffer, BUCKET_SIZE);
			if (bytesRead == 0)
			{
				/*
				if (recv(socket_desc_fromRight, theBuffer, BUCKET_SIZE, MSG_PEEK | MSG_DONTWAIT) == 0)// if recv returns zero, that means the connection has been closed
				{
					fprintf(stdout, "(RL) Zero Bytes Read, killing\n");
					break;
				}*/
				//fprintf(stdout, "(RL) Down Breaking from read == 0 \n");
				break;
			}
			if (bytesRead < 0)
			{
			//fprintf(stdout, "(RL)Read Error in thread.\n");
				break;
			}

			//fprintf(stdout, "(RL)Read %i Bytes\n", bytesRead);

			//MagicModify(theBuffer, bytesRead);
			//
			if(bsysTypeServerARG) // server
				{
					for(int i=0; i<bytesRead; ++i )
					{
						theBuffer[i] = theBuffer[i] ^ xorValueARG;
						theBuffer[i] = theBuffer[i] - offsetValueARG;
					}
				}
				else // client
				{
					for(int i=0; i<bytesRead; ++i )
					{
						theBuffer[i] = theBuffer[i] + offsetValueARG;
						theBuffer[i] = theBuffer[i] ^ xorValueARG;
					}
				}
			//

			bytesWritten = write(socket_desc_toLeft, theBuffer, bytesRead);
			if (bytesWritten == -1) // 1st check for broken pipe
			{
			    if (errno == EPIPE)
			    {
			    //fprintf(stdout, "(RL)Broken Pipe (Download)!\n");
			    	break;
			    }
			}
			else if(bytesWritten != bytesRead)
			{
			//fprintf(stdout, "Error in Thread RtoL; bytesWritten != bytesRead\n");
				break;
			}
			//fprintf(stdout, "(RL)Wrote %i Bytes\n", bytesWritten);
		}

	//fprintf(stdout, "(RL) DOWNLOAD THREAD DEAD. (%i)\n", randyHere);

		//close(socket_desc_fromRight);
		//close(socket_desc_toLeft);
		shutdown(socket_desc_fromRight, SHUT_RDWR);
		shutdown(socket_desc_toLeft, SHUT_RDWR);
}



void MagicModify (char buf[], int len)
{
	if(xorValueARG == 0 && offsetValueARG == 0)
		return; // bailout for testing, transparent Relay option
	if(bsysTypeServerARG) // server
	{
		for(int i=0; i<len; ++i )
		{
			buf[i] = buf[i] ^ xorValueARG;
			buf[i] = buf[i] - offsetValueARG;
		}
	}
	else // client
	{
		for(int i=0; i<len; ++i )
		{
			buf[i] = buf[i] + offsetValueARG;
			buf[i] = buf[i] ^ xorValueARG;
		}
	}
}

int GetSocketSize()
{
	int n;
	unsigned int m = sizeof(n);
	int fdsocket;
	fdsocket = socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP); // example
	getsockopt(fdsocket,SOL_SOCKET,SO_RCVBUF,(void *)&n, &m);
	return n;
}

std::string getClientIP(int newfd)
{
    struct sockaddr_in addr;
    socklen_t addr_size = sizeof(struct sockaddr_in);
    int res = getpeername(newfd, (struct sockaddr *)&addr, &addr_size);

    //char *clientip = new char[20];
    //strcpy(clientip, inet_ntoa(addr.sin_addr));

    std::string returnMe = inet_ntoa(addr.sin_addr) ;
    //delete[clientip];

    return returnMe;

}


