/*
 *  OWRTRELAY.h
 *
 *  Created on: Aug 11, 2015
 *  Author: joey
 *
 */
//#include <netinet/in.h>

#ifndef OWRTRELAY_H_
#define OWRTRELAY_H_

	// Global Init Area

	const int CONLIMIT = 32; // max number of connections at any one time. each con has a master thread and two forwarding threads.

	int numConnections = 0; // "synchronized"

	FILE *pTHELOG = NULL;

	pthread_mutex_t conLock;

	// Argument Globals
	bool bsysTypeServerARG;
	int listenPortARG;
	char* targetAddressARG;
	int targetPortARG;
	int offsetValueARG;
	int xorValueARG;

	// Structs
	struct RLInfoHolder // holds both sockets file descriptors to shuffle bytes between
	{
		int thd_grp_ID;
		int socket_desc_fromRight;
		int socket_desc_toLeft;
	};
	struct LRInfoHolder // hold fd of incomming conn
	{
		int thd_grp_ID;
		int socket_desc_fromLeft;
	};

	// Function Declaration(s)
	void *connection_handler_LR(void *info); // upload
	void *connection_handler_RL(void *info); // download
	int GetSocketSize();
	std::string getClientIP(int newfd);

	inline void MagicModify (char buf[], int len ); // heart of the operation, imagine that..

	bool OpenNewConn()
	{
		pthread_mutex_lock(&conLock);
		if( (numConnections >= 0) && (numConnections < CONLIMIT ) ) // range (0 to CONLIMIT-1)
		{
			numConnections++;
			pthread_mutex_unlock(&conLock);
			return true;
		}
		pthread_mutex_unlock(&conLock);
		return false;
	};
	bool CloseConn()
	{
		pthread_mutex_lock(&conLock);
		if( (numConnections > 0) && (numConnections <= CONLIMIT ) ) // range (0 to CONLIMIT-1)
		{
			numConnections--;
			pthread_mutex_unlock(&conLock);
			return true;
		}
		pthread_mutex_unlock(&conLock);
		return false;
	};

#endif /* OWRTRELAY_H_ */
