// JoeySpatial.cpp : Defines the exported functions for the DLL application.
//

#include "stdafx.h"

// =============================================================================================
// DLL Stuff           =========================================================================
// =============================================================================================
// Create an object which holds the state (ie the points given to us in "points"); give caller back a reciept
Object * Construct(const Point *points, size_t numPoints)
{
  // convert cloud to a vector
  std::vector<Point>* pFirstconstellation = new std::vector<Point>(); // < == will have all points in the original problem
  for (size_t i = 0; i < numPoints; i++) // copy it over
  {
    Point tmpPoint;
    tmpPoint.x = points[i].x;
    tmpPoint.y = points[i].y;
    pFirstconstellation->push_back(tmpPoint);
  }

  Object* pObj = new Object();

  pObj->totalnumberpoints = numPoints;
  pObj->pRootNode = new QTreeNode(pFirstconstellation);

 
  return pObj;
}

size_t Search(Object *object, const Point& target, double searchRadius, size_t maxPerQuad, Point *outPoints)
{
  PointDist distTarget;
  distTarget.x = target.x;
  distTarget.y = target.y;
  distTarget.dist = searchRadius;

  size_t outPointsSize = SmahtSearch(object->pRootNode, distTarget, maxPerQuad, outPoints, false);

  object->globalcounter1++;
  return outPointsSize;
}

void Destroy(Object *object)
{
  delete object;
  object = NULL;
}

// =============================================================================================
// REGULAR Stuff       =========================================================================
// =============================================================================================

bool Approaches(double a, double b, double tolerance) // true if a approaches b (according to some tolerance) false otherwise
{
  if (abs(a - b) < tolerance)
    return true;
  //else
    //std::cout << "Approaches OUTPUT : " << (a - b) << std::endl;

  return false;
}

double GetRandDouble(int low, int hi)
{
  return
    low + static_cast <double> (rand()) / (static_cast <double> (RAND_MAX / (hi - low)));
}

void RandomTargetSetter(PointDist &pointDist)
{
  pointDist.x = GetRandDouble(RANGE_MIN, RANGE_MAX);
  pointDist.y = GetRandDouble(RANGE_MIN, RANGE_MAX);
  pointDist.dist = GetRandDouble(1, 15);
}

bool GenerateRandomPoints(Point *pPoints, unsigned int size)
{
  for (unsigned int i = 0; i < size; i++)
  {
    pPoints[i].x = GetRandDouble(RANGE_MIN, RANGE_MAX);
    pPoints[i].y = GetRandDouble(RANGE_MIN, RANGE_MAX);
  }
  return true;
}

void PrintPointArray(Point *pPoints, unsigned int size)
{
  std::cout << "Printing Array of size : " << size << std::endl;
  for (unsigned int i = 0; i < size; i++)
    PrintOnePoint(&pPoints[i]);
}
void PrintPointDistArray(PointDist *pPoints, unsigned int size)
{
  std::cout << "  Printing Array of size : " << size << std::endl;
  for (unsigned int i = 0; i < size; i++)
    PrintOnePoint(&pPoints[i]);
}
void PrintOnePoint(Point *onePoint)
{
  std::cout << std::setprecision(19) << "(Point) x:" << onePoint->x << " y:" << onePoint->y << std::endl;
}
void PrintOnePoint(PointDist *onePoint)
{
  std::cout << std::setprecision(19) << "    (PDist) x:" << onePoint->x << " y:" << onePoint->y << " dist:" << onePoint->dist << std::endl;
}

void GenerateTargetPointEnvelope(PointDist &point)
{
  point.x = GetRandDouble(RANGE_MIN + 10.0, RANGE_MAX - 10.0);
  point.y = GetRandDouble(RANGE_MIN + 10.0, RANGE_MAX - 10.0);

  if (point.x > RANGE_MAX)
    point.x = RANGE_MAX;
  if (point.x < RANGE_MIN)
    point.x = RANGE_MIN;

  if (point.y > RANGE_MAX)
    point.y = RANGE_MAX;
  if (point.y < RANGE_MIN)
    point.y = RANGE_MIN;

  point.dist = GetRandDouble(R_MIN, R_MAX);
}

// one which supports being called with a std::vector 
void FindConstellationExtents(std::vector<Point>* cloud,
  double &maxX, double &maxY, double &minX, double &minY)
{
  // initialize the values to the most polar opposite value possible
  maxX = RANGE_MIN; // max x value
  maxY = RANGE_MIN; //   max y value
  minX = RANGE_MAX; //  min x value
  minY = RANGE_MAX; //    min y value

  double curX = 0.0; double curY = 0.0;
  for (unsigned int i = 0; i < cloud->size(); i++)
  {
    curX = cloud->at(i).x;
    curY = cloud->at(i).y;

    if (curX > maxX)
      maxX = curX;
    if (curX < minX)
      minX = curX;

    if (curY > maxY)
      maxY = curY;
    if (curY < minY)
      minY = curY;
  }
}

// given a list of points find the four extreme values for it
void FindConstellationExtents(Point* pPoints, unsigned int size,
  double &maxX, double &maxY, double &minX, double &minY)
{
  // initialize the values to the most polar opposite value possible
  maxX = RANGE_MIN; // max x value
  maxY = RANGE_MIN; //   max y value
  minX = RANGE_MAX; //  min x value
  minY = RANGE_MAX; //    min y value

  double curX = 0.0; double curY = 0.0;
  for (unsigned int i = 0; i < size; i++)
  {
    curX = pPoints[i].x;
    curY = pPoints[i].y;

    if (curX > maxX)
      maxX = curX;
    if (curX < minX)
      minX = curX;

    if (curY > maxY)
      maxY = curY;
    if (curY < minY)
      minY = curY;
  }
}

void ChopConstellation(std::vector<Point>* pSourceConstellation,
  std::vector<Point>* pSub0,
  std::vector<Point>* pSub1,
  std::vector<Point>* pSub2,
  std::vector<Point>* pSub3,
  double originX,
  double originY)
{
  for (size_t i = 0; i < pSourceConstellation->size(); i++)
  {
    Point sourcePoint = pSourceConstellation->at(i);

    Point newP;
    newP.x = sourcePoint.x;
    newP.y = sourcePoint.y;

    // Quadrant Selection
    if (newP.x == originX && newP.y == originY) // When Q==P the point is arbitrarily included in quadrant 0.
    {
      pSub0->push_back(newP);
    }
    else if (newP.x > originX && newP.y >= originY) // 0
    {
      pSub0->push_back(newP);
    }
    else if (newP.x <= originX && newP.y > originY) // 1
    {
      pSub1->push_back(newP);
    }
    else if (newP.x < originX && newP.y <= originY) // 2
    {
      pSub2->push_back(newP);
    }
    else if (newP.x >= originX && newP.y < originY) // 3
    {
      pSub3->push_back(newP);
    }
    else // in case we missed any errors ie. if target point was same as input...
    {
      std::cout << "WARNING: Quadrant selection Failed in ChopConstellation()!" << std::endl;
      PrintOnePoint(&newP);
      return;
    }
  }
}

bool VerifyConstellationBounds(std::vector<Point>* pSourceConstellation, double maxX, double maxY, double minX, double minY)
{
  // CAN BE TURNED BACK ON HERE FOR DEBUGGING!, comment out return statement 
  return true;

  for (size_t i = 0; i < pSourceConstellation->size(); i++)
  {
    Point pTemp = pSourceConstellation->at(i);

    if (pTemp.x >= minX && pTemp.x <= maxX &&
      pTemp.y >= minY && pTemp.y <= maxY)
    {
      continue;
    }
    else
      return false;
  }
  return true;
}


void TestGetPointsUnderNode()
{
  /*
  std::vector<std::vector<Point>*>* mess = new std::vector<std::vector<Point>*>();

  GetPointsUnderNode(pQ, mess);

  unsigned int messTally = 0;
  for(int i=0; i < mess->size(); i++)
  {
  std::vector<Point>* t1 = mess->at(i);
  messTally += t1->size();
  for(int j=0; j < t1->size(); j++)
  {
  std::cout << "(" << t1->at(j).x << "," << t1->at(j).y << ")  " ;
  }
  std::cout << "\nDONE WITH INNER" << std::endl;

  }
  std::cout << "\n messSize : " << mess->size() << std::endl;
  std::cout << "\n messTally : " << messTally << std::endl;
  */
}

// set pFinal to the node which most tightly bounds the PointDist pd
QTreeNode* SettlePointDistIntoQTree(QTreeNode* currentNode, PointDist &pd)
{
  if (currentNode->current_level == 1) // we're at root....
  {
    // only in root can we use midpoint assuredly 
    // check each one of the four quadrants
    if ((pd.x - pd.dist >= currentNode->midpointX) &&
      (pd.y - pd.dist >= currentNode->midpointY))
    {
      // fits into 0
      //currentNode = currentNode->pSub0;
      return SettlePointDistIntoQTree(currentNode->pSub0, pd);
    }
    else
      if ((pd.x + pd.dist <= currentNode->midpointX) &&
        (pd.y - pd.dist >= currentNode->midpointY))
      {
      // fits into 1
      //currentNode = currentNode->pSub1;
      return SettlePointDistIntoQTree(currentNode->pSub1, pd);
      }
      else
        if ((pd.x + pd.dist <= currentNode->midpointX) &&
          (pd.y + pd.dist <= currentNode->midpointY))
        {
      // fits into 2
      //currentNode = currentNode->pSub2;
      return SettlePointDistIntoQTree(currentNode->pSub2, pd);
        }
        else
          if ((pd.x - pd.dist >= currentNode->midpointX) &&
            (pd.y + pd.dist <= currentNode->midpointY))
          {
      // fits into 3
      //currentNode = currentNode->pSub3;
      return SettlePointDistIntoQTree(currentNode->pSub3, pd);
          }
  }
  else
  {
    // all subsequent checks need the following.
    // ie. if you're at level 2 and deeper,
    // 
    // just check to ensure its contained in one of the four children, 
    // if not, dont recurse and the value of 'currentNode' becomes our final fitting
    if (currentNode->pSub0 != NULL && ConstellationBoundsPointDist(currentNode->pSub0, pd))
    {
      // fits into 0
      //currentNode = currentNode->pSub0;
      return SettlePointDistIntoQTree(currentNode->pSub0, pd);
    }
    else
      if (currentNode->pSub1 != NULL && ConstellationBoundsPointDist(currentNode->pSub1, pd))
      {
      // fits into 1
      //currentNode = currentNode->pSub1;
      return SettlePointDistIntoQTree(currentNode->pSub1, pd);
      }
      else
        if (currentNode->pSub2 != NULL && ConstellationBoundsPointDist(currentNode->pSub2, pd))
        {
      // fits into 2
      //currentNode = currentNode->pSub2;
      return SettlePointDistIntoQTree(currentNode->pSub2, pd);
        }
        else
          if (currentNode->pSub3 != NULL && ConstellationBoundsPointDist(currentNode->pSub3, pd))
          {
      // fits into 3
      //currentNode = currentNode->pSub3;
      return SettlePointDistIntoQTree(currentNode->pSub3, pd);
          }
  }
  // at tail-recursion time, the second last call to this function effectively set the tightest bounds to currentNode
  return currentNode;
}

bool ConstellationBoundsPointDist(QTreeNode* pNode, PointDist &pd)
{
  if ( // x alignment
    ((pd.x - pd.dist) >= pNode->minX) &&
    ((pd.x + pd.dist) <= pNode->maxX) &&
    // y alignment
    ((pd.y - pd.dist) >= pNode->minY) &&
    ((pd.y + pd.dist) <= pNode->maxY)
    )
  {
    return true;
  }
  return false;
}

bool ConstellationIntersectsPointDist(QTreeNode* pNode, PointDist &pd) // subtly different
{
  // cardinal extents of the circle (PointDist)
  double minX, maxX, minY, maxY; 
  minX = pd.x - pd.dist;
  maxX = pd.x + pd.dist;
  minY = pd.y - pd.dist;
  maxY = pd.y + pd.dist;

  // circles cardinals ================================================================
  if ( //if left or right cardinal is in node
    (pd.y >= pNode->minY && pd.y <= pNode->maxY) &&

    ((minX >= pNode->minX && minX <= pNode->maxX) ||
    (maxX >= pNode->minX && maxX <= pNode->maxX))
    )
    return true;

  if ( //if top or bot cardinal is in node
    (pd.x >= pNode->minX && pd.x <= pNode->maxX) &&

    ((minY >= pNode->minY && minY <= pNode->maxY) ||
    (maxY >= pNode->minY && maxY <= pNode->maxY))
    )
    return true;
  // circles cardinals ================================================================

  // circles centerpoint (so much fun finding this was needed)
  if (pd.x >= pNode->minX && pd.x <= pNode->maxX 
                          &&
      pd.y >= pNode->minY && pd.y <= pNode->maxY )
    return true;

  // one of the constellation's corners is closer to pd.x,pd.y than its radius 
  double radiusSquared = pd.dist * pd.dist;

  if (radiusSquared >= (pd.x - pNode->minX)*(pd.x - pNode->minX) + (pd.y - pNode->minY)*(pd.y - pNode->minY)) // lower left
    return true;
  if (radiusSquared >= (pd.x - pNode->minX)*(pd.x - pNode->minX) + (pd.y - pNode->maxY)*(pd.y - pNode->maxY)) // upper left
    return true;

  if (radiusSquared >= (pd.x - pNode->maxX)*(pd.x - pNode->maxX) + (pd.y - pNode->minY)*(pd.y - pNode->minY)) // lower right
    return true;
  if (radiusSquared >= (pd.x - pNode->maxX)*(pd.x - pNode->maxX) + (pd.y - pNode->maxY)*(pd.y - pNode->maxY)) // upper right
    return true;

  // TODO: detect which part of the circle intersects in which way, facillitating less calculations for subsequent invocations of Knockout() 
  //       instead of just 'that' it intersects

  return false;
}

// used to be separate, maybe return it there later...
// just collects pointers
// caller allocates arrayOfArrays
void GetPointsUnderNode(QTreeNode* pNode, std::vector<  std::vector<Point>*  >* arrayOfArrays)
{
  if (pNode->pConstellation != NULL) //  then it contains points because its a leaf node
  {
    arrayOfArrays->push_back(pNode->pConstellation);
  }
  else
  {
    GetPointsUnderNode(pNode->pSub0, arrayOfArrays);
    GetPointsUnderNode(pNode->pSub1, arrayOfArrays);
    GetPointsUnderNode(pNode->pSub2, arrayOfArrays);
    GetPointsUnderNode(pNode->pSub3, arrayOfArrays);
  }
};

// find all of the leaf nodes which intersect the circle (PointDist)
void Knockout(QTreeNode* pNode, PointDist &target, std::vector<  std::vector<Point>*  >* list) // the rammer-hammer
{
  // WE HAVE BEEN CALLED BECAUSE WE KNOW pNODE INTERSECTS WITH TARGET
  
  // if we're a leaf, add pNode to the "list"
  if (pNode->pConstellation != NULL) //  then it contains points because its a leaf node
  {
    list->push_back(pNode->pConstellation);
  }
  else
  {
    if (pNode->pSub0 != NULL)
    {
      if (ConstellationIntersectsPointDist(pNode->pSub0, target))
        Knockout(pNode->pSub0, target, list);
    }
    if (pNode->pSub1 != NULL)
    {
      if (ConstellationIntersectsPointDist(pNode->pSub1, target))
        Knockout(pNode->pSub1, target, list);
    }
    if (pNode->pSub2 != NULL)
    {
      if (ConstellationIntersectsPointDist(pNode->pSub2, target))
        Knockout(pNode->pSub2, target, list);
    }
    if (pNode->pSub3 != NULL)
    {
      if (ConstellationIntersectsPointDist(pNode->pSub3, target))
        Knockout(pNode->pSub3, target, list);
    }
  }
}

size_t SmahtSearch(QTreeNode* pNode, PointDist &target, size_t maxPerQuad, Point* outPointsArray, bool bPrintDebug /*true*/)
{
  QTreeNode* pSetteledNode = SettlePointDistIntoQTree(pNode, target); // v1 fitting

  size_t firstcount = 0;
  if (bPrintDebug)
  {
    // void GetPointsUnderNode(QTreeNode* pNode, std::vector<  std::vector<Point>*  >* arrayOfArrays)
    std::vector<  std::vector<Point>*  >* arrayOfArrays = new std::vector<  std::vector<Point>*  >();
    GetPointsUnderNode(pSetteledNode, arrayOfArrays);
    for (size_t i = 0; i < arrayOfArrays->size(); i++)
      firstcount += arrayOfArrays->at(i)->size();
    delete arrayOfArrays;
    arrayOfArrays = NULL;
  }

  // at this point we could assume everything under pSettledNode is fair game, or

  std::vector<  std::vector<Point>*  >* pTightCollection = new std::vector<  std::vector<Point>*  >();
  Knockout(pSetteledNode, target, pTightCollection);

  // pTightCollection is now full with what you need to search 
  
  if (bPrintDebug)
  {
    size_t tightSize = 0;
    for (size_t i = 0; i < pTightCollection->size(); i++)
      tightSize += pTightCollection->at(i)->size();

    std::cout << "\nTargetPoint : " << target.x << "," << target.y << ":" << target.dist << std::endl;
    std::cout << "Point Count after SettlePointDistIntoQTree(): " << firstcount << std::endl;
    std::cout << "SetteledNode: " << pSetteledNode->WalkTree() << std::endl;
    std::cout << "Point Count after Knockout(): " << tightSize << " Num Leaves:" << pTightCollection->size() << std::endl;
  }

  // NAIVE SEARCH CALL
  size_t finalSize =
    NaiveSearch(pTightCollection,
    target,
    maxPerQuad,
    outPointsArray);

  // Cleanup!
  delete pTightCollection;
  pTightCollection = NULL;

  return finalSize;
}

unsigned int NaiveSearch(std::vector<  std::vector<Point>*  >* pTightCollection, PointDist &target, size_t maxPerQuad, Point *outPoints)
{
  size_t size0 = 0, size1 = 0, size2 = 0, size3 = 0; // current size of each quad
  size_t maxI0 = 0, maxI1 = 0, maxI2 = 0, maxI3 = 0; // max
  PointDist* quad0 = new PointDist[maxPerQuad]; // +, +
  PointDist* quad1 = new PointDist[maxPerQuad]; // -, +
  PointDist* quad2 = new PointDist[maxPerQuad]; // -, -
  PointDist* quad3 = new PointDist[maxPerQuad]; // +, -

  // loop vars
  double curX, curY, rezeroedX, rezeroedY, curDist, targDistSquared;
  PointDist tempPointDist;
  for (size_t h = 0; h < pTightCollection->size(); h++) // outer
  {
    std::vector<Point>* pInnerVector = pTightCollection->at(h);
    for (size_t i = 0; i < pInnerVector->size(); i++) // inner
    {
      Point innerPoint = pInnerVector->at(i);

      curX = (innerPoint.x); // actual point's x
      curY = (innerPoint.y); // actual point's y
      rezeroedX = curX - target.x;
      rezeroedY = curY - target.y;

      // no sqrt, compared to squared dist for speed
      curDist = /*std::sqrt(*/ (rezeroedX * rezeroedX) + (rezeroedY * rezeroedY) /*)*/;

      targDistSquared = target.dist * target.dist;

      // if we're within searchRadius then attempt to put it in the set of maxPerQuad points
      if (curDist <= (targDistSquared))
      {
        // create a point dist 
        tempPointDist = PointDist();
        tempPointDist.x = curX;
        tempPointDist.y = curY;
        tempPointDist.dist = curDist;

        //      1   |   0    Points on the borders are assigned to the quadrant in the
        //          |        counter-clockwise direction.  For example, point Q would be
        //    --Q---P------  assigned to quadrant 2.
        //          |        
        //      2   |   3    When Q==P the point is arbitrarily included in quadrant 0.

        // Quadrant Selection
        if (rezeroedX == 0 && rezeroedY == 0) // When Q==P the point is arbitrarily included in quadrant 0.
        {
          AddToQuad(tempPointDist, quad0, size0, maxI0, maxPerQuad);
        }
        else if (rezeroedX > 0 && rezeroedY >= 0) // 0
        {
          AddToQuad(tempPointDist, quad0, size0, maxI0, maxPerQuad);
        }
        else if (rezeroedX <= 0 && rezeroedY > 0) // 1
        {
          AddToQuad(tempPointDist, quad1, size1, maxI1, maxPerQuad);
        }
        else if (rezeroedX < 0 && rezeroedY <= 0) // 2
        {
          AddToQuad(tempPointDist, quad2, size2, maxI2, maxPerQuad);
        }
        else if (rezeroedX >= 0 && rezeroedY < 0) // 3
        {
          AddToQuad(tempPointDist, quad3, size3, maxI3, maxPerQuad);
        }
        else // in case we missed any errors ie. if target point was same as input...
        {
          std::cout << "WARNING: Quadrant selection Failed!" << std::endl;
          PrintOnePoint(&tempPointDist);
          return 0;
        }
      }
    }
  }

  FillInPointsArray(quad0, size0, outPoints, 0);
  FillInPointsArray(quad1, size1, outPoints, size0);
  FillInPointsArray(quad2, size2, outPoints, size0 + size1);
  FillInPointsArray(quad3, size3, outPoints, size0 + size1 + size2);

  delete[] quad0;
  quad0 = NULL;
  delete[] quad1;
  quad1 = NULL;
  delete[] quad2;
  quad2 = NULL;
  delete[] quad3;
  quad3 = NULL;

  return size0 + size1 + size2 + size3;
}


// ========      ================================================================================================================================
// ======== main ================================================================================================================================
// ========      ================================================================================================================================
/*
int main()
{
  //srand(time(0)); // randomize seed

  //sleep(20);

  RunWrapper(1000);

  //DebugAddToQuad();

  return 0;
}
*/


void SearchWrapper(Object* pObj) // just the search part
{

  PointDist testTarget;
  RandomTargetSetter(testTarget);

  Point* outPoints = new Point[MAX_PER_QUAD * 4]; // allocated in exe, so we're guessing

  size_t outPointsSize = SmahtSearch(pObj->pRootNode, testTarget, MAX_PER_QUAD, outPoints);

  std::cout << "SmahtSearch() Returned, #Points Found inside Radius:" << outPointsSize << std::endl;

  /* Point Printer for Debugging
  for (size_t i = 0; false && i < outPointsSize; i++)
  {
  //std::cout << "(" << outPoints[i].x << "," << outPoints[i].y << ")" << std::endl;
  Point poin = outPoints[i];
  PrintOnePoint(&poin);
  }
  */

  delete[] outPoints;
  outPoints = NULL;

}

void RunWrapper(int iterations) // throw everything that would otherwise be in main in here to do iterative testing.
{
  std::cout << "SpatialSearch Points Program. Constellation Range:" << RANGE_MIN << " to " << RANGE_MAX << " Num:" << NUM_POINTS << std::endl << std::endl;

  size_t pointssize = NUM_POINTS;
  Point* pPoints = new Point[pointssize]; // < == the universe 
  GenerateRandomPoints(pPoints, pointssize);  // populates the universe 

  // at this point there is a "random" cloud generated 

  // convert cloud to a vector
  std::vector<Point>* pTestconstellation = new std::vector<Point>(); // < == will have all points in the original problem
  for (size_t i = 0; i < pointssize; i++) // copy it over
  {
    Point tmpPoint;
    tmpPoint.x = pPoints[i].x;
    tmpPoint.y = pPoints[i].y;
    pTestconstellation->push_back(tmpPoint);
  }

  delete[] pPoints;
  pPoints = NULL;

  // DLL vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
  // Construct() Mockup ================================================================
  Object* pObj = new Object();
  pObj->totalnumberpoints = pointssize;
  pObj->pRootNode = new QTreeNode(pTestconstellation);

  // pTestconstellation doesnt need to be deleted, its managed(deleted) by pObj now.
  pTestconstellation = NULL;

  // Search() Mockup ================================================================
  for (int z = 0; z < iterations; z++)
    SearchWrapper(pObj);

  // Destroy() Mockup ================================================================
  delete pObj;
  pObj = NULL;
}


void FillInPointsArray(PointDist *pPointDistArr, size_t size1, Point *pPointArr, size_t start)
{
  size_t j = start;
  for (size_t i = 0; i < size1; i++)
  {
    pPointArr[j].x = pPointDistArr[i].x;
    pPointArr[j].y = pPointDistArr[i].y;

    j++;
  }
}

void DebugAddToQuad()
{
  std::cout << "Welcome to DebugAddToQuad() 👀\n\n";

  size_t maxPerQuad = 3;
  size_t size = 0;
  size_t currentMaxIndex = 1000000;

  PointDist a;

  PointDist* quad0 = new PointDist[maxPerQuad];

  /*
  for(size_t i = 0; i < maxPerQuad; i++)
  {
  quad0[i]->bArray = true;
  }
  */

  /* manually adds one point!
  quad0[0].x = 1;
  quad0[0].y = 1;
  quad0[0].dist = 10;
  size++;
  currentMaxIndex = 0;
  */

  std::cout << "\nActual Size of quad0: " << size << std::endl;
  PrintPointDistArray(quad0, maxPerQuad);


  a = PointDist(); a.x = 10; a.y = 20; a.dist = 10;
  AddToQuad(a, quad0, size, currentMaxIndex, maxPerQuad);

  std::cout << "\nActual Size of quad0: " << size << std::endl;
  PrintPointDistArray(quad0, maxPerQuad);

  a = PointDist(); a.x = 11; a.y = 21; a.dist = 20;
  AddToQuad(a, quad0, size, currentMaxIndex, maxPerQuad);

  std::cout << "\nActual Size of quad0: " << size << std::endl;
  PrintPointDistArray(quad0, maxPerQuad);

  a = PointDist(); a.x = 12; a.y = 22; a.dist = 30;
  AddToQuad(a, quad0, size, currentMaxIndex, maxPerQuad);

  std::cout << "\nActual Size of quad0: " << size << std::endl;
  PrintPointDistArray(quad0, maxPerQuad);

  a = PointDist(); a.x = 10; a.y = 20; a.dist = 40;
  AddToQuad(a, quad0, size, currentMaxIndex, maxPerQuad);

  std::cout << "\nActual Size of quad0: " << size << std::endl;
  PrintPointDistArray(quad0, maxPerQuad);

  a = PointDist(); a.x = 2; a.y = 3; a.dist = 10;
  AddToQuad(a, quad0, size, currentMaxIndex, maxPerQuad);

  std::cout << "\nActual Size of quad0: " << size << std::endl;
  PrintPointDistArray(quad0, maxPerQuad);

  a = PointDist(); a.x = 3; a.y = 3; a.dist = 9;
  AddToQuad(a, quad0, size, currentMaxIndex, maxPerQuad);

  std::cout << "\nActual Size of quad0: " << size << std::endl;
  PrintPointDistArray(quad0, maxPerQuad);

  a = PointDist(); a.x = 1; a.y = 1; a.dist = 8;
  AddToQuad(a, quad0, size, currentMaxIndex, maxPerQuad);

  std::cout << "\nActual Size of quad0: " << size << std::endl;
  PrintPointDistArray(quad0, maxPerQuad);


  delete[] quad0;

}

// if theres space add this point dist(via copying values) into the "points" array
bool AddToQuad(PointDist &theNewPoint, // potential new candidate
  PointDist* points, // holds the PointDist(s) currently in this found quad
  size_t &cursize,   // the current size of the points Array
  size_t &maxDistIndex, // the current index containing the PointDist with the max distance (first candidate to bump if needed)
  size_t &maxsize) // maxPerQuad basically
{
  if (cursize < maxsize) // space available; just put it at the end
  {
    // could use/implement a copy constructor/function here but its also nice to be explicit
    points[cursize].dist = theNewPoint.dist;
    points[cursize].x = theNewPoint.x;
    points[cursize].y = theNewPoint.y;

    cursize++;
  }
  else // replace what we have if its less than(OR EQUAL TO? WHY THO GOLDEN)the dist pointed-to by maxDistIndex
  {
    if (theNewPoint.dist <= points[maxDistIndex].dist)
    {
      // could use/implement a copy constructor/function here but its also nice to be explicit
      points[maxDistIndex].dist = theNewPoint.dist;
      points[maxDistIndex].x = theNewPoint.x;
      points[maxDistIndex].y = theNewPoint.y;
    }
  }

  if (cursize == maxsize) // then we need to find the index with the maximum distance and set "maxDistIndex" 
  {
    double curMaxDist = 0.0;
    int curMaxDistIndex = -1;

    for (size_t i = 0; i < cursize; i++)
    {
      if (points[i].dist > curMaxDist)
      {
        curMaxDist = points[i].dist;
        curMaxDistIndex = i;
      }
    }
    maxDistIndex = curMaxDistIndex; // update the passed reference
  }

  return true;
}
