/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class MapGenerator
extends Frame {
    boolean bProcessed = false;
    int upperLeftX = 25;
    int upperLeftY = 50;
    int areaWidth = 830;
    int areaHeight = 605;
    int screenWidth = 880;
    int screenHeight = 680;
    Vector listOfLines = new Vector();
    Vector formattedLines = new Vector();
    double minX;
    double minY;
    double maxX;
    double maxY;
    int newAreaHeight = -1;
    int newAreaWidth = -1;
    String inputFile = "<empty>";
    FileDialog fd;
    File myFile;
    Dialog statusBox;
    Label statusLabel;

    public static void main(String[] args) {
        new MapGenerator();
    }

    public MapGenerator() {
        this.setTitle("Map Generator 1.0");
        this.setSize(this.screenWidth, this.screenHeight);
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        this.fd = new FileDialog((Frame)this, "Select Vector File", 0);
        this.fd.setVisible(true);
        if (this.fd.getFile() == null) {
            System.exit(0);
        }
        this.myFile = new File(String.valueOf(this.fd.getDirectory()) + this.fd.getFile());
        this.inputFile = this.fd.getFile();
        this.repaint();
        this.statusBox = new Dialog((Frame)this, "Loading...");
        this.statusBox.setResizable(false);
        this.statusBox.setSize(100, 75);
        this.statusBox.setLocation(this.screenWidth / 2 - this.statusBox.getWidth() / 2, this.screenHeight / 2 - this.statusBox.getHeight() / 2);
        this.statusBox.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        this.statusLabel = new Label(" Parsing... ", 1);
        this.statusBox.add(this.statusLabel);
        this.statusLabel.setVisible(true);
        this.statusBox.pack();
        this.statusBox.setVisible(true);
        try {
            FileInputStream fis = new FileInputStream(this.myFile);
            int x = fis.available();
            byte[] bArray = new byte[x];
            fis.read(bArray);
            fis.close();
            int fileIndexPointer = 0;
            block2: while (fileIndexPointer < bArray.length) {
                String tempHolder = "";
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] != 10 && bArray[fileIndexPointer] != 32 && bArray[fileIndexPointer] != 9) break;
                    ++fileIndexPointer;
                }
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] == 32 || bArray[fileIndexPointer] == 9) {
                        ++fileIndexPointer;
                        break;
                    }
                    tempHolder = tempHolder.concat(String.valueOf((char)bArray[fileIndexPointer]));
                    ++fileIndexPointer;
                }
                double var1 = Double.parseDouble(tempHolder);
                tempHolder = "";
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] != 32 && bArray[fileIndexPointer] != 9) break;
                    ++fileIndexPointer;
                }
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] == 32 || bArray[fileIndexPointer] == 9) {
                        ++fileIndexPointer;
                        break;
                    }
                    tempHolder = tempHolder.concat(String.valueOf((char)bArray[fileIndexPointer]));
                    ++fileIndexPointer;
                }
                double var2 = Double.parseDouble(tempHolder);
                tempHolder = "";
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] != 32 && bArray[fileIndexPointer] != 9) break;
                    ++fileIndexPointer;
                }
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] == 32 || bArray[fileIndexPointer] == 9) {
                        ++fileIndexPointer;
                        break;
                    }
                    tempHolder = tempHolder.concat(String.valueOf((char)bArray[fileIndexPointer]));
                    ++fileIndexPointer;
                }
                double var3 = Double.parseDouble(tempHolder);
                tempHolder = "";
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] != 32 && bArray[fileIndexPointer] != 9) break;
                    ++fileIndexPointer;
                }
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] == 10 || bArray[fileIndexPointer] == 32 || bArray[fileIndexPointer] == 9) {
                        ++fileIndexPointer;
                        break;
                    }
                    tempHolder = tempHolder.concat(String.valueOf((char)bArray[fileIndexPointer]));
                    ++fileIndexPointer;
                }
                double var4 = Double.parseDouble(tempHolder);
                tempHolder = "";
                LineSegment myLineSegment = new LineSegment(var1, var2, var3, var4);
                this.listOfLines.add(myLineSegment);
                int display = (int)((double)fileIndexPointer / (double)x * 100.0);
                this.statusLabel.setText("Parsing " + display + "%");
                while (fileIndexPointer < bArray.length) {
                    if (bArray[fileIndexPointer] != 9 && bArray[fileIndexPointer] != 10 && bArray[fileIndexPointer] != 32 && bArray[fileIndexPointer] != 13) continue block2;
                    ++fileIndexPointer;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LineSegment firstLine = (LineSegment)this.listOfLines.get(0);
        this.minX = firstLine.x1;
        this.maxX = firstLine.x1;
        this.minY = firstLine.y1;
        this.maxY = firstLine.y1;
        if (this.minX > firstLine.x2) {
            this.minX = firstLine.x2;
        }
        if (this.maxX < firstLine.x2) {
            this.maxX = firstLine.x2;
        }
        if (this.minY > firstLine.y2) {
            this.minY = firstLine.y2;
        }
        if (this.maxY < firstLine.y2) {
            this.maxY = firstLine.y2;
        }
        int i = 1;
        while (i < this.listOfLines.size()) {
            LineSegment thisLine = (LineSegment)this.listOfLines.get(i);
            if (this.minX > thisLine.x1) {
                this.minX = thisLine.x1;
            }
            if (this.maxX < thisLine.x1) {
                this.maxX = thisLine.x1;
            }
            if (this.minY > thisLine.y1) {
                this.minY = thisLine.y1;
            }
            if (this.maxY < thisLine.y1) {
                this.maxY = thisLine.y1;
            }
            if (this.minX > thisLine.x2) {
                this.minX = thisLine.x2;
            }
            if (this.maxX < thisLine.x2) {
                this.maxX = thisLine.x2;
            }
            if (this.minY > thisLine.y2) {
                this.minY = thisLine.y2;
            }
            if (this.maxY < thisLine.y2) {
                this.maxY = thisLine.y2;
            }
            int display = (int)((double)i / (double)this.listOfLines.size() * 100.0);
            this.statusLabel.setText("Max / Min " + display + "%");
            ++i;
        }
        double originalDrawableRatio = (double)this.areaHeight / (double)this.areaWidth;
        double inputRatio = (this.maxY - this.minY) / (this.maxX - this.minX);
        this.newAreaWidth = this.areaWidth;
        this.newAreaHeight = this.areaHeight;
        if (inputRatio <= originalDrawableRatio) {
            this.newAreaHeight = (int)((double)this.areaWidth * inputRatio);
        }
        if (inputRatio > originalDrawableRatio) {
            this.newAreaWidth = (int)((double)this.areaHeight / inputRatio);
        }
        int i2 = 0;
        while (i2 < this.listOfLines.size()) {
            LineSegment tempSeg = (LineSegment)this.listOfLines.get(i2);
            tempSeg.processIntCoordinates(this.minX, this.maxX, this.minY, this.maxY, this.newAreaWidth, this.newAreaHeight);
            this.formattedLines.add(tempSeg);
            int display = (int)((double)i2 / (double)this.listOfLines.size() * 100.0);
            this.statusLabel.setText("ReProcessing " + display + "%");
            ++i2;
        }
        this.statusBox.setVisible(false);
        this.bProcessed = true;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        g.drawString("File:  " + this.inputFile, 20, 40);
        g.setColor(Color.black);
        int pad = 4;
        g.drawLine(this.upperLeftX - pad, this.upperLeftY - pad, this.upperLeftX + this.areaWidth + pad, this.upperLeftY - pad);
        g.drawLine(this.upperLeftX - pad, this.upperLeftY - pad, this.upperLeftX - pad, this.upperLeftY + this.areaHeight + pad);
        g.drawLine(this.upperLeftX - pad, this.upperLeftY + this.areaHeight + pad, this.upperLeftX + this.areaWidth + pad, this.upperLeftY + this.areaHeight + pad);
        g.drawLine(this.upperLeftX + this.areaWidth + pad, this.upperLeftY + this.areaHeight + pad, this.upperLeftX + this.areaWidth + pad, this.upperLeftY - pad);
        g.setColor(Color.gray);
        g.drawLine(this.upperLeftX - pad + 1, this.upperLeftY + this.areaHeight + pad + 1, this.upperLeftX + this.areaWidth + pad + 1, this.upperLeftY + this.areaHeight + pad + 1);
        g.drawLine(this.upperLeftX + this.areaWidth + pad + 1, this.upperLeftY + this.areaHeight + pad + 1, this.upperLeftX + this.areaWidth + pad + 1, this.upperLeftY - pad + 1);
        g.drawLine(this.upperLeftX - pad + 2, this.upperLeftY + this.areaHeight + pad + 2, this.upperLeftX + this.areaWidth + pad + 2, this.upperLeftY + this.areaHeight + pad + 2);
        g.drawLine(this.upperLeftX + this.areaWidth + pad + 2, this.upperLeftY + this.areaHeight + pad + 2, this.upperLeftX + this.areaWidth + pad + 2, this.upperLeftY - pad + 2);
        if (this.bProcessed) {
            g.setColor(Color.blue);
            int i = 0;
            while (i < this.formattedLines.size()) {
                LineSegment tempSeg = (LineSegment)this.formattedLines.get(i);
                int first = tempSeg.intx1;
                int second = tempSeg.inty1;
                int third = tempSeg.intx2;
                int fourth = tempSeg.inty2;
                g.drawLine(first, second, third, fourth);
                ++i;
            }
        }
    }

    public class LineSegment {
        public double x1;
        public double y1;
        public double x2;
        public double y2;
        public int intx1;
        public int inty1;
        public int intx2;
        public int inty2;

        public LineSegment(double a, double b, double c, double d) {
            this.x1 = a;
            this.y1 = b;
            this.x2 = c;
            this.y2 = d;
            this.intx1 = 0;
            this.inty1 = 0;
            this.intx2 = 0;
            this.inty2 = 0;
        }

        public void processIntCoordinates(double minX, double maxX, double minY, double maxY, int screenWidth, int screenHeight) {
            double wholeDifferenceX = maxX - minX;
            double wholeDifferenceY = maxY - minY;
            double specificDifferenceX1 = this.x1 - minX;
            double specificDifferenceY1 = this.y1 - minY;
            double specificDifferenceX2 = this.x2 - minX;
            double specificDifferenceY2 = this.y2 - minY;
            this.intx1 = (int)(specificDifferenceX1 / wholeDifferenceX * (double)screenWidth);
            this.intx2 = (int)(specificDifferenceX2 / wholeDifferenceX * (double)screenWidth);
            this.inty1 = (int)(specificDifferenceY1 / wholeDifferenceY * (double)screenHeight);
            this.inty2 = (int)(specificDifferenceY2 / wholeDifferenceY * (double)screenHeight);
            this.inty1 = screenHeight - this.inty1;
            this.inty2 = screenHeight - this.inty2;
            this.intx1 += 25;
            this.intx2 += 25;
            this.inty1 += 50;
            this.inty2 += 50;
        }

        public String toString() {
            return "(" + this.x1 + ", " + this.y1 + ") : (" + this.x2 + ", " + this.y2 + ")";
        }
    }
}

