<?php

  // Selectively view Apache default logs
  
  if((include 'tail-config.php') == false)
    die("Error: Could Not Include Configuration.\n");
  
  function CommandExists($cmdStr) 
  {
    return !empty(shell_exec(sprintf("which %s", escapeshellarg($cmdStr))));
  }
  
  // check each line of the file against all omit strings...
  function PotentiallyAddLine(&$linesArr, $lineToAdd, $omitsArr)
  {
    foreach($omitsArr as $omitStr)
    {
      if(strpos($lineToAdd, $omitStr) !== false) // this specific line ($lineToAdd) contained this omit string
        return;
    }      
    $linesArr[] = trim($lineToAdd); 
  } 
  
  // will accept either literal filename '/folder/log1.txt' or '/folder/log*' which is expanded with logcat if available
  function ProcessLog($lognamePath, &$linesArr, $omitsArr)
  {
    $fileBasename = basename($lognamePath);

    if((substr($fileBasename, -1) == '*') && CommandExists('logcat.sh') ) // wildcard ending '*', process many files
    {

      // (bugfix) need to change curdir to the dirname of lognamePath since if the dirpath contains a '.' it'll muck up sort in logcat.sh
      // ideally logcat.sh should be changed :/
      $origDir = getcwd();
      chdir(dirname($lognamePath));
      // remove trailing '*' (logcat.sh doesnt expect it)
      $retStr = shell_exec("logcat.sh " . escapeshellarg( substr(basename($lognamePath), 0, strlen(basename($lognamePath)) - 1) ) );
      chdir($origDir);

      // needs to be added to the lines array, as entries in the array ...
      $jrr = "\n"; // most common token delimiter, due to being on linux (probably will break elsewhere)
      
      $aLine = strtok($retStr, $jrr);
      PotentiallyAddLine($linesArr, $aLine, $omitsArr); 
      while ($aLine !== false) 
      {
        $aLine = strtok($jrr);
        PotentiallyAddLine($linesArr, $aLine, $omitsArr);
      }
    }
    else if(is_readable($lognamePath)) 
    {
      $fileArr = file( $lognamePath ,FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

      if(is_array($fileArr))
      {
        foreach($fileArr as $aLine) // loops through the lines
        {
          PotentiallyAddLine($linesArr, $aLine, $omitsArr);
        }
      }
    }
    else
    {
      $linesArr[] = "File '" . $lognamePath . 
        "' failed is_readable() check. (check that file has +r)";
    }
  }
  
  function CleanStringArray($arrIn)
  {
    $retArr = Array();
    foreach($arrIn as $elem)
    {
      if(is_string($elem) && (strlen($elem) > 0))
        $retArr[] = $elem;
    }
    return $retArr;
  }


  //      ================================================================================================  
  // MAIN ================================================================================================
  //      ================================================================================================

  // Perms Check to save us from insanity later on...
  // LogDir must have +r, +x, and...be...a...dir
  if(!is_dir(LOG_DIR))
    die("ERROR : (" . LOG_DIR . ") is not a directory or path does not exist!\n");
  if(!is_readable(LOG_DIR))
    die("ERROR : (" . LOG_DIR . ") is not readable! (+r)\n");
  if(!is_executable(LOG_DIR))
    die("ERROR : (" . LOG_DIR . ") is not executable! (+x)\n");

  // Readability Check Array Loop
  $checkFilesArr = glob(LOG_DIR . '/*');
  foreach($checkFilesArr as $checkFilesKey => $checkFilesValue)
  {
    if(!is_readable($checkFilesValue))
    {
      //echo("Error: File (" . $checkFilesValue . ") was not readable.");
      unset($checkFilesArr[$checkFilesKey]); // knock it out
    }
  }

  $finalLinesArr = Array(); // holds the lines we collect from each file, after filtration 
  $omittedTermsArr = Array();
  
  // Param initializations
  $passGET = ( (isset($_GET['pass']) && is_string($_GET['pass']))           ? $_GET['pass'] : '' );
  $logFilesGET = ( (isset($_GET['files']) && is_string($_GET['files']))     ? trim($_GET['files']) : '' );
  $omittedTermsGET = ( (isset($_GET['omits']) && is_string($_GET['omits'])) ? $_GET['omits'] : '' );
  
  // Display Form for user input
  echo("
  
  <form action=\"" . basename(__FILE__) . "\">
    <i>Password</i> <br>
      <input type=\"password\" name=\"pass\" value=\"" . htmlspecialchars($passGET) . "\" >
    <br>
    Log File(s): <i>(Tilde Delimited) (wildcard stem supported with logcat.sh; ie. access*)</i> <br>
      <input type=\"text\" name=\"files\" value=\"" . htmlspecialchars($logFilesGET) . "\" size=\"120\">
    <br>
    Omit Lines containing these (sub)strings. <i>(Tilde Delimited)</i> <br>
    <input type=\"text\" name=\"omits\" value=\"" . htmlspecialchars($omittedTermsGET) . "\" size=\"120\">
    <br><br>
    <input type=\"submit\" value=\"Submit\">
  </form> 

  ");
  
  if( (strlen(PASSWORD) != strlen($passGET)) || strcmp(PASSWORD, $passGET) !== 0 )
  {
 
  }
  else // DO THE WORK
  {
    if(!empty($logFilesGET))
    {
      // if we have some omits to filter on, prepare iterator_apply
      if(!empty($omittedTermsGET))
      {
        $omittedTermsArr = explode('~', $omittedTermsGET); // type handling of this will happen in ProcessLog();
      }
      
      $logFilesArr = explode('~', $logFilesGET);
      
      // Clean the Input Arrays
      $omittedTermsArr = CleanStringArray($omittedTermsArr);
      $logFilesArr = CleanStringArray($logFilesArr);
      
      if( is_array($logFilesArr) )
      {
        foreach($logFilesArr as $elem)
        {
          $tempName = LOG_DIR . DIRECTORY_SEPARATOR . $elem ;
          ProcessLog($tempName, $finalLinesArr, $omittedTermsArr);
        }
      }
    }    
    
    // Log file lines 
    if(!empty($omittedTermsGET))
    {
      echo("
      <h3>Filtered Results:</h3>
      <pre>");
    }
    else
    {
      echo("
      <h3>Results:</h3>
      <pre>");
    }
    foreach($finalLinesArr as $line)
      echo(htmlspecialchars($line) . "\r\n" );
    echo("
    </pre>");
    
    // Lastly, display all available log files
    $filesArr = glob(LOG_DIR . '/*');

    echo("<h4>Available Files:</h4>
    <pre>");
    foreach($filesArr as $elem)
    {
      echo(htmlspecialchars(basename($elem)) . "  ");

      if(!in_array($elem, $checkFilesArr)) // this entry is not readable, indicate so
        echo("(File is not readable!)");

      echo("\r\n");
    }
    echo("</pre>");
  }  
