<?php

  // Handles Calls for Create/Edit/Removal of User accounts from password file
  
  function IH_GetUserCreateDate($usernameStr)
  {
    return IH_GetIthUserLineToken($usernameStr, 2);
  }
  
  function IH_GetIthUserLineToken($usernameStr, $tokenNum) // main fn for getting an arbitrary token. 
  {
    $passFilename = IH_GetPWFilename();
    $passFileArr = @file($passFilename , FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
    if($passFileArr !== false) // not failure
    {
      foreach($passFileArr as $line)
      {
        $lineArr = explode(' ', $line);
        if(isset($lineArr[0]) && isset($lineArr[$tokenNum])) // 1st and nth tokens
        {
          if(strcmp($lineArr[0], $usernameStr) === 0)
            return $lineArr[$tokenNum];
        }
      }
    }
    return 'NA';
  }
  
//Markup Fns
  function IH_ModifyUserAccountTableMarkup($tok) // parse the pw file and build a table of actions to perform on accounts. 
  {
    $retStr = "<table>\r\n";
    $retStr .= "          
                          <tr>
                            <td width=\"128\"><b>Username</b></td>
                            <td width=\"256\"><b>CreateDate</b></td>
                            <td width=\"128\"><b>RemoveUser</b></td>
                            <td width=\"320\"><b>ChangePassword</b></td>
                          </tr>     
                ";
    $passwordfile = IH_GetPWFilename();
    $fh = fopen($passwordfile, "r");
        $currentUsername = '';
    if($fh) 
    {
      while ( !feof($fh) )   // loops once per line in the file
      {
        $retStr .= "<tr>\r\n";
        
        $line = fgets($fh);        // now we have a line
        $token = strtok($line, " ");       // tokenize it on spaces, should have a username now
        if($token !== false)
        {
          $currentUsername = $token;
          $retStr .= "\t<td>" . $token . "</td>\r\n";
        }
        else
          continue; // if first token isnt there , dont bother with rest of line.
          
        $token = strtok(" ");//skip password field
        $token = strtok(" ");//date field
        //remove \r\n
        $token = str_replace("\r", '', $token);
        $token = str_replace("\n", '', $token);
        if($token !== false)
          $retStr .= "\t<td>" . $token . "</td>\r\n";
        else
          continue; 

        // remove user button
        if(strcasecmp($currentUsername, "admin") == 0)
          $retStr .= "\t<td><i>NA</i></td>\r\n"; // cant remove admin, so empty field
        else
        {
          $retStr .= "
        <td>
          <form action=\"act.php\" method=\"POST\" accept-charset=\"UTF-8\">
          <input type=\"hidden\" name=\"jrr\" value=\"" . $tok . "\">  
          <input type=\"hidden\" name=\"op\" value=\"nixuser\">
          <input type=\"hidden\" name=\"username\" value=\"" . $currentUsername . "\">
          <input type=\"submit\" value=\"Remove\"></form>
        </td>
        ";
        }
        
        // Change Pass Field
        $retStr .= "\t
        <td>
          <form action=\"act.php\" method=\"POST\" accept-charset=\"UTF-8\">
          <input type=\"hidden\" name=\"jrr\" value=\"" . $tok . "\">
          <input type=\"hidden\" name=\"op\" value=\"passuser\">
          <input type=\"hidden\" name=\"username\" value=\"" . $currentUsername . "\">
          <input type=\"text\" name=\"password\">
          <input type=\"submit\" value=\"Change\"></form>
        </td>
        ";
        
        $retStr .= "</tr>\r\n";
      }
    }
    $retStr .= "</table>\r\n";
    return $retStr;
  }
  function IH_NewUserFieldMarkup($tok)
  {
    $retStr = "
        <div style=\"margin-top: 24px; margin-left: 20px; margin-right: 20px; margin-bottom: 10px;\">
          <form action=\"act.php\" method=\"POST\" accept-charset=\"UTF-8\">
            <input type=\"hidden\" name=\"jrr\" value=\"" . $tok . "\">
            <input type=\"hidden\" name=\"op\" value=\"newuser\">
            User: <input type=\"text\" name=\"username\">
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pass: <input type=\"text\" name=\"password\">&nbsp;&nbsp;
            <input type=\"submit\" value=\"Create New User\">
          </form>
        </div>";    
    
    return $retStr;
  }
  
// MODIFIER FNs
  function IH_EditUser($username, $op)
  {
    // $op == 0 (remove user)
    // $op !== "" (op contains string of new password, hash it and write it in file
    
    $sourceFilePath = IH_GetPWFilename();
    $outputFilePath = IH_GetPWFilename();
    
    $tempOutputFile = $outputFilePath . '.tmp';
    if(file_exists($tempOutputFile))
      unlink($tempOutputFile);
    
    $handleRead = fopen($sourceFilePath, "r");
    $handleWrite = fopen($tempOutputFile, 'w');
    if ($handleRead && $handleWrite) 
    {
      $lineCnt = 1;
      while (($lineStr = fgets($handleRead)) !== false) // loops once per line from input
      {
        $writeMe = $lineStr;
        
        $token = strtok($lineStr, " "); // should be the username
        
        if(strcasecmp($token, $username) == 0)// found this user
        {
          if($op === 0) // then we want to delete
          {
            continue;
          }
          else // op contains the new password
          {
            strtok(" "); // skip over the existing pass
            $date = strtok(" "); // user creation date
            
            $salt = GetRandTail(16); // new salt, every time 
            
            $writeMe = $username . " " . IH_ApplyCrypt($op, $salt) . ' ' . $date . ' ' . $salt; 
          } 
        }
        
        // line gotten from $lineStr will have trialing return so...
        // remove trailing returns
        $writeMe = str_replace("\r", '', $writeMe);
        $writeMe = str_replace("\n", '', $writeMe);
        
        // prefix line with return, except first
        if($lineCnt > 1)
          $writeMe = "\r\n" . $writeMe;  //prepend a return ONLY if we're going to put something on this line...
            
        fwrite( $handleWrite, $writeMe );  
        
        $lineCnt++;
      }
      fclose($handleRead);
      fclose($handleWrite);
      
      shell_exec('mv ' . escapeshellarg($tempOutputFile) . ' ' . escapeshellarg($outputFilePath));
      //shell_exec('chmod 777 ' . escapeshellarg($outputFilePath));    
    }  
  }
  
  function IH_DoesUserExist($username)
  {
    $fh = fopen(IH_GetPWFilename(), "r");
    if($fh) 
    {
      while ( !feof($fh) )   // loops once per line in the file
      {
        $line = fgets($fh);        // now we have a line
        $token = strtok($line, " ");       // tokenize it on spaces, should have a username now
        if($token !== false)
          if(strcasecmp($token, $username) == 0)// If the first token matches the username supplied.
            return true;
      }
    }
    fclose($fh);
    return false;
  }

  function IH_CreateUser($username, $password)
  {
    $username = strtolower($username); // Only lowercase usernames
    
    $salt = GetRandTail(16); // new salt
    
    $lineStr = '';
    if(strcasecmp('admin', $username) !== 0)
      $lineStr = "\r\n" ;
    
    $lineStr .= $username . ' ' . IH_ApplyCrypt($password, $salt) . ' ' . IH_GetTimestamp() . ' ' . $salt ;
        
    if( file_put_contents(IH_GetPWFilename(), $lineStr, FILE_APPEND | LOCK_EX) === false )
      return false;
        
    return true;
  }
  
  // return: true/false
  function IH_EvalPassword($usernameStr, $passwordStr)
  {
    $user = $usernameStr;

    // general vars
    $passwordfile = IH_GetPWFilename();
    $foundmatch = false;
    $fh = fopen($passwordfile, "r");

    if($fh) 
    {
      while ( !feof($fh) )   // loops once per line in the file
      {
        $line = fgets($fh);        // now we have a line
        $token = strtok($line, " ");       // tokenize it on spaces, should have a username now
        if($token !== false)
        {
          //echo "entire ".$line."<br>";
          if(strcasecmp($token, $user) == 0)// If the first token matches the username supplied.     case insensitive
          {
            //echo "matched  ".$token."<br>";
            $token = strtok(" "); // hashed password token
            $passFromFile = $token;
            $passFromFile = str_replace("\r", '', $passFromFile); // in case
            $passFromFile = str_replace("\n", '', $passFromFile); // in case
            
            //get salt from file
            $token = strtok(" "); //date
            $token = strtok(" "); //salt
            $saltFromFile = $token;
            $saltFromFile = str_replace("\r", '', $saltFromFile); // in case
            $saltFromFile = str_replace("\n", '', $saltFromFile); // in case
            
            //echo ($saltFromFile . "<p>");
            //echo () 

            //echo "next token  \"".$token."\"<br>";
            //echo "THE STR CMP ".strcmp((string)$token,(string)$pass)."<br>";
            if( !empty($passFromFile) && !empty($saltFromFile) && hash_equals($passFromFile, IH_ApplyCrypt($passwordStr, $saltFromFile)) )// And password matches
            {
              $foundmatch = true;
            }
            break;  // we encountered an entry for this user, we either found a match or not at this point.
          }
        }
      }
    }
    fclose($fh);
    return $foundmatch;    
  }

  ?>