<?php  // the beginning of everything

  include 'Config.php';

  // Each collection can have an access level from here, used to restrict its viewing.
  abstract class AccessLevels
  {
    const ACCESS_VOID      = -1; // Invalid state: collection hasn't been processed yet, ie. no access file
    const ACCESS_PUBLIC     = 0; // anyone can see
    const ACCESS_USER       = 1; // only users can see
    const ACCESS_RESTRICTED = 2; // specific users only, specified in a list elsewhere, (admin and owner can of course see without entry in the list)
  }

  /*
  * OK, heres the lowdown on the data/meta folder storage scheme.
  *
  * This path stores all of the "actual" uploaded files
  * Data/Collections/<ALL COLLECTIONS ROOTED HERE>
  *
  * This stores all meta-files for all uploaded files
  * Meta/Collections/<ALL META FILES HERE, NAMES MATCH DATA FILES EXACTLY>
  *
  * Meta/Index/<ALL INDEXES FOR EACH COLLECTION/SUBFOLDER HERE>
  *
  * Meta/passwd.txt (obvious)
  *
  */

  // DIRECTORY SHORTCUTS
  function IH_Data()
  {
  	return DATA_CACHE_FOLDER;
  }
  function IH_Meta()
  {
  	return META_CACHE_FOLDER;
  }
  
  function IH_GetPWFilename() // password file
  {
    return IH_Meta() . DIRECTORY_SEPARATOR . PASSWORD_FILENAME;
  }
  function IH_DataCollectionsRoot() // root of your files
  {
    return IH_Data() . DIRECTORY_SEPARATOR . 'Files';
  }
  function IH_MetaCollectionsRoot() // root of file meta-data (.IHARs)
  {
    return IH_Meta() . DIRECTORY_SEPARATOR . 'Files';
  }
  function IH_MetaCollectionsAccessRoot()
  {
    return IH_Meta() . DIRECTORY_SEPARATOR . 'Access';
  }
  function IH_MetaCollectionsIndexRoot()
  {
    return IH_Meta() . DIRECTORY_SEPARATOR . 'Index';
  }
  function IH_MetaTEMPRoot()
  {
    return IH_Meta() . DIRECTORY_SEPARATOR . 'TEMP';
  }
  
  
  // Lock Files, there are per-folder locks for every folder stored under the access file root
  // the collection's lock resides next to its own .access file 
  // subfile locks exist in thier nested access direcotires respectively. 
  function IH_GetLockFileForGivenPath($folderStr) // given '/MyCol1/Folder/blah/' -> return 'Meta/Access/MyCol1/Folder/blah/.lock'  
  {
    return IH_MetaCollectionsAccessRoot() .  $folderStr . '.LOCK' ; 
  }
  
  function IH_GetCollectionNameFromFolderStr($folderStr) // assume sanitized input '/a/b/c/', '/a/'
  {
    $tokensArr = explode('/', trim($folderStr,'/'));
    return $tokensArr[0];
  }
  
  function IH_CollectionMetaDirsArr($collectionStr) // get a list of the various program directories/files that should exist for a given COLLECTION .
  {
    $accessDirPath = IH_MetaCollectionsAccessRoot() . '/' . $collectionStr; // . '/.access';
    $indexDirPath   = IH_MetaCollectionsIndexRoot() . '/' . $collectionStr; 
    $iharDirPath    = IH_MetaCollectionsRoot() . '/' . $collectionStr; 
    
    return array( $accessDirPath, $indexDirPath, $iharDirPath ); 
  }
  function IH_FolderMetaDirsArr($folderStr) // get a list of the various program directories/files that should exist for a given FOLDER . input: '/MyCol1/Folder01/' 
  {
    $accessDirPath = IH_MetaCollectionsAccessRoot() .  $folderStr; 
    $indexDirPath   = IH_MetaCollectionsIndexRoot() .  $folderStr; 
    $iharDirPath    = IH_MetaCollectionsRoot() .       $folderStr; 
    
    return array( $accessDirPath, $indexDirPath, $iharDirPath ); 
  }
  
  function IH_GetTimestamp()
  {
    return date('Y-m-d_H:i:s') ;
  }
  
  function IH_FormatTimestamp($timeIn)
  {
    return date('Y-m-d_H:i:s', $timeIn) ;
  }
  
  
  // Basic Comment Functions...
  function IH_CommentCollectionsRoot()
  {
    return IH_Meta() . DIRECTORY_SEPARATOR . 'Cmt';
  }
  function IH_GetCommentFileLocation($folderStr, $fileStr) // returns the FOLDER where the given comment files (.comment/.lock) for a given folder or file reside
  {
    if(strcmp($fileStr,'')!==0) // if file is supplied
      $fileStr .= DIRECTORY_SEPARATOR; // should end in trailing slash 
    
    return IH_CommentCollectionsRoot() . $folderStr . $fileStr ; // 'Meta/Cmt' . '/MyCol1/abc.jpg/' 
  }
  function IH_ItemHasComments($folderStr, $fileStr)
  {
    $path = IH_GetCommentFileLocation($folderStr, $fileStr);
    if( file_exists( $path . '.comment' ) && file_exists( $path . '.lock' ) )
      return true;
    
    return false;        
  }
  function IH_DeleteComments($folderStr, $fileStr) // remove the entire folder and .comment/.lock file 
  {
    $commentFolderPath = IH_GetCommentFileLocation($folderStr, $fileStr);

    if(is_dir($commentFolderPath))
      shell_exec("rm -rf " . escapeshellarg( $commentFolderPath ));
  }
  
  
  // HASHING FNs
  function IH_ApplyCrypt($inputStr, $saltStr)
  {
    $saltSettingsStr = '$6$rounds=500000$' . $saltStr . '$'; // SHA-512
    return crypt($inputStr, $saltSettingsStr);
  }
  // pre php5.6.0 implementation of const time str compare
  if(!function_exists('hash_equals')) 
  {
    function hash_equals($str1, $str2) 
    {
      if(strlen($str1) != strlen($str2)) 
      {
        return false;
      } 
      else 
      {
        $res = $str1 ^ $str2; // xor, makes a bit vector of differences between them, $res is a string of potentially many non-printable characters.
        // res shouldnt be considerd a string at this point, ie. in the case of equal strings it is an array of ints, more or less, all with values as \x00
          //echo ("RES: " . strlen($res). ' ' . bin2hex($res) . "<br>\r\n");
          
        // the rest is just basically 'adding' the values of each char up and seeing if its still zero at the end. 
        $ret = 0;
        for($i = strlen($res) - 1; $i >= 0; $i--) 
        {
          $ret |= ord($res[$i]); // getting the int val of the char at i
          //echo (ord($res[$i]) . "<br>\r\n"); 
        }
        
        //echo ("At End: " . bin2hex($ret) . ' ' . $ret . "<br>\r\n");
        //echo ("At End!: " . bin2hex(!$ret) . ' ' . !$ret . "<br>\r\n");
        
        // at this point if they're equal, $ret will contain all zeros
        // http://php.net/manual/en/function.boolval.php
        return !$ret;
      }
    }
  }
  
  
  
  
  
  // SESSION / USER ACCOUNT FNs
  function IH_GetInstanceName()
  {
    return IH_INST_NAME;   
  }
  function IH_GetLogonCookieName() // the cookie named by this stores what we fill in the logon field for the next time we logon
  {
    return 'ImgHub-' . IH_GetInstanceName() . '-Username';
  }
  function IH_GetUserSessionVariable()
  {
    return "".IH_GetInstanceName()."-"."UserName";
  }
  function IH_SessionStart() // session shim
  {
    // **PREVENTING SESSION HIJACKING**
    // Prevents javascript XSS attacks aimed to steal the session ID
  //ini_set('session.cookie_httponly', 1);

    // **PREVENTING SESSION FIXATION**
    // Session ID cannot be passed through URLs
  //ini_set('session.use_only_cookies', 1);

    // Uses a secure connection (HTTPS) if possible
  //ini_set('session.cookie_secure', 1);
  
    //session_set_cookie_params( $lifetime, $path,  $domain, $secure, $httponly);
    session_set_cookie_params(0, '/', '', isset($_SERVER["HTTPS"]), true);

    session_start();
  }
  function IH_SessionClose() // session shim
  {
    session_write_close();
  }
  function IH_LogOnThisUser($username)
  {
    $var = IH_GetUserSessionVariable();
    $_SESSION[$var]=$username;

    // Set a Server-side modification token required for all POST method MOD functionality. CSRF
    $token = bin2hex(openssl_random_pseudo_bytes(32)) ;
    $_SESSION[IH_GetInstanceName().'-modtoken'] = $token;
    
    // Session Option for whether to show delete icon under your comments
    $_SESSION[IH_GetInstanceName().'-ShowCmtDelete'] = 'false';
    
    // Clipboard Var
    $_SESSION[IH_GetInstanceName().'-Clipboard'] = ''; // empty
  }
  function IH_LogOffThisUser()
  {
    unset( $_SESSION[ IH_GetUserSessionVariable() ] ); // wipes out ONLY the entry in the session file corresponding to the instance-username
    
    unset( $_SESSION[IH_GetInstanceName().'-modtoken'] );
    
    unset( $_SESSION[IH_GetInstanceName().'-ShowCmtDelete'] );
    
    unset( $_SESSION[IH_GetInstanceName().'-Clipboard'] );
  }
  function IH_GetUserName()
  {
  	return $_SESSION[IH_GetUserSessionVariable()] ;
  }
  function IH_IsLoggedIn() // checks the session vars of the current cookie
  {
  	$var = IH_GetUserSessionVariable();
  	if(isset($_SESSION[$var]))
	  return true;

    return false;
  }
  function IH_IsLoggedInAsAdmin()
  {
  	$var = IH_GetUserSessionVariable();
  	if(isset($_SESSION[$var]) && strcasecmp($_SESSION[$var], "admin") == 0)
	  return true;

	  return false;
  }
  
  
  // ========================================================================================
  // INPUT VALIDATION CHECKERS
  function IH_IsValidUsername($usernameStr) 
  {
    if (strlen($usernameStr) == 0) 
      return false;
    if (strlen($usernameStr) > 64) 
      return false;
    
    // Whitelist checking
    $whitelist = USERNAME_CHAR_WHITELIST;
    for ($x = 0; $x < strlen($usernameStr); $x++) // iterates through whitelist characters of the username 
    {
      $pos = strpos($whitelist, substr($usernameStr, $x, 1) ); 
      if ($pos === false) // the x'th char of input was not located in the set of valid whitelist characters 
        return false;
    } 
    
    /* Subsequent Illegal character check...
    $searchArr  = array('[',']','{','}','(',')','<','>',';',':','/','\\','?','!','.',',');
    $replaceArr = array('');
    $processedStr = str_replace($searchArr, $replaceArr, $usernameStr);
    
    if(strcmp($processedStr, $usernameStr) !== 0 ) // if they aren't the same.
      return false;*/
    
    return true;
  }
  
  // for ensuring the "folderStr" path lies under a respective data/meta folder prefix "folderPrefixStr"
  // folder str could also point to file, caller should subsequently verify if its a folder if necessary
  function IH_ValidateFolderPath ($folderStr, $folderPrefixStr)
  {
    $realStr1 = realpath($folderStr); // will either be NULL if nonexistant or point to sth
    $realStr2 = realpath($folderPrefixStr); // SHOULD BE SAFE ALREADY
    if($realStr1 === false ) //if it wasnt there
      return false;
    
    $pos = strpos($realStr1, $realStr2);//find first occurence of str2 in str1.
    if($pos !== 0)
      return false;
    else
      return true;
  }
  
  // Sanitize and MODIFY folderStr
  function IH_SanitizeBaseArg(&$fol)
  {
    //DEFAULTS
    $folDefault = '/'; // root 
    
    if(is_string($fol))
    {
      // Remove known trouble characters, and make sure something still remains, otherwise set to default root char '/'
      
      // Control Character removal (00-31,127)
      preg_replace('/[\x00-\x1F\x7F]/', '', $fol); // will work with mb
      
      // trim space from ends 
      $fol = trim($fol);
      
      // ensure leading slash
      if(mb_strlen($fol) > 0)
      {
        if(strcmp( '/', mb_substr($fol, 0, 1) ) !== 0) 
          $fol = '/' . $fol;
      }
      else
        $fol = $folDefault;
      
      // ensure trailing slash...
      if ( strcmp('/', mb_substr($fol, -1)) !==0)
        $fol .= '/';
      
      if(strpos($fol, '//') !== false) // if $fol contains '//'
      {
        $fol = $folDefault;
        return true;
      }
      
      // Check if folders(Data/Meta) exists (with realpath) under a specific root
      $data = IH_DataCollectionsRoot() . $fol; // 'Data' . '/' 
      $meta = IH_MetaCollectionsRoot() . $fol; // 'Meta' . '/' 
      if(IH_ValidateFolderPath($data, IH_DataCollectionsRoot()) /* && 
         IH_ValidateFolderPath($meta, IH_MetaCollectionsRoot()) && 
         is_dir($data) && is_dir($meta) */ )
      {
        return false;
      }
      else
      {
        $fol = $folDefault;
        return true;
      }
    }
    $fol = $folDefault;
    return true;
  }
  
  // Called to check the new file/folder name candidate before making folder/moving uploaded file to it.
  // Called anytime a Creation event occurs
  function IH_IsValidFilename($newNameStr)
  {
    if(is_string($newNameStr))
    {
      // can't be an empty string for a name
      if(strcmp($newNameStr, '') === 0)
        return false;
      
      if(strcmp($newNameStr, '.') === 0)
        return false;
      
      // No .filenames (hidden), glob chokes and can't be trivially rectified without causing something else to break, ie. '{}' chars
      // still good enough for now.
      if(mb_strpos($newNameStr, '.') === 0)
        return false;
      
      if(mb_strpos($newNameStr, '~') === 0) // can't start with '~'
        return false;
      
      // '[]' brackets are a mess with our friend glob
      if(mb_strpos($newNameStr, '[') !== false) 
        return false;
      if(mb_strpos($newNameStr, ']') !== false) 
        return false;
      
      // no double periods anywhere
      if(mb_strpos($newNameStr, '..') !== false)
        return false;
      
      // no slashes anywhere
      if(mb_strpos($newNameStr, '/') !== false)
        return false;
      
      // no backslashes anywhere
      if(mb_strpos($newNameStr, "\\") !== false)
        return false;
      
      // no semicolon (for terminal commands)
      if(mb_strpos($newNameStr, ';') !== false)
        return false;
      
      // Control Character detection (00-31,127)
      if(preg_match('/[\x00-\x1F\x7F]/', $newNameStr))
        return false;
            
      return true;
    }
    return false;
  }
  
  function IH_NormalizePageVar($pageVar) // takes the page param and makes sure it is an integer between 1 and 1000000 
  {
    if(isset($pageVar))
    {
      if(is_numeric($pageVar))
      {
        $iv = intval($pageVar);
        if( $pageVar == $iv )
        {
          $pageVar = $iv;
          if($pageVar >= 1 && $pageVar <= 10000000)
            return $pageVar;
        }
      }
    }
    
    return 1;
  }
  
  
  // REDIRECTS =================================================================================
  function IH_RedirMessageHalt($folderStr, $msgString, $bDisplayTargPath)
  {
    $errMsg = $msgString ;
    
    if($bDisplayTargPath)
      $errMsg .= " ( " . trim($folderStr,'/') . " )"; 
    
    header("Location: .?fol=" . rawurlencode($folderStr) . "&msg=" . rawurlencode($errMsg));
    die();
  }
  function IH_RawRedirMessageHalt($rawPathStr, $msgString) // more stripped-down version of the above to forward to anywhere/any combo of params
  {
    header("Location: " . ($rawPathStr) . "&msg=" . rawurlencode($msgString));
    die();
  }
  
  // COLLECTION ACCESS FUNCTIONS ===============================================================
  // Collection Access File Format
  //
  // Line1:  owner
  // Line2:  access level
  // Line3:  comma separated users list (who is allowed to add/modify files, and also view files when access levels is set to Restricted) 
  //
  // ex.
  // admin
  // ACCESS_PUBLIC
  // user1,user2,user3
  
  // gets the meta file path for the associated collection 
  function IH_GetCollectionFilePath($collectionStr)
  {
    return IH_MetaCollectionsAccessRoot() . DIRECTORY_SEPARATOR . $collectionStr . DIRECTORY_SEPARATOR . '.access' ; 
  }
  
  // Gets an array of all fields in collection access file for given collection  
  function IH_GetCollectionMetaArr($collectionStr)
  {
    $pathStr = IH_GetCollectionFilePath($collectionStr);
    
    if(!file_exists($pathStr))
      return false; // signifying that the collection was just dropped into the Data dir, not processed yet.
    
    $toReturnArr = array(); // $toReturnArr[] = $token;
    
    $handle = fopen($pathStr, "r");
    
    if ($handle)
    {
      $lineStr = '';
      while (($lineStr = fgets($handle)) !== false) // gets the next line
      {
        $toReturnArr[] = str_replace("\r\n", '', $lineStr); // add it after removing crlf
      }
      fclose($handle);
    }
    return $toReturnArr;
  }
  
  function IH_GetCollectionOwner($collectionStr)
  {
    $collectionArr = IH_GetCollectionMetaArr($collectionStr);
    
    if($collectionArr === false)
      return "?null?" ; // this user means the access file for the given collection does not exist.
    
    $ownerStr = $collectionArr[0]; // the owner is the first line
    
    return $ownerStr; // Maybe do a validate here someday if we're worried about what the collection meta file contains. 
  }
  
  function IH_GetCollectionAccess($collectionStr) // returns the access-levels value (-1, 0, 1, 2, or 3)
  {
    $collectionArr = IH_GetCollectionMetaArr($collectionStr);
    
    if($collectionArr === false)
      return AccessLevels::ACCESS_VOID ; 
    
    $accessLevelStr = $collectionArr[1]; // accessLevel is the second line
    
    return $accessLevelStr; // Maybe do a validate here someday if we're worried about what the collection meta file contains.
  }
  
  // checks that the user is part of the 'approved users list', 
  // which allows them to view restricted collections, 
  function IH_IsUserInCollection($collectionStr, $usernameStr)
  {
    // if you're on the list.
    $collectionArr = IH_GetCollectionMetaArr($collectionStr);
    
    if($collectionArr === false)
      return false;
    
    $usersListStr = $collectionArr[2]; // get third line, should be of the form "user1,user2,userETC" 
    
    $usersListArr = explode(',', $usersListStr); // array of users in the approved list
    
    for($i = 0 ; $i < count($usersListArr) ; $i++)
    {
      if(strcasecmp($usersListArr[$i], $usernameStr) === 0 )
        return true;
    }    
    return false;
  }
  
  // does a given user have the ability to access(viewcontents) or see a given collection displayed on the homepage for pagination 
  function IH_CanUserReadCollection($collectionStr, $usernameStr)
  {
    //short circuit
    if(strcasecmp($usernameStr, 'admin') === 0)
      return true;
    
    // if you're the owner
    if( strcasecmp(IH_GetCollectionOwner($collectionStr), $usernameStr) === 0 )
      return true;
    
    $currentAccess = IH_GetCollectionAccess($collectionStr); // attempt to retrieve access levels from .access file...
    
    // If the $currentAcess can't be retrieved, signal a warning message. 
    if($currentAccess == AccessLevels::ACCESS_VOID)
      IH_RedirMessageHalt('/', "Could not retrieve the .access for (" . $collectionStr . ")" , false); // stops further page loading. 
    
    // enumerate success states (there are less of them than fail states)
    // col is public = SUCCESS
    // col is user & we are any old user = SUCCESS
    // col is restricted and we're logged in as someone on that list OR 'admin'
    // col is admin and we are 'admin' too! (very rare however)
    if( $currentAccess == AccessLevels::ACCESS_PUBLIC ) // has to be "loose" (==) equivalence here, again, thanks php
      return true;
    else if( $currentAccess == AccessLevels::ACCESS_USER && (strcmp($usernameStr, '') !== 0) )
      return true;
    else if( $currentAccess == AccessLevels::ACCESS_RESTRICTED && (strcmp($usernameStr, '') !== 0) && IH_IsUserInCollection($collectionStr, $usernameStr) )
      return true;
    
    return false; 
  }
  
  // needs to be either admin or the collection owner. 
  function IH_CanUserModCollection($collectionStr, $usernameStr) // modifying the collection/folder  (folderedit.php)
  {
    //short circuit
    if(strcasecmp($usernameStr, 'admin') === 0)
      return true;
    
    // if you're the owner
    if( strcasecmp(IH_GetCollectionOwner($collectionStr), $usernameStr) === 0 )
      return true;  
    
    return false;
  }
  
  // who can upload/comment to an existing folder
  function IH_CanUserUploadCollection($collectionStr, $usernameStr)
  {
    //short circuit
    if(strcasecmp($usernameStr, 'admin') === 0)
      return true;
    
    // if you're the owner
    if( strcasecmp(IH_GetCollectionOwner($collectionStr), $usernameStr) === 0 )
      return true;
    
    $currentAccess = IH_GetCollectionAccess($collectionStr); // attempt to retrieve access levels from .access file...
    if( ($currentAccess == AccessLevels::ACCESS_PUBLIC || $currentAccess == AccessLevels::ACCESS_USER) && (strcmp($usernameStr, '') !== 0) ) // pub or user, need to be logged in 
      return true;
    else if( $currentAccess == AccessLevels::ACCESS_RESTRICTED && (strcmp($usernameStr, '') !== 0) && IH_IsUserInCollection($collectionStr, $usernameStr) )
      return true;
    
    return false;
  }
  
  
  function my_mime_content_type($filename) 
  {
    $finfo = new finfo(FILEINFO_MIME);
    $type  = $finfo->file($filename);
    return $type;
  }
  // Pass a resource, filename(basename, not including data dir path), and an array of strings denoting the mime type.
  // It will retrieve from meta file and compare.
  // Returns: -1 (failure / no match found)
  //          i (matches the ith type in the array)
  function FileIsOfMIMEType($res, $filename, $typeArr)
  {
    if(is_array($typeArr))
    {
      //Now validate file's previously-generated mime type
      $metaMIME=ReadMetaFileLine(MetaCacheFolderName() . DIRECTORY_SEPARATOR . $res . DIRECTORY_SEPARATOR . $filename, 2);
      $metaMIME = substr($metaMIME, 0, strpos($metaMIME, ';') ); // peel off unnecessary encoding after semicolon

      // Match to at least one value in array 
      $typeArrLen = count($typeArr);
      for($i = 0; $i < $typeArrLen; $i++)
      {
        if(strcmp($metaMIME, $typeArr[$i]) === 0)
          return $i;
      }
    }
    return -1; // failure
  }
  
  function GetRandTail($len) 
  {
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';   
    $string = '';
    for ($i = 0; $i < $len; $i++) 
    {
      $string .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $string;
  }
  
  // TODO: change name of this fn and callers
  function GetIndexIthFileAsArr($folderStr, $sortType, $indexFileNum) // folderStr is assumed to be '/MyCol1/' for example, as in the folderStrGlobal context 
  {
    $indexFileStr = '~' . $sortType . '_' . $indexFileNum . '.txt' ; // "~A_0.txt"
    return @file(IH_MetaCollectionsIndexRoot() . $folderStr . $indexFileStr , FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );  // loads the file into the array, line by line
  }
  
  function IH_GetFolderTotalSize($folderStr)
  {
    $curSize = 0;
    
    $zerothIndexArr = GetIndexIthFileAsArr($folderStr, 'A', 0);
    
    if($zerothIndexArr && isset($zerothIndexArr[4]))
      $curSize += $zerothIndexArr[4] ;
    
    // Visit children
    $folderIndexFilename = IH_MetaCollectionsIndexRoot() . $folderStr . '.folders';
    if(file_exists($folderIndexFilename)) // load it and tack on some dropdown content
    {
      $subFolderArr = file($folderIndexFilename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
      if($subFolderArr !== FALSE && count($subFolderArr) > 0 )
      {
        foreach($subFolderArr as $item)
        {
          $curSize += IH_GetFolderTotalSize($folderStr . $item . '/');
        }
      }
    }
    
    return $curSize;
  }
  
  // ===========================
  // GET/OUTPUT Thumbs and Metadata
  // "SHOULD" assume all thumb variants are jpgs...
  function IH_OutputImage_IHAR($pathToIHAR, $Type)
  {
    $bMatched = false;
    // =============================================================================
  	// $Type
  	// Block Unit Types
    // 0x01 "MicroThumb" (as seen from the default grid collection view)
    // 0x02 "MedThumb" (intermediate sized thumb when you click to view it, fills up "most" of the screen)
    // 0x03 "Metadata text" misc. text info
    // 0x04 "Processed Video"

    $fh = fopen($pathToIHAR, "rb");
    if($fh)
    {
      while (!feof($fh))
      {
        if( ($fr1 = fread($fh, 1)) && !feof($fh)) // read a byte (type byte)
          $typeByteArr = unpack('c', $fr1 ); // signed char (-128 to 127) or somewhere thereabouts 
        else 
          break;
        
        if( ($fr2 = fread($fh, 4)) && !feof($fh)) // 4 bytes 
          $dataSizeArr = unpack('N', $fr2 ); // unsigned long (always 32 bit, big endian byte order)
        else
          break;
        
        $typeByte = $typeByteArr[1]; // for some reason,
        $dataSize = $dataSizeArr[1]; // these unpacked arrays start index at 1 as per convention
        

        if($typeByte != $Type) // Skip ahead to next stanza and continue 
        {
          if($dataSize > 0) 
            fseek($fh, $dataSize, SEEK_CUR);
        }
        else
        {
          $bMatched = true;
          if($Type == 3) // meta textfile 
          {
            $metaDataStr = fread($fh, $dataSize);
            fclose($fh);
            return $metaDataStr;
          }
          else if($Type == 1 || $Type == 2) // micro/medium thumbs, assume jpg
          {
            // send Last Modified Header.            
            header("Last-Modified: ".gmdate("D, d M Y H:i:s", filemtime($pathToIHAR))." GMT");
            
            header('Content-type: '.'image/jpeg');
            
            header('Content-length: '.$dataSize);
            
            // send this cache-control mechanism
            header('Cache-Control: private, max-age=' . IHAR_CACHE_AGE); 
            
            echo fread($fh, $dataSize);
          }
          else if($Type == 4) // ======== VIDEO ======== 
          {
            $bPartial = false;
            $start = 0;
            $end = $dataSize - 1;
            
            if ( isset($_SERVER['HTTP_RANGE']) ) 
            {
              // Parse the range header to get the byte offset
              $ranges = array_map(
                  'intval', // Parse the parts into integer
                  explode(
                      '-', // The range separator
                      substr($_SERVER['HTTP_RANGE'], 6) // Skip the `bytes=` part of the header
                  )
              );
              
              // If the last range param is empty, it means the EOF (End of File)
              if(!$ranges[1])
                $ranges[1] = $dataSize - 1;

              $start = $ranges[0];
              $end = $ranges[1];
              
              //error_log( "START->  " . $start . "     END-> " . $end  ); 
              
              $bPartial = true; 
            }
            
            // if range parsing successful            
            header("Last-Modified: ".gmdate("D, d M Y H:i:s", filemtime($pathToIHAR))." GMT");  
            
            header('Content-type: '.'video/mp4'); 
            
            // send this cache-control mechanism
            header('Cache-Control: private, max-age=' . IHAR_CACHE_AGE); 
            
            //header('Content-Disposition: attachment; filename="' . basename($canonicalPath) . '"'); 
            
            if($bPartial)
            {
              header('Accept-Ranges: bytes');
              
              header('Content-length: '. ($end - $start + 1));// IS DIFFERENCE IN THE CONTENT RANGE + 1 
              
              header('Content-Range: bytes ' . $start . '-' . $end . '/' . $dataSize );
              
              header('HTTP/1.1 206 Partial Content');
            }
            else
              header('Content-length: '.  $dataSize  );

            if($bPartial)
            {
              // seek to the requested offset, this is 0 if it's not a partial content request
              fseek($fh, $start, SEEK_CUR);
              echo fread($fh, ($end - $start + 1));
            }
            else
            {
              echo fread($fh, $dataSize); // normal (full file) read
            }
            
          }
          break;
        }
      } // end while
      fclose($fh);
    }

    return $bMatched;
  }
  
  
?>