<?php

  // Modification Functions
  // all modification to program data happens though this include file
  
  // Concurrency
  function IH_GetFolderLock($folderStr) // expects '/MyCol1/' or '/a/b/c/d/'
  {
    $lockFilename = IH_GetLockFileForGivenPath($folderStr);
    touch ($lockFilename);
    $fp = fopen($lockFilename, "r+");
    if($fp)
    {
      if(flock($fp, LOCK_EX)) // should block if unavailable
        return $fp;
      else
        return false;      
    }
    else
      return false; 
  }
  function IH_ReleaseFolderLock($filePointer)
  {
    flock($filePointer, LOCK_UN);
    fclose($filePointer);
  }
  // USAGE
  /* if( ($fp = IH_GetFolderLock("abc")) !== false)
  {
    // do work here     
    IH_ReleaseFolderLock($fp);
  } */
  
  // Returns "$filename + $suffix" which is the first to NOT exist under the supplied path with the given extension 
  function IH_NameAdjuster($path, $filename, $extension)// <-- extension must include the dot (.jpg not jpg)
  {
    $suffix = '';
    $potential = $path . $filename . $suffix . $extension; // ie. 'Data/Files/talkin&walkin/talking and walking/' . 'xyz' . '(02)' . '.jpg'
    
    $counter = 2;
    while(file_exists($potential))
    {
      $counterStr = '';
      if($counter < 10)
        $counterStr = '00' . $counter;
      else
      if($counter < 100)
        $counterStr = '0' . $counter;
      else
        $counterStr = '' . $counter;
      
      $suffix = ' (' . $counterStr . ')';
      
      $potential = $path . $filename . $suffix . $extension;
      $counter++;
    }
    return ($filename . $suffix);
  }
  
  function IH_NameAdjuster2($folderStr, $fileStr) // folderStr = '/MyCol1/'   fileStr = 'abc.jpg'   
  {
    $path_info1 = pathinfo($fileStr);
    $path_info1_extension = strtolower($path_info1['extension']) ; // ie. "jpg", "png" 
    $path_info1_filename = $path_info1['filename']; // yields an EXTENSION-LESS name of the file
    
    $finalExtension = '';
    if(strlen($path_info1_extension) > 0)
      $finalExtension = '.' . $path_info1_extension ;
    
    return IH_NameAdjuster(IH_DataCollectionsRoot() . $folderStr, $path_info1_filename, $finalExtension ) . $finalExtension ;
  }
  
  function IH_NameAdjuster3($realFilePathStr) // like '2', but takes just the path to the file, for working on data dir paths directly  
  {
    $path_info1 = pathinfo($realFilePathStr);
    $path_info1_extension = strtolower($path_info1['extension']) ; // ie. "jpg", "png" 
    $path_info1_filename = $path_info1['filename']; // yields an EXTENSION-LESS name of the file
    $path_info1_dirname = $path_info1['dirname'] . '/'; // ends dir name in slash 
    
    $finalExtension = '';
    if(strlen($path_info1_extension) > 0)
      $finalExtension = '.' . $path_info1_extension ;
    
    return IH_NameAdjuster($path_info1_dirname, $path_info1_filename, $finalExtension ) . $finalExtension ;
  }
  
  function IH_DeleteFile($filePathStr) // canonical location of file from within program   $filePathStr = '/MyCol1/abc.jpg' 
  {
    // Delete Source File
    unlink(IH_DataCollectionsRoot() . $filePathStr);
    
    // Delete IHAR of source file
    unlink(IH_MetaCollectionsRoot() . $filePathStr . '.IHAR' );
    
    // TODO: use IH_DeleteComments
    
    if(file_exists( IH_CommentCollectionsRoot() . $filePathStr . '/.comment' ))
    {
      $path = escapeshellarg(IH_CommentCollectionsRoot() . $filePathStr);
      // Delete Comments 
      shell_exec("rm -f " . $path . '/.comment'); 
      shell_exec("rm -f " . $path . '/.lock'); 
      shell_exec("rmdir " . $path ); // the dir itself 
    }
  }
  
  // 1.) Assume only the data dir exists
  // 2.) make enough to lock it, and do so
  // 3.) create access file assigned to admin.
  // 4.) make rest of indexes recursively, then start off IHAR generation 
  function IH_InitializeCollection($collectionStr, $usernameStr) // should be name of the folder such as 'MyCol1' 
  {
    $dirsArr = IH_CollectionMetaDirsArr($collectionStr);
    $accessDirPath  = $dirsArr[0];
    $indexDirPath   = $dirsArr[1]; 
    $iharDirPath    = $dirsArr[2]; 
    mkdir( $accessDirPath );
    mkdir( $indexDirPath );
    mkdir( $iharDirPath );
    
    // MAKE .ACCESS FILE  
    // Line1:  owner
    // Line2:  access level
    // Line3:  users list 
    touch(            $accessDirPath . '/.access' );
    $handle = fopen( ($accessDirPath . '/.access') , 'w');
    if($handle)
    {                    
      fwrite($handle, $usernameStr . "\r\n");  // collection owner                          
      fwrite($handle, AccessLevels::ACCESS_RESTRICTED . "\r\n"); // collection access level
      fwrite($handle, '' . "\r\n");                              // members list      
      fclose($handle);
    }    
    
    // The "Collection" is also a folder, run init on it and recurse to its kids 
    $iharPathsArr = IH_InitializeFolder('/' . $collectionStr . '/', true);   // returns 'canonical' paths of images which need ihar generation 
    
    IH_InitiateIHARMaker($iharPathsArr);
  }
  function IH_InitiateIHARMaker($iharPathsArr) // PHP only really copies variable content if that content is changed. So pass-by-reference is probably not necessary here. 
  {
    // pass a list of all files which will be passed to the IHAR generate function...
    // list needs to be in a file since it will be run from cli asynchronously 
    if($iharPathsArr !== false)
    {
      $randTail = '';
      do
      {
        $randTail = GetRandTail(16);
        $randPath = IH_MetaTEMPRoot() . '/' . $randTail ;
      }while(file_exists($randPath));
      
      $fh = fopen( $randPath , 'w');
      if($fh)
      {
        foreach($iharPathsArr as $row)
          fwrite($fh, $row . "\r\n");
         
        fclose($fh);
      }    
      
      // call the cli-wrapper async
      $cmd = "php cli-worker.php" . " gen-ihars " . $randTail ;
      shell_exec($cmd . " > /dev/null 2> /dev/null & "); 
    }
  }
  function IH_InitializeFolder($folderStr, $bRecursive) // $folderStr ('/MyCol1/') or ('/a/b/c/d/') etc
  {
    // Ensure the Meta directories for this corresponding folder are there. 
    $dirsArr = IH_FolderMetaDirsArr($folderStr);
    $accessDirPath  = $dirsArr[0];
    $indexDirPath   = $dirsArr[1]; 
    $iharDirPath    = $dirsArr[2]; 
    if(!file_exists($accessDirPath))
      mkdir( $accessDirPath );
    if(!file_exists($indexDirPath))
      mkdir( $indexDirPath );
    if(!file_exists($iharDirPath))
      mkdir( $iharDirPath );
    
    $fileListArr = false; // list of 'canonical' paths to files ie. '/MyCol1/Somefolder/abc.jpg' (these files were indexed this go around. 
    
    // FIRST LOCK 'THIS' FOLDER
    if( ($fp = IH_GetFolderLock($folderStr)) !== false)
    {    
      // generate index 
      $fileListArr = IH_Create_Index_Files($folderStr, IMGS_PER_PAGE);
      
      // now that we have the .folder file with the folders, use that to branch down      
      if($bRecursive)
      {
        // if .folders exists, it can be empty (no subfolders)
        $foldersFilePath = $indexDirPath . '.folders' ;
        if(file_exists($foldersFilePath) && (filesize($foldersFilePath) > 0))
        {
          $foldersArr = file( $foldersFilePath , FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
          if(!$foldersArr) 
          {
            echo("Error: .folders file format inconsistent... " . $folderStr );
            die();
          }
          foreach($foldersArr as $fold)
          {
            $fileListArr = array_merge($fileListArr, IH_InitializeFolder($folderStr . basename($fold) .'/', $bRecursive) );
          }
        }
      }
      
      IH_ReleaseFolderLock($fp);
    }
    else
    {
      echo("ERROR: could not get lock! " . $collectionStr);
      die();
    } 
    return $fileListArr;  // can be big....  
  }
  
  // Index files are located in the corresponding directory under 'Meta/Index/<CollectionName/OptionalSubDir>' 
  // Input should at least have a collection, there is no index for '/'
  // Valid input -> '/MyCol1/'
  // Valid input -> '/MyCol1/MyFolder/' 
  //
  // Index File Naming Format 
  // "A" contain an alphabetized sort. 
  // .folders, ~A_0.txt, ~A_1.txt, ~A_2.txt, ~A_3.txt, etc. 
  function IH_Create_Index_Files($folderStr, $numImgsPerPage)
  {
    if(strcmp($folderStr,'/')===0) // safety
      return array();
      
    $retArr = array(); // list of 'canonical' paths to files ie. '/MyCol1/Somefolder/abc.jpg' (these files were indexed this go around. 
    
    // 'Data/Files' . '/MyCol1/' 
    $inputPath = IH_DataCollectionsRoot() . $folderStr ; 
    $filesArr = glob($inputPath . '*'); // one of only two(hopefully) calls to the cursed glob 
    
    $currentOutputPath = IH_MetaCollectionsIndexRoot() . $folderStr ;  
    
    // Delete All previous index files!  in specified Index Directory
    shell_exec("rm -f " . escapeshellarg($currentOutputPath) . '~*' ); // ie. 'Meta/Index' . '/MyCol1/' . '*' 
    shell_exec("rm -f " . escapeshellarg($currentOutputPath) . '.folders' ); // the folder index
    
//$currentItem = 1 ; // one per 'picture'
    $currentIndexFile = 1; // which page
    
    $indexPrefix = '~A_';
    $indexExten = '.txt';   
    
    $currentIndexFilename = $currentOutputPath . $indexPrefix . $currentIndexFile . $indexExten ;
    $folderIndexFilename = IH_MetaCollectionsIndexRoot() . $folderStr . '.folders';
    
    $fileCounter = 0;
    
    $sz_FolderMB = 0; // hope you're running 64 bit...
    
    $fh = fopen($currentIndexFilename, 'w');
    $fhFolders = fopen($folderIndexFilename, 'w'); 
    if($fh && $fhFolders)
    {
      foreach ($filesArr as $file)
      {
        //echo("<br>" . $file . "\r\n"); // debugging 
        if (is_file($file))
        {
          $fileCounter++; // we have a new file (img) to work with
          
          $sz_FolderMB += filesize($file);
          
          $basenameOfFile = basename($file);
          
          // TODO Ensure filename and all sections of the path (FOLDERS) conforms to valid standards (could be being run on files "dragged" to folder or FTPd there)
          /* if(!IH_IsValidFilename($basenameOfFile))
          {
            // Get existing extension if there is one (usually is the case)
            $path_info1 = pathinfo($file);
            $path_info1_extension = strtolower($path_info1['extension']) ; // won't have the dot 
            $path_info1_dirname = $path_info1['dirname'] . '/'; // ends dir name in slash 
            
            if(!empty($path_info1_extension)) // preserve the pre-existing extension if it had one 
              $basenameOfFileNew = 'File' . '.' . $path_info1_extension ; 
            else
              $basenameOfFileNew = 'File' ;
            
            $basenameOfFileNew = IH_NameAdjuster3($path_info1_dirname . $basenameOfFileNew); // this will give us a basename which is not already in use...
          } */
          
          fwrite($fh, $basenameOfFile . "\r\n" ); // write it to the file  

          $retArr[] = $folderStr . $basenameOfFile;          
          
          if($fileCounter % $numImgsPerPage == 0 ) // at this point we've done the last one for the current page, move on to the next page 
          {
            fclose($fh);
            $currentIndexFile++ ; 
            $currentIndexFilename = $currentOutputPath . $indexPrefix . $currentIndexFile . $indexExten ; 
            $fh = fopen($currentIndexFilename, 'w');
          }
          //$currentItem++;          
          //IH_CreateIHAR($folStr, basename($file));
        } 
        else // folders 
        {
          fwrite($fhFolders, basename($file) . "\r\n");
        }
      }
      fclose($fh);
      //Check the last file written to, delete it if its size is 0 bytes.
      if(filesize($currentIndexFilename)===0) //  happens when the number of images in the index is an exact multiple of the numImgsPerPage
        unlink($currentIndexFilename);
      
      // ZEROTH INDEX FILE 
      // Line1: number of images per page (for this specific Album/folder at generation time)
      // Line2: total number of images, in the index
      // Line3: num pages 1-n 
      // Line4: Index State tag
      // Line5: folder size ~MB
      if($fileCounter == 0)
        $currentIndexFile = 0; // makes sense that if theres no imgs then theres no pages A1 and above. 
      else if($fileCounter % $numImgsPerPage == 0) // if num files is an even multiple, the page value is one too many
        $currentIndexFile--; // minus 1 
      $fh = fopen( ($currentOutputPath . '~A_0.txt') , 'w'); 
        fwrite($fh, $numImgsPerPage . "\r\n" );  //images per page
        fwrite($fh, $fileCounter . "\r\n" );  // num images
        fwrite($fh, $currentIndexFile . "\r\n" ); // num pages(not including zeroth)
        fwrite($fh, GetRandTail(3) . "\r\n" ); // kind of like an E-Tag, branding 'this' generation of the index. This will feed a dummy param on each image, which overrides the cache if this folder is reindexed.
        fwrite($fh, round(( $sz_FolderMB/1024/1024), 2) . "\r\n" ); // size of folder in MiB 
      fclose($fh); 
      fclose($fhFolders);      
    }
    else
    {
      //TODO: error message GET arg, redirect header. 
    }  
    return $retArr;     
  }
  
  // .IHAR (ImageHub Archive) Creation Function 
  function IH_CreateIHAR($canonicalFilenameStr) // non-absolute path to a file ie. '/MyCol1/Folder1/myimg.jpg' 
  {
    $bImg = false; // when we parse the mime content type and determine its a pic, set this accordingly 
    $bVid = false; // likewise for video files 
    $bOriented = false;// true if orientation metadata (exif) exists and is set to something other than '1' 
    $tempOrientedFile = '';
    $sz_Name = 12; // for temp names
    $tempDirPath = IH_MetaTEMPRoot();
    $tempMinorThumb = '';
    $tempMedThumb = '';
    $tempMetaFile = '';
    $processedVideoTemp = '';
    $stillTemp = '';
    do
    {
      $tempMinorThumb = $tempDirPath . DIRECTORY_SEPARATOR . GetRandTail($sz_Name) . '.jpg' ; // grid thumb
    } while(file_exists($tempMinorThumb));
    do
    {
      $tempMedThumb = $tempDirPath . DIRECTORY_SEPARATOR . GetRandTail($sz_Name) . '.jpg' ; // single image thumb
    } while(file_exists($tempMedThumb));
    do
    {
      $tempMetaFile = $tempDirPath . DIRECTORY_SEPARATOR . GetRandTail($sz_Name) . '.txt' ; // traditional "meta" file
    } while(file_exists($tempMetaFile));
    
    $inFile          = IH_DataCollectionsRoot() . $canonicalFilenameStr ;
    $finalOutputPath = IH_MetaCollectionsRoot() . $canonicalFilenameStr . '.IHAR'; // 'Meta/Files' . '/MyCol1/' . 'MyImg.jpg' . '.IHAR'
    
    if(file_exists($finalOutputPath)) // if we're invoked to create an IHAR, delete it if thers already one at the destination location 
      unlink($finalOutputPath);
    
    //at this point we have a file(graphic) residing in the Data root with arbitrary path $canonicalFilenameStr
    
    // 1.) Generate text file for storing Mime, dates, exif, whatever...
    $handle = fopen($tempMetaFile, 'w');
    if($handle)
    {
      $mimeStr = my_mime_content_type($inFile);
      fwrite($handle, $mimeStr . "\r\n"); // Line1: Mime Type
      
      if(in_array( (explode(';', $mimeStr)[0]), IH_GET_IMAGE_MIME_TYPES())) 
        $bImg = true;
      else
      if(in_array( (explode(';', $mimeStr)[0]), IH_GET_VIDEO_MIME_TYPES()))
        $bVid = true;
      
      $modDate = filemtime($inFile);
      fwrite($handle, $modDate . "\r\n"); // Line2: the time when the content of the file was changed, Unix timestamp 
      
      //fwrite($handle, "test" . "\r\n");
      
      fclose($handle);
    }
    
    if($bVid)
    {
      // Create a "watered down html5 compliant" version
      do
      {
        $processedVideoTemp = $tempDirPath . DIRECTORY_SEPARATOR . GetRandTail($sz_Name) . '.mp4' ; // singleview video
      } while(file_exists($processedVideoTemp));
      
      $cmdStr1 = FFMPEG_DOWNSAMPLE;
      $cmdStr1 = str_replace('?w?', VID_WIDTH,  $cmdStr1);
      $cmdStr1 = str_replace('?h?', VID_HEIGHT, $cmdStr1);
      $cmdStr1 = str_replace('?in?', escapeshellarg($inFile), $cmdStr1);
      $cmdStr1 = str_replace('?out?', $processedVideoTemp, $cmdStr1);
      
      shell_exec("nice -n 19 " . $cmdStr1);
      
      // create a still, to feed the thumb generation code and replace inFile with it...
      do
      {
        $stillTemp = $tempDirPath . DIRECTORY_SEPARATOR . GetRandTail($sz_Name) . '.jpg' ;
      } while(file_exists($stillTemp));
      
      $cmdStr2 = FFMPEG_SNAPSHOT;
      $cmdStr2 = str_replace('?in?', escapeshellarg($inFile), $cmdStr2);
      $cmdStr2 = str_replace('?out?', $stillTemp, $cmdStr2);
      
      shell_exec("nice -n 19 " . $cmdStr2);
      
      // now check that still temp exists and its mime is that of an img...
      if(file_exists($stillTemp))
      {
        if (strcasecmp(explode(';', my_mime_content_type($stillTemp))[0],"image/jpeg") === 0) // if stillTemps mime type is "image/jpeg"
        {
          $inFile = $stillTemp; 
          $bImg = true; // send it through the img codepath
        }
      }
    }
    
    if($bImg)
    {
      // Prep Step, determine frame number (ie. animated gifs), if more than one then run with flatten
      $bMultiFrame = false;
      $frameCnt = 1;
      $frameCnt = shell_exec("nice -n 19 identify -format %n " . escapeshellarg($inFile) );
      if($frameCnt > 1)
        $bMultiFrame = true;
      
      // Size Detect
      $detectedWidth = 0; $detectedHeight = 0;
      if(!$bMultiFrame)
      {
        $detectedWidth  = shell_exec("nice -n 19 identify -format %w " . escapeshellarg($inFile) );
        $detectedHeight = shell_exec("nice -n 19 identify -format %h " . escapeshellarg($inFile) );
      }
      else //$bMultiFrame
      { // generate a temp frame (flattened) without changing dimensions, then see what dimensions it has, then delete it!
        $tempFlatFrame = '';
        do
        {
          $tempFlatFrame = $tempDirPath . DIRECTORY_SEPARATOR . 'Flat-' . GetRandTail($sz_Name) . '.jpg' ; 
        } while(file_exists($tempFlatFrame));
        $flatFrameSett = "-format jpg -quality 70 -flatten" ;
        $cmd = "nice -n 19 convert " . escapeshellarg($inFile) . " " . $flatFrameSett . " " . escapeshellarg($tempFlatFrame) . " ";   
        $output = shell_exec($cmd);
        // Get the dimensions of this flat file , to see if med thumb (for singleview) needs different size values. 
        $detectedWidth  = shell_exec("nice -n 19 identify -format %w " . escapeshellarg($tempFlatFrame) );
        $detectedHeight = shell_exec("nice -n 19 identify -format %h " . escapeshellarg($tempFlatFrame) );
        
        unlink($tempFlatFrame); // then remove it. 
      }
      
      // Orientation Detect & Remove
      $orientResult = trim (shell_exec( "nice -n 19 " . IMGMAG_MEDTHUMB_CMD_DET_ORI . escapeshellarg($inFile) ));

      if( !empty($orientResult) && strcmp($orientResult, '1') !== 0 )
        $bOriented = true;
      if($bOriented)
      {
        //error_log("ORIENTED: " . $inFile);
        do
        {
          $tempOrientedFile = $tempDirPath . DIRECTORY_SEPARATOR . GetRandTail($sz_Name) . '.jpg' ;
        } while(file_exists($tempOrientedFile));
        
        $cmd = "nice -n 19 convert " . escapeshellarg($inFile) . " " . IMGMAG_MEDTHUMB_SETTINGS_ORIENT . " " . escapeshellarg($tempOrientedFile) . " ";   
        $output = shell_exec($cmd);
        
        $inFile = $tempOrientedFile; 
      }      
      
      
      // 2.) Generate Smaller (grid) thumb
      $settings = IMGMAG_MINITHUMB_SETTINGS; 
      $settings = str_replace('?w?', THUMB_WIDTH,  $settings);
      $settings = str_replace('?h?', THUMB_HEIGHT, $settings);
      if($bMultiFrame)
        $settings .= ' -flatten'; // so as to not get 1 jpg per gif frame nonsense      
      
      $cmd = "nice -n 19 convert " . escapeshellarg($inFile) . " " . $settings . " " . escapeshellarg($tempMinorThumb) . " ";   
      $output = shell_exec($cmd);
      
      if($bVid) // extra step for videos to overlay a play icon onto the small thumb
      {
        // convert input.jpg overlay.png -gravity center -composite -format jpg -quality 90 output.jpg
        $newSettingsStr = "GRAPHICS/overlay.png -gravity center -composite -format jpg -quality 90";
        $tempMinorThumb2 = $tempMinorThumb.'.TEMP';
        if(rename($tempMinorThumb, $tempMinorThumb2) && is_file($tempMinorThumb2))
        {
          $cmd = "nice -n 19 convert " . escapeshellarg($tempMinorThumb2) . " " . $newSettingsStr . " " . escapeshellarg($tempMinorThumb) . " ";   
          $output .= shell_exec($cmd);
          
          unlink($tempMinorThumb2);  //gotta clean-up the new '.TEMP' file !
        }
      }
      
      // 3.) Generate Intermediate Thumb for "SINGLEVIEW"
      if(($detectedWidth <= MEDTHUMB_WIDTH) && ($detectedHeight <= MEDTHUMB_HEIGHT))
      {
        $settings = IMGMAG_MEDTHUMB_SETTINGS2;
      }
      else
      {
        $settings = IMGMAG_MEDTHUMB_SETTINGS;
        $settings = str_replace('?w?', MEDTHUMB_WIDTH,  $settings);
        $settings = str_replace('?h?', MEDTHUMB_HEIGHT, $settings);
      }
      
      if($bMultiFrame)
        $settings .= ' -flatten'; // so as to not get 1 jpg per gif frame      
        
      
      $cmd = "nice -n 19 convert " . escapeshellarg($inFile) . " " . $settings . " " . escapeshellarg($tempMedThumb) . " ";   
      $output .= shell_exec($cmd); 
    }

    // 4.) put it all into a .IHAR format
    
    $handleOut = fopen($finalOutputPath, 'w');
    if($handleOut)
    {
      if($bImg)
      {
        //Micro(Minor) Thumb type 0x01
        $handle = fopen($tempMinorThumb, 'rb');
        if($handle)
        {
          fwrite($handleOut, pack('c', 1)); // put an 0x01 in first byte (type)
          
          $sz_microThumb = filesize($tempMinorThumb); 
          fwrite($handleOut, pack('N', $sz_microThumb)); // 'N' unsigned long (always 32 bit, big endian byte order)
          
          //put micro thumb inside
          $contents = '';
          while (!feof($handle)) 
          {
            $contents = fread($handle, 8192);          
            fwrite($handleOut, $contents);
          } 
          fclose($handle);
        }
        
        //Med Thumb type 0x02
        $handle = fopen($tempMedThumb, 'rb');
        if($handle)
        {
          fwrite($handleOut, pack('c', 2)); // put an 0x02 in first byte (type)
          
          $sz_medThumb = filesize($tempMedThumb); 
          fwrite($handleOut, pack('N', $sz_medThumb)); // 'N' unsigned long (always 32 bit, big endian byte order)
          
          //put med thumb inside
          $contents = '';
          while (!feof($handle)) 
          {
            $contents = fread($handle, 8192);          
            fwrite($handleOut, $contents);
          } 
          fclose($handle);
        }
      }
      
      if($bVid)
      {
        //Video type 0x04
        $handle = fopen($processedVideoTemp, 'rb');
        if($handle)
        {
          fwrite($handleOut, pack('c', 4)); // put an 0x04 in first byte (type)
          
          $sz_vid = filesize($processedVideoTemp); 
          fwrite($handleOut, pack('N', $sz_vid)); // 'N' unsigned long (always 32 bit, big endian byte order)
          
          //put video inside
          $contents = '';
          while (!feof($handle)) 
          {
            $contents = fread($handle, 8192);          
            fwrite($handleOut, $contents);
          } 
          fclose($handle);
        }
      }
      
      // Meta Section (text)
      $handle = fopen($tempMetaFile, 'rb');
      if($handle)
      {
        fwrite($handleOut, pack('c', 3)); // put an 0x03 in first byte (type)
        
        $sz_metaText = filesize($tempMetaFile); 
        fwrite($handleOut, pack('N', $sz_metaText)); // 'N' unsigned long (always 32 bit, big endian byte order)
        
        //put med thumb inside
        $contents = '';
        while (!feof($handle)) 
        {
          $contents = fread($handle, 8192);          
          fwrite($handleOut, $contents);
        } 
        fclose($handle);
      }
      
      
      fclose($handleOut);
    }
    
    // 5.) remove temps
    unlink($tempMinorThumb);
    unlink($tempMedThumb);
    unlink($tempMetaFile);
    
    if($bVid) // vid cleanup
    {
      if(file_exists($processedVideoTemp))
        unlink($processedVideoTemp);
      
      if(file_exists($stillTemp))
        unlink($stillTemp); // used to unlink inFile, in odd case resulted in the inFile (in data dir) being nuked...
    }
    
    if($bOriented)
    {
      if(file_exists($tempOrientedFile))
        unlink($tempOrientedFile);
    }
    
  }
  
  