<?php

  // Handles all changes to the user account (password) file.

  include 'GenFns.php';
  include 'AccountFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');
  
  $usernameStrGlobal = '';
  $modTokenStrGlobal = '';
  $operationStr = ''; 
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
  {
    $usernameStrGlobal = IH_GetUserName(); 
    $modTokenStrGlobal = $_SESSION[IH_GetInstanceName().'-modtoken'];
  }
  //IH_SessionClose();
  
  $passedToken = '';
  if($_POST && isset($_POST['jrr']) && is_string($_POST['jrr']))
    $passedToken = $_POST['jrr'];
  
  // Validate Token "Credentials"
  if((strlen($passedToken) === 0) || (strlen($modTokenStrGlobal) === 0) || !hash_equals($modTokenStrGlobal, $passedToken))
    IH_RedirMessageHalt('/', "Invalid Credentials (act.php)" , false);  // bail 

  
  if(strcmp($usernameStrGlobal, '') !== 0)     // Make sure logged in...
  {
    if($_POST && isset($_POST['op']) && is_string($_POST['op']) && (strlen($_POST['op']) <= 16) ) 
    {
      $operationStr = $_POST['op'];
      if( strcmp($operationStr, 'newpass') === 0 ) // oldpass, new1pass, new2pass
      {
        if(isset($_POST['oldpass']) && is_string($_POST['oldpass']))
        {
          if(isset($_POST['new1pass']) && is_string($_POST['new1pass']))
          {
            if(isset($_POST['new2pass']) && is_string($_POST['new2pass']))
            {
              // look up current pass for this user and match it with whats on file 
              if( IH_EvalPassword($usernameStrGlobal, $_POST['oldpass']) && strcmp($_POST['new1pass'], $_POST['new2pass'])===0 )
              {                
                IH_EditUser($usernameStrGlobal, $_POST['new1pass'] );
                
                IH_RawRedirMessageHalt(".?op=act", "Changed Password for user " . $usernameStrGlobal );
              } 
              else
                IH_RawRedirMessageHalt(".?op=act", "Error Changing Password!");
            }
            else
              IH_RawRedirMessageHalt(".?op=act", "Error Changing Password!");
          }
          else
            IH_RawRedirMessageHalt(".?op=act", "Error Changing Password!");
        }
        else
          IH_RawRedirMessageHalt(".?op=act", "Error Changing Password!");
      }
      else
      if( strcmp($operationStr, 'cmtdelicon') === 0 ) // cmtdelicon (show comment delete icon in right panel)
      {
        if(isset($_POST['cmtdelicon']) && strcmp($_POST['cmtdelicon'], '1') === 0)
          $_SESSION[IH_GetInstanceName().'-ShowCmtDelete'] = 'true'; 
        else
          $_SESSION[IH_GetInstanceName().'-ShowCmtDelete'] = 'false'; 
        
        IH_RawRedirMessageHalt(".?op=act", "Comment Delete Icon status has been updated.");
      }
      else
      if( strcmp($operationStr, 'clrclipboard') === 0 ) // clrclipboard
      {
        // Clipboard Var
        $_SESSION[IH_GetInstanceName().'-Clipboard'] = ''; // empty
        
        IH_RawRedirMessageHalt(".?op=act", "Cleared the Clipboard.");
      }
      else
      if( strcmp($operationStr, 'addtoclipboard') === 0 ) // add item to clipboard. we were on a specific singleview page and hit lower left form
      {
        $folderStr = '';  
        $fileStr = '';
        
        if($_POST && isset($_POST['fol']) && is_string($_POST['fol']))
          $folderStr = $_POST['fol'];
    
        if($_POST && isset($_POST['file']) && is_string($_POST['file']))
          $fileStr = $_POST['file']; 
          
        // Validate Folder String
        $bWasSanitized = IH_SanitizeBaseArg($folderStr);
        
        if(!$bWasSanitized && IH_IsValidFilename($fileStr) && is_file(IH_DataCollectionsRoot() . $folderStr . $fileStr))  
        {
          $pageValue = 1;
          if(isset($_POST['page']))
            $pageValue = IH_NormalizePageVar($_POST['page']); 
          
          //check to see if the "Clear previous clipboard contents before copying" checkbox is ticked 
          if(isset($_POST['clearclipboard']) && strcmp($_POST['clearclipboard'], '1') === 0)
            $_SESSION[IH_GetInstanceName().'-Clipboard'] = ''; // empty 
          
          if(strlen($_SESSION[IH_GetInstanceName().'-Clipboard']) !== 0) // if we have something in there already 
            $_SESSION[IH_GetInstanceName().'-Clipboard'] .= CLPBRD_DELIMITER . $folderStr . $fileStr;
          else
            $_SESSION[IH_GetInstanceName().'-Clipboard'] .= $folderStr . $fileStr;
          
          IH_RawRedirMessageHalt(".?fol=" . rawurlencode($folderStr) . "&op=singleview&page=" . $pageValue, "Added to Clipboard: " . $fileStr);
        }
        else
          IH_RawRedirMessageHalt(".?fol=" . rawurlencode($folderStr), "Add to Clipboard Failure: Invalid Path Arguments.");
      }
      else
      if( strcmp($usernameStrGlobal, 'admin') === 0 ) // ADMIN OPS
      {
        if( strcmp($operationStr, 'passuser') === 0) // force the password change of another user 
        {
          if(isset($_POST['username']) && is_string($_POST['username']))
          {
            if(isset($_POST['password']) && is_string($_POST['password']))
            {
              if(IH_IsValidUsername($_POST['username']))
              {
                IH_EditUser($_POST['username'], $_POST['password'] );
                IH_RawRedirMessageHalt(".?op=act", "Changed Password for user " . $_POST['username']);
              }
            }
          }
        }
        else
        if( strcmp($operationStr, 'nixuser') === 0) // delete a user
        {
          if(isset($_POST['username']) && is_string($_POST['username']))
          {
            if(IH_IsValidUsername($_POST['username']))
            {
              if(strcasecmp($_POST['username'], "admin") !== 0) // if the username is NOT admin
              {
                // Find the line in the password file and nix it...
                IH_EditUser($_POST['username'], 0);
              
                IH_RawRedirMessageHalt(".?op=act", "Deleted user " . $_POST['username']);
              }
            }
          }
        }
        else
        if( strcmp($operationStr, 'newuser') === 0) // create user 
        {
          if(isset($_POST['username']) && is_string($_POST['username']))
          {
            if(isset($_POST['password']) && is_string($_POST['password']))
            {
              if(IH_IsValidUsername($_POST['username']))
              {
                if(!IH_DoesUserExist($_POST['username']))
                {  
                  IH_CreateUser($_POST['username'], $_POST['password']);
                  IH_RawRedirMessageHalt(".?op=act", "Created new user " . $_POST['username']);
                }
                else
                  IH_RawRedirMessageHalt(".?op=act", "The new username " . ($_POST['username']) . " already exists." );
              }
              else
                IH_RawRedirMessageHalt(".?op=act", "The new username " . ($_POST['username']) . " contains illegal characters." );
            }
          }
        }
        else
          IH_RedirMessageHalt('/', "Invalid Operation 003 (act.php)" , false);        
      }
      else
        IH_RedirMessageHalt('/', "Invalid Operation 002 (act.php)" , false);
    }
    else
      IH_RedirMessageHalt('/', "Invalid Operation 001 (act.php)" , false);
  }
  else
    IH_RedirMessageHalt('/', "Invalid Credentials (act.php)" , false); 
  
  
  
  