<?php
//CLI-only worker wrapper for calling asynchronous jobs, ie. Generating batches of .IHARs 

  include 'GenFns.php';
  include 'ModFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');

  if(php_sapi_name() == 'cli')
  {
    ini_set("log_errors", 1);
    ini_set("error_log", IH_Meta() . DIRECTORY_SEPARATOR . "php-cli-errors.log");
    
    if(isset($argc) && isset($argv)) // var_dump($argc); var_dump($argv);
    {
      // Arg1: opertioin to be performed, ie. 'gen-ihars'
      $op = $argv[1];
      
      if(strcasecmp($op, 'gen-ihars') === 0)
      { 
        $inFileList = $argv[2]; // Arg2: name of temp file (not path) containing a list of files we want to generate for.
        
        //get array from temp file
        $inFileListArr = file(IH_MetaTEMPRoot() . DIRECTORY_SEPARATOR . $inFileList , FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
        if($inFileListArr === false)
        {
          error_log("IHAR input file could not be read! " . $inFileList);
          die();
        }   
        unlink(IH_MetaTEMPRoot() . DIRECTORY_SEPARATOR . $inFileList);  
        
        foreach($inFileListArr as $row)
        {
          IH_CreateIHAR($row);
        }
        
      }
        // future ops, if any 
    }
  }
  else
    echo ('Non-Browseable');
  
  ?>