<?php

  include 'GenFns.php';
  include 'CmtFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');
  
  // START ======================================================================================================================
  $usernameStrGlobal = '';
  $modTokenStrGlobal = '';
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
  {
    $usernameStrGlobal = IH_GetUserName(); 
    $modTokenStrGlobal = $_SESSION[IH_GetInstanceName().'-modtoken'];
  }
  else 
    IH_RedirMessageHalt('/', "Not Authorized to Comment. (001)" , false);
  
  IH_SessionClose();// No Session-dependant calls after here
  
  $passedToken = '';
  if($_POST && isset($_POST['jrr']) && is_string($_POST['jrr']))
    $passedToken = $_POST['jrr'];
  
  // Validate Token "Credentials"
  if((strlen($passedToken) === 0) || (strlen($modTokenStrGlobal) === 0) || !hash_equals($modTokenStrGlobal, $passedToken))
    IH_RedirMessageHalt('/', "Not Authorized to Comment. (002)" , false);
  
  $folderStrGlobal = '';  
  $collectionStrGlobal = ''; 
  $fileStrGlobal = ''; // optional, may be operating on a file's comments rather than a folder's
  
  if($_POST && isset($_POST['fol']) && is_string($_POST['fol']))
      $folderStrGlobal = $_POST['fol'];
    
  if($_POST && isset($_POST['file']) && is_string($_POST['file']))
      $fileStrGlobal = $_POST['file'];  
    
  // Validate Folder String
  $bWasSanitized = IH_SanitizeBaseArg($folderStrGlobal);
  
  $collectionStrGlobal = IH_GetCollectionNameFromFolderStr($folderStrGlobal);

  if(!$bWasSanitized && IH_CanUserUploadCollection($collectionStrGlobal, $usernameStrGlobal)) // logged in and has access 
  {
    if( (strcmp($fileStrGlobal,'')!==0) ) // if theres something there
      if( !IH_IsValidFilename($fileStrGlobal) || !file_exists(IH_DataCollectionsRoot() . '/' .$folderStrGlobal. $fileStrGlobal) )
        IH_RedirMessageHalt('/', "Invalid Input (comment.php)" , false);

    if($_POST && isset($_POST['op']) && is_string($_POST['op']))
      $opStrGlobal = $_POST['op'];
    
    $pageValue = 1;
    if(isset($_POST['page']))
      $pageValue = IH_NormalizePageVar($_POST['page']); 
    
    $pageModeStr = ''; // redirect to grid
    if(strcmp($fileStrGlobal, '') !== 0 ) // if we were commenting on a file
      $pageModeStr = '&op=singleview'; // redirect back to singleview
    
    if(strcmp($opStrGlobal, 'newcmt') === 0) // MAKING A NEW COMMENT 
    {
      if($_POST && isset($_POST['cmt']) && is_string($_POST['cmt']) && (strlen($_POST['cmt']) <= 500) && (strlen($_POST['cmt']) > 0) ) // COMMENT ITSELF PASSES CHECKS
      {  
        $comment = $_POST['cmt']; 
        
        // at this point we could be making the first comment, OR adding to existing comments!
        // handle both cases.
        $bHad = true;
        if(!IH_ItemHasComments($folderStrGlobal, $fileStrGlobal)) 
        {          
          IH_ActualizeCommentFolder($folderStrGlobal, $fileStrGlobal);
          $bHad = false;
        }
        
        if( ($fp = IH_GetCmtLock($folderStrGlobal, $fileStrGlobal)) !== false) // got the lock on the .lock file...
        {
          if(!$bHad)
            IH_MartializeCommentArray(array(), $folderStrGlobal, $fileStrGlobal); // put an empty array there :)
          
          //TODO; maybe check to see if its ('.comment') still there to unmartialize against 
          
          if(($theArr = IH_UnMartializeCommentArray($folderStrGlobal, $fileStrGlobal)) !== false) // attempt to open that .comment file 
          {
            do
            {
              $guid = GetRandTail(COMMENT_GUID_LEN);
            }while(IH_ArrContainsCmtGuid($theArr, $guid));  
            
            $theArr[] = new CommentItem("", $usernameStrGlobal, $comment, $guid ); // add new entry to array 
            
            IH_MartializeCommentArray($theArr, $folderStrGlobal, $fileStrGlobal);
            
            $bOutcome = true;
          }
          else
            $bOutcome = false;
          
          IH_ReleaseCmtLock($fp);
        }
        else
          $bOutcome = false;
        
        // Outcome of above
        if($bOutcome)
          IH_RawRedirMessageHalt( (".?fol=" . rawurlencode($folderStrGlobal) . $pageModeStr . "&page=" . $pageValue) , "Comment Posted Successfully."); // SUCCESS
        else
          IH_RedirMessageHalt($folderStrGlobal, "Could not load comments. (outcome)" , false);        
      }
      else
        IH_RedirMessageHalt($folderStrGlobal, "Comment length is invalid." , false);
    }
    else
    if(strcmp($opStrGlobal, 'delcmt') === 0) // DELETING COMMENT 
    {
      if($_POST && isset($_POST['cmtguid']) && is_string($_POST['cmtguid']) && (strlen($_POST['cmtguid']) == COMMENT_GUID_LEN) ) 
      { 
        $candidateGuid = $_POST['cmtguid']; //passed-in one.
        if(IH_ItemHasComments($folderStrGlobal, $fileStrGlobal))
        {
          $numRemoved = 0;
          if( ($fp = IH_GetCmtLock($folderStrGlobal, $fileStrGlobal)) !== false) // got the lock on the .lock file...
          {            
            if(($theArr = IH_UnMartializeCommentArray($folderStrGlobal, $fileStrGlobal)) !== false) // attempt to open that .comment file 
            {
              // search for cand. and remove...
              $newArr = array();//return theArray, less the matched guid...
              
              foreach($theArr as $elem)
              {
                if(strcmp($candidateGuid, $elem->guidStr)===0 && ((strcmp($usernameStrGlobal,$elem->userStr)===0)||(strcmp($usernameStrGlobal,'admin')===0)) )
                {  
                  $numRemoved++;
                  continue;  
                }
                
                $newArr[] = $elem;
              }
              //only bother if newarr isnt empty
              if(count($newArr)>0)
                IH_MartializeCommentArray($newArr, $folderStrGlobal, $fileStrGlobal);
              else
                unlink( IH_GetCommentFileLocation($folderStrGlobal, $fileStrGlobal) . '.comment' );
              
              $bOutcome = true;
            }
            else
              $bOutcome = false;
            
            IH_ReleaseCmtLock($fp);
          }
          else
            $bOutcome = false;
          
          // Outcome of above
          if($bOutcome)
            IH_RawRedirMessageHalt( (".?fol=" . rawurlencode($folderStrGlobal) . $pageModeStr . "&page=" . $pageValue) , $numRemoved . " Comment(s) Removed."); // SUCCESS
          else
            IH_RedirMessageHalt($folderStrGlobal, "Could not load comments. (remove comment)" , false);      
        }
      }
    }
    else
      IH_RedirMessageHalt($folderStrGlobal, "Invalid Input operation (comment.php)" , false);    
  }
  else
    IH_RedirMessageHalt('/', "Insufficient Permissions (comment.php)" , false); 
  
  
  