<?php // download wrapper when you click on the file image in singleview... no caching desired, always force-feed client as this is a rare event 

  include 'GenFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');

  $usernameStrGlobal = '';
  $tempZipOutGlobal = ''; // only used in zip context
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
    $usernameStrGlobal = IH_GetUserName(); 
  IH_SessionClose();// No Session-dependant calls after here
  
  $fileStr = '';
  $folderStr = '';  // should be "at least" -> '/XXX/' SOMETHING 
  $collectionStr = ''; 
  
  if($_GET && isset($_GET['fol']) && is_string($_GET['fol'])) // set folderStr
    $folderStr = $_GET['fol'];
    
  // Validate Folder String
  $bWasSanitized = IH_SanitizeBaseArg($folderStr);
  
  if($_GET && isset($_GET['file']) && is_string($_GET['file'])) // set fileStr 
    $fileStr = $_GET['file'];
  
  if( !$bWasSanitized && (strcmp($folderStr,'/') !== 0) && IH_IsValidFilename($fileStr) )
  {
    $pathToFile = IH_DataCollectionsRoot() . $folderStr . $fileStr ; // what we're dumping from 
    if(is_file($pathToFile))
    {
      $collectionStr = IH_GetCollectionNameFromFolderStr($folderStr);
      if(strcmp($collectionStr, '') !== 0 ) // if we're in a collection
      {
        if(IH_CanUserReadCollection($collectionStr, $usernameStrGlobal))
        {
          if(isset($_GET['view'])) // if view is set, ATTEMPT to ascertain mime and set headers accordingly 
          {
            $currentMIMEStr = mime_content_type($pathToFile);
            $searchNeedleStr = 'image';
            $curMIMEPrefix = substr($currentMIMEStr, 0, strlen($searchNeedleStr));
            if(strcmp($searchNeedleStr, $curMIMEPrefix) === 0) // image
            {
              header('Content-Type: ' . mime_content_type($pathToFile) );
              header("Content-Disposition: inline; filename=\"" . ($fileStr) . "\"");
            }
            else // if fails mime
            {
              header('Content-Description: File Transfer');
              header('Content-Type: application/octet-stream');
              header("Content-Disposition: attachment; filename=\"".($fileStr)."\"");
            }
          }
          else // or if view wasnt set to begin with 
          {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header("Content-Disposition: attachment; filename=\"".($fileStr)."\"");
          }
          
          // Common headers, same for all op modes 
          header('Expires: 0');
          header('Cache-Control: must-revalidate');
          header('Pragma: public');
          header('Content-Length: ' . filesize($pathToFile)); 
          
          ReadoutFile($pathToFile);
        }
        else
        {
          echo("Error: 03" . "<br>\r\n"); // Not authorized to view collection 
          exit(1);
        }
      }      
    }  
    else
    {
      echo("Error: 02" . "<br>\r\n"); // file does not exist
      exit(1);
    }
  }
  else
  if( !$bWasSanitized && (strcmp($folderStr,'/') !== 0) && isset($_GET['zip']) )
  {
    $pathToDir = IH_DataCollectionsRoot() . $folderStr ; 
    if(is_dir($pathToDir))
    {
      $collectionStr = IH_GetCollectionNameFromFolderStr($folderStr);
      if(strcmp($collectionStr, '') !== 0 )
      {
        // must be logged-in and can view this col to generate zips
        if(strcmp($usernameStrGlobal,'') !== 0 )
        {
          if(IH_CanUserReadCollection($collectionStr, $usernameStrGlobal))
          {
            do
            {
              $tempZipOutGlobal = realpath(IH_MetaTEMPRoot()) . DIRECTORY_SEPARATOR . GetRandTail(16) . '.zip';
            } while(file_exists($tempZipOutGlobal));
            
            set_time_limit(0); // zip generation can take awhile
            
            chdir($pathToDir);
            
            $cmd = "zip '-j' '-1' ".$tempZipOutGlobal." ./*"; // needed ./* for names like -foo.jpg :/
            
            register_shutdown_function('ZipCleanup');
            
            $out = shell_exec($cmd); // makes the zip 
            
            if(is_file($tempZipOutGlobal))
            {
              // Headers for Zip Archive
              header('Content-Description: File Transfer');
              header('Content-Type: application/octet-stream');
              header("Content-Disposition: attachment; filename=\"". str_replace('/', '_', trim(trim($folderStr),'/,.')) . '.zip' ."\"");
              
              header('Expires: 0');
              header('Cache-Control: must-revalidate');
              header('Pragma: public');
              header('Content-Length: ' . filesize($tempZipOutGlobal));
              
              ReadoutFile($tempZipOutGlobal);
            }
            else
            {
              echo("Error: 05" . "<br>\r\n");  
              exit(1);
            }
          }
          else
          {
            echo("Error: 03" . "<br>\r\n"); // Not authorized to view collection 
            exit(1);
          }
        }
        else
        {
          echo("You must be logged-on to perform this action." . "<br>\r\n");  // TODO make a unified, session-based, message handler. NOT what we have now
          exit(1);
        }
      }
    }
    else
    {
      echo("Error: 02" . "<br>\r\n"); // file does not exist
      exit(1);
    }
  }
  else
  {
    echo("Error: 01" . "<br>\r\n"); // folderStr AND/OR fileStr invalid 
    exit(1);
  }  

  function ZipCleanup() // called when script terminates
  {
    global $tempZipOutGlobal;
    
    if(is_file($tempZipOutGlobal))
    {
      unlink($tempZipOutGlobal);
      
      if(!file_exists($tempZipOutGlobal))
        error_log("Notice:ImageHub(".IH_GetInstanceName().") Temp Zip File cleaned successfully! ");
    }
    else
      error_log("Error:ImageHub(".IH_GetInstanceName().") Zip File was never created!");
  }
  
  function ReadoutFile($pathStr)
  {
    // New code with fread that should handle large files bigger than 128MB...
    if(!is_file($pathStr))
    {
      error_log("Error:ImageHub(".IH_GetInstanceName().") The output file path did not exist!");
      exit(1); 
    }
    ob_clean();
    ob_end_flush();
    $handle = fopen($pathStr, "rb");
    while (!feof($handle)) 
      echo fread($handle, 1024);
    fclose($handle);
  }
  