<?php

  include 'GenFns.php';
  
  // Index Files' State, this allows us to override the cached copy if the folder was reindexed prior to cahced image expiry.
  function GetCurrentFolderStateTag($folderStr) // looks into the zeroth index and gets the current value of state tag for known folderStr(s), FALSE if error, else str returned 
  {
    $zerothIndexArr = GetIndexIthFileAsArr($folderStr, 'A', 0);
    if(!$zerothIndexArr) 
      return false;
    
    if(array_key_exists('3', $zerothIndexArr) && is_string($zerothIndexArr[3]))
      return $zerothIndexArr[3]; // 4th line
    else
      return false;
  }
  
  function GetCopyPasteDiv($folderStr, $fileStr, $modTokenStr, $pageNumber) // if user can mod collection...they can copy this image... 
  {
    return "                                    
                  <div id=infoboxCopyPaste>
                    <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Copy Image to Clipboard</span>                      
                    <form style=\"margin-top: 10px;\" action=\"act.php\" method=\"POST\" accept-charset=\"UTF-8\">
                      <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                      <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                      <input type=\"hidden\" name=\"file\" value=\"" . htmlspecialchars($fileStr) . "\">
                      <input type=\"hidden\" name=\"page\" value=\"" . $pageNumber . "\">
                      <input type=\"hidden\" name=\"op\" value=\"addtoclipboard\"> 
                      <input type=\"checkbox\" name=\"clearclipboard\" value=\"1\"> Clear previous clipboard contents before copying 
                      <br>
                      <br><input type=\"submit\" value=\"Copy to Clipboard\" />
                    </form>
                  </div>
                  ";  
  }
  
  function GetCommentPostDiv($folderStr, $fileStr, $modTokenStr, $pageNumber) // form div to post a new comment. 
  {
    return "                                    
                  <div id=infoboxNewCmt>
                    <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Add Comment</span>                      
                    <form style=\"margin-top: 10px;\" action=\"comment.php\" method=\"POST\" accept-charset=\"UTF-8\">
                      <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                      <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                      <input type=\"hidden\" name=\"file\" value=\"" . htmlspecialchars($fileStr) . "\">
                      <input type=\"hidden\" name=\"page\" value=\"" . $pageNumber . "\">
                      <input type=\"hidden\" name=\"op\" value=\"newcmt\"> 
                      <textarea rows=\"4\" style=\"width: 394px; resize: none;\" name=\"cmt\"></textarea>
                      <br>
                      <div align=right>
                        <input type=\"submit\" value=\"Post\" />
                      </div>
                    </form>
                  </div>
                  ";  
  }
  
  function AccessInfoFormSelectReturn($current)
  {
    if($current < 0 || $current > 2) // out of range...
      return "<span style=\"color:red;\">INVALID</span>"; 
    
    $retStr = '';
    //const ACCESS_VOID      = -1; // Invalid state: collection hasn't been processed yet, ie. no access file
    //const ACCESS_PUBLIC     = 0; // anyone can see
    //const ACCESS_USER       = 1; // only users can see
    //const ACCESS_RESTRICTED = 2; // specific users only (from users list)
    $lookupArr = array( 0   => "PUBLIC", 1   => "USER", 2   => "RESTRICTED");  
    
    $retStr .= "
              <select name=access>";
    for($i=0 ; $i < count($lookupArr) ; $i++)
    {
      if($i == $current ) //selected
      {
        $retStr .= "
                  <option selected=selected value=" . $i . ">" . $lookupArr[$i] . "</option>";
      }
      else
      {
        $retStr .= "
                  <option value=" . $i . ">" . $lookupArr[$i] . "</option>";
      }
    }
       
    $retStr .= "
              </select>
    ";     
    return $retStr;
  }
  
  function HasSubFolders($folderStr) // if theres a non-empty .folders file in meta tree, then its got folders 
  {
    $folderIndexFilename = IH_MetaCollectionsIndexRoot() . $folderStr . '.folders';
    if(file_exists($folderIndexFilename) && (filesize($folderIndexFilename) > 0) ) 
      return true;
    
    return false;
  }
  
  function SubFoldersMarkup($folderStr) // generates infobox div displaying the subfolders for a given folderStr 
  {
    $foldersListMarkup = '';
    // Visit children
    $folderIndexFilename = IH_MetaCollectionsIndexRoot() . $folderStr . '.folders';
    if(file_exists($folderIndexFilename) && (filesize($folderIndexFilename) > 0) ) // load it and tack on some dropdown content
    {
      $subFolderArr = file($folderIndexFilename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
      if($subFolderArr !== FALSE && count($subFolderArr) > 0 )
      {
        foreach($subFolderArr as $item)
        {
          $foldersListMarkup .= "<br><a class=boxListItem href=\".?fol=" . htmlspecialchars(rawurlencode($folderStr.$item.'/')) . "&amp;page=1\">" . htmlspecialchars($item) . "</a>\r\n";
        }
      }
    }
    
    if(empty($foldersListMarkup))
      return '';
    else
    {
      return "
                    <div id=infobox> 
                      <span class=boxHead1>Sub-Folders ( " . htmlspecialchars(trim($folderStr, "/")) . " ) </span>
                    " . $foldersListMarkup . "
                    </div>
                    
        ";
    }
  }
  
  function isMobile() // can force mobile via "/?mob" for testing...
  {
    return isset($_GET['mob']) || preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
  }
  
  function Echo_Layout($usernameStr, $collectionStr, $folderStr, $fileStr, $pageNumber, $opStr, $editItemStr, $messageStr, $modTokenStr, $bShowCmtDelete, $bMobile)
  {
    // (Upper LEFT)
    $linkRowMarkup = '';
    if(strcmp($folderStr, '/') !== 0) // in a collection
    {
      if($bMobile) // if we're mobile, dont do the dropdown on nav bar
      {
        $folderArr = explode('/', trim($folderStr, ' /')); //trim slashes and spaces
        if($folderArr !== false)
        {
          $partialPath = '';
          $i = 0;
          foreach($folderArr as $fold) // for each folder in the current path 
          {
            $i++;
            
            if($i == 1) 
              $partialPath .= $fold; // first iteration dont tack on slash
            else
              $partialPath .= '/' . $fold;
            
            if($i == 1)
              $linkRowMarkup .= " &#x2022; " ; // unicode bullet separated
            else
              $linkRowMarkup .= " / " ; // slash separated
            
            $lnkTarg = ".?fol=" . rawurlencode($partialPath);
            $link = "<a class=\"topnavBar\" href=\"" . htmlspecialchars($lnkTarg) . "\">" . htmlspecialchars($fold) . "</a>";

            $linkRowMarkup .= $link; 
          }
        }
      }
      else // original code path
      {
        $folderArr = explode('/', trim($folderStr, ' /')); //trim slashes and spaces
        if($folderArr !== false)
        {
          // for every element, add an link, and dropdown, IFF it also has subfolders.
          //  &#x2022; Collection1 / folder1 / vacation2016 / fun            <a class=\"topnav\" href='.'>HOME</a>
          //$sz_folderArr = count($folderArr);
          
          $partialPath = ''; // collects the successive iterations of $fold and sandwitches '/' between them 
          $i = 0;
          foreach($folderArr as $fold) // for each folder in the current path 
          {
            $i++;
            
            // add dropdown markup if there are folders in the corresponding index file. 
            $dropdownMarkup = '';
            if($i == 1) 
              $partialPath .= $fold; // first iteration dont tack on slash
            else
              $partialPath .= '/' . $fold;
            $folderIndexFilename = IH_MetaCollectionsIndexRoot() . '/' . $partialPath . '/' . '.folders';
            if(file_exists($folderIndexFilename)) // load it and tack on some dropdown content
            {
              $subFolderArr = file($folderIndexFilename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
              if($subFolderArr !== FALSE && count($subFolderArr) > 0 )
              {
                $dropdownMarkup .= "<div class=\"dropdown-content\">\r\n";
                foreach($subFolderArr as $sub)
                {
                  $lnkTarg = ".?fol=" . rawurlencode($partialPath . '/' . $sub);
                  $dropdownMarkup .= "<a href=\"" . htmlspecialchars($lnkTarg) . "\">" . htmlspecialchars($sub) . "</a>\r\n";
                }
                $dropdownMarkup .= "</div>\r\n";
              }
            }
            
            if($i == 1)
              $linkRowMarkup .= " &#x2022; " ; // unicode bullet separated
            else
              $linkRowMarkup .= " / " ; // slash separated
            
            $linkRowMarkup .= "<div class=\"dropdown\"><button2 class=\"dropbtn\">\r\n"; 
            
            // prep link
              $lnkTarg = ".?fol=" . rawurlencode($partialPath);
              $link = "<a href=\"" . htmlspecialchars($lnkTarg) . "\">" . htmlspecialchars($fold) . "</a>";
            $linkRowMarkup .= $link; 
            $linkRowMarkup .= "</button2>\r\n";                  
            $linkRowMarkup .= $dropdownMarkup;
            $linkRowMarkup .= "</div>\r\n";          
          }
        }
      } // non mobile else
    }
    
    $bLoggedOn = false;    
    // Username Part (Upper RIGHT)
    $accountStatusMarkup = "  <div style='float:right;'>
                                %extra%<a class='topnavBar' target='_top' href='%targ%.php'>%label%</a>
                              </div>";
    if( strcmp($usernameStr, '') !== 0 )    // we are logged in
    {
      $usernameStrMarkup = "<a class='topnavBar' target='_top' href=\".?op=act\">" . htmlspecialchars($usernameStr) . "</a>"; // an <a href> containing a link to the 
      
      $accountStatusMarkup = str_replace("%targ%", "logoff", $accountStatusMarkup);
      $accountStatusMarkup = str_replace("%label%", "Logoff", $accountStatusMarkup);
      $accountStatusMarkup = str_replace("%extra%", "<b>(" . $usernameStrMarkup . ")</b>&nbsp;-&nbsp;", $accountStatusMarkup);
      $bLoggedOn = true;
    }
    else   // we're not logged in
    {
      $accountStatusMarkup = str_replace("%targ%", "logon", $accountStatusMarkup);
      $accountStatusMarkup = str_replace("%label%", "Logon", $accountStatusMarkup);
      $accountStatusMarkup = str_replace("%extra%", "", $accountStatusMarkup);
    }
    
    $mobStr = '';
    if($bMobile)
      $mobStr = ' Mobile';
    
    // FooterStatusMessageText
    if($bLoggedOn)
      $footerStatusText = 'Welcome ' . htmlspecialchars($usernameStr) . ', to Image Hub'.$mobStr.'!'; 
    else
      $footerStatusText = 'Welcome to Image Hub'.$mobStr.'!';
    
    // Collections List
    $collectionsListMarkup = '';
    $arrowNavRowMarkup = ''; // holds the currfolder name+pencil and nav arrows + current page number. 
    $imageTableMarkup = '';//the "meat" for THE GRID or SINGLEVIEW 
    
    
    if(strcmp($folderStr, '/') !== 0 && strcmp($opStr, '') === 0 )  // GRID ===============================================================================================
    {
      $zerothIndexArr = GetIndexIthFileAsArr($folderStr, 'A', 0);
      if(!$zerothIndexArr) 
      {
        if(strcasecmp($usernameStr, 'admin') === 0) // no index, but we're admin, send to advanced to create index and set permissions. 
        {
          header("Location: .?fol=" . rawurlencode($folderStr) . "&op=folderedit" );
          die();
        }
        else
          IH_RedirMessageHalt('/', "Error: zeroth index file missing for (" . trim($folderStr, ' /') . ")" , false); // go home
      }
      
      $loadedTotalNumPages = $zerothIndexArr[2]; // 3rd line
      
      $stateTag = ''; // load the index state, this allows us to override the cached copy if the folder was reindexed prior to cahced image expiry. 
      if(array_key_exists('3', $zerothIndexArr))
        $stateTag = $zerothIndexArr[3];// 4th line 
      
      //Check if the loadedTotalNumImages is Zero, basically means there arent any A1 to An index files, either because folder empty -OR- no index was never generated 
      if ($loadedTotalNumPages == 0) // there are no FILES in this folder, so IFF there are subfolders, display them
      {
        $arrowNavRowMarkup = "
                  <table class=arrowNavRowTable>
                    <tr>
                      <td>
                        <span style=\"padding-left: 16px;font:normal 14px/14px Arial; font-weight:bold; margin:0px 0px 0px 0px;\"> &#x2022; " . htmlspecialchars(basename($folderStr)) . "</span>
                        <a href=\"" . htmlspecialchars(".?fol=" . rawurlencode($folderStr) . "&op=folderedit" ) . "\"><img src=\"GRAPHICS/pencil.png\" title=\"Advanced Mode\"></a>
                        <a href=\"" . htmlspecialchars(".?fol=" . rawurlencode($folderStr) . "&op=upload" ) . "\"><img src=\"GRAPHICS/up.png\" title=\"Upload File(s)\"></a>
                      </td>
                      
                      <td class=navRightTd>
                        <div class=navRightDiv> 
                          <img class=arrow src=GRAPHICS/arrow_left_disabled.gif>
                          <span class=pageindex>0</span>
                          <img class=arrow src=GRAPHICS/arrow_right_disabled.gif>
                        </div>
                      </td>
                      
                    </tr>
                  </table>
                  ";
                  
        if(HasSubFolders($folderStr)) // only IFF there are folders put the link, otherwise it would go to a blank page 
        {
          $imageTableMarkup = SubFoldersMarkup($folderStr);
        } 
        else
        {
          $imageTableMarkup = "
                  <div class=\"centerwarn\">
                    Folder Index Empty
                  </div>
                  <div class=\"centerwarn2\">
                    This folder index is empty. If you've copied files to the folder outside<br>of this application please rebuild it using the \"Advanced\" Menu (Pencil).
                  </div>
                  ";     
        }
      }
      else // happy-flow, pagination index files exists 
      {  
      
        // SUPPLIED PAGE NUMBER MAX CHECK
        if($pageNumber > $loadedTotalNumPages)
          $pageNumber = $loadedTotalNumPages;
        
        // Left Arrow State
        if( $pageNumber - 1 < 1 ) // disabled arrow
        {
          $backArrowTargMarkup = "<img class=arrow src=GRAPHICS/arrow_left_disabled.gif>";
        }
        else // normal left arrow
        {
          $backArrowTarg = ".?fol=" . rawurlencode($folderStr) . "&page=" . ($pageNumber - 1) . "";
          $backArrowTargMarkup = "<a id=\"prevLink\" href=\"" . htmlspecialchars($backArrowTarg) . "\"><img class=arrow src=GRAPHICS/arrow_left.gif></a>";
        }
        // Right Arrow State 
        if( $pageNumber + 1 > $loadedTotalNumPages )
        {
          $aheadArrowTargMarkup = "<img class=arrow src=GRAPHICS/arrow_right_disabled.gif>";
        }
        else // normal right arrow
        {
          $aheadArrowTarg = ".?fol=" . rawurlencode($folderStr) . "&page=" . ($pageNumber + 1) . "";
          $aheadArrowTargMarkup = "<a id=\"nextLink\" href=\"" . htmlspecialchars($aheadArrowTarg) . "\"><img class=arrow src=GRAPHICS/arrow_right.gif></a>";
        }
        
        $folderSpanMarkup = '';
        if(HasSubFolders($folderStr)) // only IFF there are folders put the link, otherwise it would go to a blank page 
        {
          $folderSpanMarkup = "
                          <span style=\"vertical-align:4px; font:normal 12px/12px Arial; font-weight:bold; margin:0px 0px 0px 0px;\">
                            <a id=\"folLink\" href=\"".htmlspecialchars(".?fol=".rawurlencode($folderStr)."&op=subfolders"."&page=".rawurlencode($pageNumber))."\">FOLDERS</a>
                          </span>"; 
        }        
        
        // nav arrows 
        $arrowNavRowMarkup = "
                    <table class=arrowNavRowTable>
                      <tr>
                        <td>
                          <span style=\"padding-left: 16px;font:normal 14px/14px Arial; font-weight:bold; margin:0px 0px 0px 0px;\"> &#x2022; " . htmlspecialchars(basename($folderStr)) . "</span>
                          <a href=\"" . htmlspecialchars(".?fol=" . rawurlencode($folderStr) . "&op=folderedit&page=" . rawurlencode($pageNumber) ) . "\"><img src=\"GRAPHICS/pencil.png\" title=\"Advanced Mode\"></a>
                          <a href=\"" . htmlspecialchars("dl.php?fol=" . rawurlencode($folderStr) . "&zip" ) . "\"><img src=\"GRAPHICS/zip.png\" title=\"Download this folder as a Zip.\"></a>
                          <a href=\"" . htmlspecialchars(".?fol=" . rawurlencode($folderStr) . "&op=upload&page=" . rawurlencode($pageNumber) ) . "\"><img src=\"GRAPHICS/up.png\" title=\"Upload File(s)\"></a>
                        </td>
                        <td class=navRightTd>
                          <div class=navRightDiv>
                            ".$folderSpanMarkup."                                                   
                            " . $backArrowTargMarkup . "
                            <span class=pageindex>" . $pageNumber . "</span>
                            " . $aheadArrowTargMarkup . "
                          </div>
                        </td>
                      </tr>
                    </table>
                    ";
        
        // THE GRID
        $imageTableMarkup .= "
                  <table id=gridViewTable>
                    <tr>
                      <td id=gridViewTableTD> 
                        <table class=\"imageTable\">
        ";
        
        // Determine Page File. 
        /* $specificIndexFile = '~A_' . $pageNumber . '.txt';
        
        $indexLoadedArr = file(IH_MetaCollectionsIndexRoot() . $folderStr . $specificIndexFile , FILE_IGNORE_NEW_LINES ); // loads the file into the array, line by line
         */
        $indexLoadedArr = GetIndexIthFileAsArr($folderStr, 'A', $pageNumber);
        
    //TODO: put a check here S.T. if the specified index file doesnt exist, we bail out...
        
      
        $sz_indexLoadedArr = count($indexLoadedArr);
        
        $numCols = GRID_COLS;
        $numRows = GRID_ROWS;
        
        $lastIndex = 0;
        for($i = 0; $i < $sz_indexLoadedArr ; $i++)
        {
          $lastIndex = $i;
          
          if( $i % $numCols == 0 ) // starting a new row
            $imageTableMarkup .= "<tr>\r\n";
          
          $imageTableMarkup .= "  <td>\r\n";
          $imageLink = "img.php?fol=" . rawurlencode($folderStr) . "&file=" . rawurlencode(trim($indexLoadedArr[$i])) . "&var=1" . "&s=" . $stateTag ;
          $ahrefTarg = ".?fol=" . rawurlencode($folderStr) . "&page=" . ((($pageNumber - 1) * IMGS_PER_PAGE) + $i + 1) . "&op=singleview";
          $imageTableMarkup .= "    <a href=\"" . htmlspecialchars($ahrefTarg) . "\"><img width=".THUMB_WIDTH." height=".THUMB_HEIGHT." src=\"" . htmlspecialchars($imageLink) . "\"></a>\r\n";
          $imageTableMarkup .= "  </td>\r\n";
          
          if( $i % $numCols == ($numCols-1) )
            $imageTableMarkup .= "</tr>\r\n";
        }      
        if($lastIndex % $numCols != ($numCols-1)) // if we exit on an incomplete row
          $imageTableMarkup .= "</tr>\r\n";
          
        $imageTableMarkup .= "
                        </table>
                      </td>";
        // ----==== COMMENTS ====----
        if(IH_ItemHasComments($folderStr, ''))
        {
          include 'CmtFns.php'; // drag the rest in
          
          $imageTableMarkup .= IH_GetCommentDivMarkup($folderStr, '', $usernameStr, $modTokenStr, $pageNumber, $bShowCmtDelete);
        }     
        
        $imageTableMarkup .= " 
                    </tr>
                  </table>
                  ";
        
        // 'New Comment' Form     
        if(IH_CanUserUploadCollection($collectionStr, $usernameStr))
          $imageTableMarkup .= GetCommentPostDiv($folderStr, '', $modTokenStr, $pageNumber);
      }
    } 
    else
    if(strcmp($folderStr, '/') !== 0 && (strcmp($opStr, 'singleview') === 0 || strcmp($opStr, 'fileedit') === 0))  // SINGLEVIEW ===============================================================================================
    {
      // Load the "IMGS_PER_PAGE" from the Zeroth index file for the given sort, on line 1
      $zerothIndexArr = GetIndexIthFileAsArr($folderStr, 'A', 0);
      if(!$zerothIndexArr) // redir, to /folderstring/ if cant find zeroth 
        IH_RedirMessageHalt($folderStr, "Error: zeroth index file is missing!", true);
      
      $loadedImgsPerPage = (int)$zerothIndexArr[0];   // "IMGS_PER_PAGE"
      $loadedTotalNumImages = (int)$zerothIndexArr[1];
      
      $stateTag = ''; // load the index state, this allows us to override the cached copy if the folder was reindexed prior to cahced image expiry. 
      if(array_key_exists('3', $zerothIndexArr))
        $stateTag = $zerothIndexArr[3];// 4th line
      
      // SUPPLIED PAGE NUMBER MAX CHECK
      if($pageNumber > $loadedTotalNumImages)
        $pageNumber = $loadedTotalNumImages;
      
      // in this case, if we're viewing a single image, the page number represents the ith image in the folder, not the ith group of "IMGS_PER_PAGE"s
      
      if (((int)($pageNumber % ($loadedImgsPerPage) )) == 0 ) // ie. if IMGS_PER_PAGE==24 and $pageNumber is 24, we should still get first page
        $whichIndexPage = ((int)($pageNumber / ($loadedImgsPerPage) )) ;
      else
        $whichIndexPage = ((int)($pageNumber / ($loadedImgsPerPage) )) + 1 ;

      $whichLine = (int)($pageNumber % $loadedImgsPerPage);
      if($whichLine == 0)
        $whichLine = $loadedImgsPerPage;
      
      $imgName = ''; // the actual image name in the folder we want to view. 
      
       // Determine Page File. 
      $specificIndexFile = '~A_' . $whichIndexPage . '.txt';
      
      // get the i-th (whichLine) filename out of the file
      $fh = fopen(IH_MetaCollectionsIndexRoot() . $folderStr . $specificIndexFile, 'r'); 
      if($fh)
      {
        $counter = 1;
        $line = '';
        while($line = fgets($fh))
        {
          if($whichLine == $counter)
          {
            $imgName = trim($line); // get rid of "\r\n"
            break;
          }          
          $counter++;
        }
        if(strcmp($imgName, '') === 0) // if imgName is still blank 
        {
          IH_RedirMessageHalt('/', "Error: No File resides in specified index! (" . $specificIndexFile . ") in (" . trim($folderStr,'/') . ")" , false); // go home
        }        
        fclose($fh);
      }
      else
      {
        IH_RedirMessageHalt('/', "Error: Cannot open index file (" . $specificIndexFile . ") in (" . trim($folderStr,'/') . ")" , false); // go home
      }
      
      // toggle the op for the arrows
      $arrowOpMarkup = '';
      if(strcmp($opStr, 'singleview') === 0)
        $arrowOpMarkup = "&op=singleview";
      else
        $arrowOpMarkup = "&op=fileedit";
      
      // Left Arrow State
      if( $pageNumber - 1 < 1 ) // display a disabled left arrow
      {
        $backArrowTargMarkup = "<img class=arrow src=GRAPHICS/arrow_left_disabled.gif>";
      }
      else // normal left arrow
      {
        $backArrowTarg = ".?fol=" . rawurlencode($folderStr) . "&page=" . ($pageNumber - 1) . $arrowOpMarkup;
        $backArrowTargMarkup = "<a id=\"prevLink\" href=\"" . htmlspecialchars($backArrowTarg) . "\"><img class=arrow src=GRAPHICS/arrow_left.gif></a>";
      }
      
      // Right Arrow State 
      if( $pageNumber + 1 > $loadedTotalNumImages )
      {
        $aheadArrowTargMarkup = "<img class=arrow src=GRAPHICS/arrow_right_disabled.gif>";
      }
      else // normal right arrow
      {
        $aheadArrowTarg = ".?fol=" . rawurlencode($folderStr) . "&page=" . ($pageNumber + 1) . $arrowOpMarkup;
        $aheadArrowTargMarkup = "<a id=\"nextLink\" href=\"" . htmlspecialchars($aheadArrowTarg) . "\"><img class=arrow src=GRAPHICS/arrow_right.gif></a>";
      }
      
      $bVid = false;
      // Determine if we're in the Video view mode (html5 player) 
      if(in_array(strtolower(pathinfo($imgName, PATHINFO_EXTENSION)), IH_GET_VIDEO_VIEW_MODE_EXTS()))
        $bVid = true;
      
      // navArrowRow possibilities for each view mode
      $leadingTextMarkup = '';
      $pencilLinkMarkup = '';
      $returnLinkMarkup = '';
      if(strcmp($opStr, 'singleview') === 0)
      {
        $pencilLinkMarkup = "<a href=\"" . htmlspecialchars(".?fol=".rawurlencode($folderStr)."&page=".$pageNumber."&op=fileedit" ) . "\"><img src=\"GRAPHICS/pencil.png\" title=\"Advanced File Mode\"></a>";
        $returnLinkMarkup = "<a id=\"upLink\" href=\".?fol=" . htmlspecialchars(rawurlencode($folderStr)) . "&page=" . $whichIndexPage . "\">GRID</a>";
      }
      else // fileedit
      {
        $leadingTextMarkup = 'Advanced: ';
        $returnLinkMarkup = "<a id=\"upLink\" href=\".?fol=" . htmlspecialchars(rawurlencode($folderStr)) . "&page=" . $pageNumber . "&op=singleview" . "\">BACK</a>";
      }
      
      // nav arrow row
      $origDlLink = "dl.php?fol=" . rawurlencode($folderStr) . "&file=" . rawurlencode($imgName) ;
      $arrowNavRowMarkup = "
                  <table class=arrowNavRowTable>
                    <tr>
                      <td>
                        <span style=\"padding-left: 16px;font:normal 12px/12px Arial; font-weight:bold; margin:0px 0px 0px 0px;\">
                          " . $leadingTextMarkup . htmlspecialchars($imgName) . " 
                          " . $pencilLinkMarkup . "
                          <a href=\"".htmlspecialchars($origDlLink)."\" download ><img src=\"GRAPHICS/down.png\" title=\"Download Original File\"></a>
                        </span>

                      </td>
                      <td class=navRightTd>
                        <div class=navRightDiv>
                          <span style=\"vertical-align:4px; font:normal 12px/12px Arial; font-weight:bold; margin:0px 0px 0px 0px;\">
                            ".$returnLinkMarkup."
                          </span>
                            " . $backArrowTargMarkup . "
                            <span class=pageindex>" . $pageNumber . "</span>
                            " . $aheadArrowTargMarkup . "
                        </div>
                      </td>
                    </tr>
                  </table>
                  ";
      if(strcmp($opStr, 'singleview') === 0)
      {
        // SINGLEVIEW TABLE   
        $imageTableMarkup .= "
                    <table id=singleViewTable>
                      <tr>
                        <td id=singleViewTableTD> ";
        $imageLinkA = "img.php?fol=" . rawurlencode($folderStr) . "&file=" . rawurlencode($imgName) . "&var=2" . "&s=" . $stateTag ;
        if($bVid)
        {
        $playerVid = "img.php?fol=" . rawurlencode($folderStr) . "&file=" . rawurlencode($imgName) . "&var=4" . "&s=" . $stateTag ;
          $imageTableMarkup .= "
                          <div align=center>
                            <video width=".VID_WIDTH." height=".VID_HEIGHT." controls poster=\"".htmlspecialchars($imageLinkA)."\" preload=\"none\">
                              <source src=\"".htmlspecialchars($playerVid)."\" type=\"video/mp4\">
                              Your browser does not support HTML5 video :(
                            </video>
                          </div>";
        }
        else // original path
        {
          $imageTableMarkup .= "                      
                          <a href=\"" . htmlspecialchars($origDlLink . "&view") . "\"><img src=\"" . htmlspecialchars($imageLinkA) . "\"></a>";
        }
        $imageTableMarkup .= "
                        </td> ";
        // ----==== COMMENTS ====----
        if(IH_ItemHasComments($folderStr, $imgName))
        {
          include 'CmtFns.php'; // drag the rest in
          
          $imageTableMarkup .= IH_GetCommentDivMarkup($folderStr, $imgName, $usernameStr, $modTokenStr, $pageNumber, $bShowCmtDelete);
        } 
        
        // end the singleview table 
        $imageTableMarkup .= "       
                      </tr>
                    </table>
                    ";
      
        // COPY/PASTE
        if(strcmp($usernameStr,'')!==0) // just need to be a logged-in user, and viewing the col already which we would be
          $imageTableMarkup .= GetCopyPasteDiv($folderStr, $imgName, $modTokenStr, $pageNumber); 
        
        // 'New Comment' Form     
        if(IH_CanUserUploadCollection($collectionStr, $usernameStr))
          $imageTableMarkup .= GetCommentPostDiv($folderStr, $imgName, $modTokenStr, $pageNumber);   
      }
      else // fileedit
      {
        $imageLinkA = "img.php?fol=" . rawurlencode($folderStr) . "&file=" . rawurlencode($imgName) . "&var=2" . "&s=" . $stateTag ;
        
        $pathtoIHAR = IH_MetaCollectionsRoot() . $folderStr . $imgName . '.IHAR' ;  // again, folderstr is at least '/MyCol/' shouldn't be just '/'
        
        $metaFileArr = Array();
        $metaFileStr = IH_OutputImage_IHAR($pathtoIHAR, 3); // 3 is text metadata section
        if($metaFileStr !== FALSE)
        {
          $metaFileArr = explode("\n", $metaFileStr);
          foreach($metaFileArr as &$elem)
            $elem = trim($elem); // clean-off any /r chars 
        }
        
        $pathToFile = IH_DataCollectionsRoot() . $folderStr . $imgName ;
        
        $imageTableMarkup .= "
        <div class=advancedbox>
          <div style=\"text-align: center;\">
            <span style=\"display: inline-block;\">
              <img style=\"width: 50%;\" src=\"" . htmlspecialchars($imageLinkA) . "\">
            </span>
          </div>
        </div>
        
        <div class=advancedbox2>
          <p><b>Name</b>: ". $imgName . "
          <p><b>Size</b>: ". filesize( $pathToFile ) ."
          <p><b>Mod Date</b>: ".  IH_FormatTimestamp($metaFileArr[1]) ." 
          <p><b>MIME</b>: ".  $metaFileArr[0] ."         
        </div>
        
        <div class=advancedbox2>
          <span style=\"display: inline-block; font-weight:bold; color: red; padding-bottom:8px;\">Delete</span>
          <br><i>Permanently removes this file.</i>
          <form style=\"margin-top: 10px;\" action=\"index.php\" method=\"GET\" accept-charset=\"UTF-8\">
            <input type=\"hidden\" name=\"op\" value=\"delitem\">
            <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
            <input type=\"hidden\" name=\"file\" value=\"" . htmlspecialchars($imgName) . "\">
            <input type=\"hidden\" name=\"page\" value=\"" . htmlspecialchars($pageNumber) . "\">
            <input type=\"submit\" value=\"Delete\" /> 
          </form>         
        </div>
        
        ";
        
      }
    }
    else
    if(strcmp($folderStr, '/') !== 0 && strcmp($opStr, 'folderedit') === 0 ) // FOLDEREDIT =========================================================================
    {
      // Special Case: We're admin, and the folder has been dragged to the data dir, outside of ImageHub. 
      // No Meta dirs exist (for current collection) and they all must be made to match what is in the data dir. (recursively)
      // if any one of these items doesnt exist, give admin the chance to generate them       
      
      $dirsArr = IH_CollectionMetaDirsArr($collectionStr);
      
      if(strcmp($usernameStr, 'admin') === 0 && (!file_exists( ($dirsArr[0] . '/.access') ) || !file_exists( $dirsArr[1] ) || !file_exists( $dirsArr[2] ) ) ) 
      {
         // the collection's root access file
         // folder containing index files for root of collection. 
         //folder containing thumb archives for files in root of collection.
        /* echo ("accessFilePath: " . $accessFilePath . "<br>\r\n");
        echo ("indexDirPath: " . $indexDirPath . "<br>\r\n");
        echo ("iharDirPath: " . $iharDirPath . "<br>\r\n"); */
        
        // nav arrow row
        $arrowNavRowMarkup = "
                    <table class=arrowNavRowTable>
                      <tr>
                        <td>
                          <span style=\"padding-left: 16px;font:normal 14px/14px Arial; font-weight:bold; margin:0px 0px 0px 0px;\">
                            Advanced: "  . htmlspecialchars(basename($folderStr)) . "
                          </span>                                
                        </td>
                      </tr>
                    </table>
                    ";
        
        $imageTableMarkup = "
                    <div id=infobox>
                      <span style=\" font-weight:bold; color: red;\">Initialize Collection Metadata and Indexes</span>
                      <p>Since \"" . htmlspecialchars($collectionStr) . "\" was moved/copied to the Image Hub data root folder manually, it has no corresponding Metadata directories. They must be generated before the collection can be browsed. 
                      
                      <form style=\"margin: 8px;\" action=\"folderedit.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"init\">
                        <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($collectionStr) . "\">
                        <input type=\"submit\" value=\"GO!\" /> 
                      </form>
                    
                      <p><i>Notice:This operation may take considerable time depending on the number of items in the new collection!</i>
                    </div>
                    ";
      }
      else // normal flow (folderedit)
      {
        // nav arrow row
        $arrowNavRowMarkup = "
                    <table class=arrowNavRowTable>
                      <tr>
                        <td>
                          <span style=\"padding-left: 16px;font:normal 14px/14px Arial; font-weight:bold; margin:0px 0px 0px 0px;\">
                            Advanced: "  . htmlspecialchars(basename($folderStr)) . "
                          </span>                                
                        </td>
                        <td class=navRightTd>
                          <div class=navRightDiv>
                            <span style=\"font:normal 12px/12px Arial; font-weight:bold; margin-right: 16px;\">
                              <a id=\"upLink\" href=\"".htmlspecialchars(".?fol=".rawurlencode($folderStr)."&page=".rawurlencode($pageNumber))."\">GRID</a>
                              
                            </span>
                          </div>
                        </td>
                      </tr>
                    </table>
                    ";
        // the boxes part  
        
        $accessInfoFormMarkup = '';
        // if we're in the root of the collection ie. '/MyCol1/'
        if( (count( explode('/', trim($folderStr, ' /')) ) == 1) &&
        (($accessFileLinesArr = file($dirsArr[0] . '/.access' , FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)) !== false )) // get lines from this collection's access file 
        {
          $accessLine1 = '';          $accessLine2 = '';          $accessLine3 = '';
          if(isset($accessFileLinesArr)) // this hullabaloo, otherwise  PHP Notice:  Undefined offset
          {
            if(isset($accessFileLinesArr[0]))
              $accessLine1 = $accessFileLinesArr[0];
            if(isset($accessFileLinesArr[1]))
              $accessLine2 = $accessFileLinesArr[1];
            if(isset($accessFileLinesArr[2]))
              $accessLine3 = $accessFileLinesArr[2];
          }
          $accessInfoFormMarkup .= "
          <div id=infobox>
            <span style=\"font-weight:bold; \">Permissions (Collection-Wide)</span>
            <form style=\"margin-top: 8px;\" action=\"folderedit.php\" method=\"POST\" accept-charset=\"UTF-8\">
            
              <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
              <input type=\"hidden\" name=\"op\" value=\"perms\">
              <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
            <table border=0>
            <tr>
              <td>            
                Owner: 
              </td>
              <td>
                <input type=\"text\" size=\"40\" maxlength=\"64\" name=\"owner\" value=\"" . htmlspecialchars($accessLine1) . "\">
              </td>
              <td>
                <i>A single user who has complete control over the collection.</i>
              </td>
            </tr>
            <tr>
              <td>
                Access-Level: 
              </td>
              <td>
                <span style=\"float: right;\">
                  " . AccessInfoFormSelectReturn($accessLine2) . "
                </span>
              </td>
              <td>
                <i>
                  <br><b>PUBLIC:</b> Anyone can view the collection. Users may upload/comment.
                  <br><b>USER:</b> Users may view the collection. Users may upload/comment.
                  <br><b>RESTRICTED:</b> Only specific members may view collection and or upload/comment. 
                </i>
              </td>
            </tr>
            <tr>  
              <td>
                Members:
              </td>
              <td>
                <input type=\"text\" size=\"40\" maxlength=\"80\" name=\"members\" value=\"" . htmlspecialchars($accessLine3) . "\">
              </td>
              <td>
                <i>
                  <br>Users who are granted access with <b>RESTRICTED</b> mode.
                  <br>(comma separated, without quotes) ex: \"user1,user2,user3\"
                </i>
              </td>
            </tr>
            <tr>  
              <td colspan=2>
                <span style=\"float:right;\">
                  <input type=\"submit\" value=\"Update\" />
                </span>
              </td>   
            </tr>
            </table> 
            </form>
                      ";  
          $accessInfoFormMarkup .= "
          </div>";
        }
        
        // Query zeroth index for Properties
        $numFilesThisFolder = 'Unable to Query';
        $sizeFolder = 'Unable to Query';
        $zerothIndexLinesArr = file( ( (IH_FolderMetaDirsArr($folderStr)[1]) . '~A_0.txt') , FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ;
        if($zerothIndexLinesArr !== false)
        {
          $numFilesThisFolder = $zerothIndexLinesArr[1];// line [1] stores num images for this index 
          if(isset($zerothIndexLinesArr[4]))
            $sizeFolder = $zerothIndexLinesArr[4];
        }
        
        $imageTableMarkup = "
                    <div id=infobox>
                      <span style=\"font-weight:bold; \">Folder Properties</span>
                      
                      <p>Number of Files: " . $numFilesThisFolder . "
                      <br>Size (MiB): " . $sizeFolder . "
                    
                    </div>

                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Copy / Move</span>
                      <br><i>Copy or Move the contents of your clipboard to this folder.</i>
                      <form style=\"margin-top: 8px;\" action=\"copymove.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"copy\">
                        <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                        <input type=\"submit\" value=\"Copy\" /> 
                      </form>
                      
                      <form style=\"margin-top: 8px;\" action=\"copymove.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"move\">
                        <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                        <input type=\"submit\" value=\"Move\" /> 
                      </form>
            
                    </div>
                    <div id=infobox>
                      <span style=\"font-weight:bold; \">Create Sub-Folder</span>
                      
                      <form style=\"margin-top: 8px;\" action=\"folderedit.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"makefolder\">
                        <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                        Name : <input type=\"text\" size=\"40\" maxlength=\"64\" name=\"newfolder\">
                        <input type=\"submit\" value=\"Create Folder\" /> 
                      </form>
            
                    </div>
                    " . $accessInfoFormMarkup . "
                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Indexing</span>
                      <br><i>Forces the re-initialization of the page indices which facillitate browsing. Run this if the current folder has lost sync with the files on disk. </i>
                      <form style=\"margin-top: 10px;\" action=\"folderedit.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"reindex\"> 
                        <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                        <input type=\"checkbox\" name=\"tmbs\" value=\"1\"> Regenerate Thumbnails 
                        <br>
                        <br><input type=\"submit\" value=\"Go\" />
                      </form>
                    </div>
                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; color: red; padding-bottom:8px;\">Delete</span>
                      <br><i>Removes this folder and all its subfolders and files.</i>
                      <form style=\"margin-top: 10px;\" action=\"index.php\" method=\"GET\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"op\" value=\"delitem\">
                        <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                        <input type=\"submit\" value=\"Delete\" /> 
                      </form>
                    </div>
                    ";      
      }
    }
    else
    if(strcmp($folderStr, '/') !== 0 && strcmp($opStr, 'delitem') === 0 ) // DELITEM CONFIRMATION ==================================================================
    {
      // default to values appropriate for folders
      $targetThingStr = 'folder and all its subfolders and files';
      $displayedTargetStr = htmlspecialchars($folderStr);
      $fileInputMarkup = '';
      $thumbnailMarkup = '';
      $cancelInputMarkup = "<input type=\"hidden\" name=\"op\" value=\"\">";
      
      if(strcmp($fileStr,'') !== 0) // if we have a file, assume valid as per convention, and send to handler.
      {
        // if we're deleting a file get the state tag, 
        $stateTag = GetCurrentFolderStateTag($folderStr);
        if(!is_string($stateTag))
          $stateTag = '';         
        
        $targetThingStr = 'file';
        $displayedTargetStr = htmlspecialchars($folderStr . $fileStr);
        $fileInputMarkup = "<input type=\"hidden\" name=\"file\" value=\"" . htmlspecialchars($fileStr) . "\">";
        
        // Display a thumb so they have an idea of whats getting nuked 
        $imageLinkA = "img.php?fol=" . rawurlencode($folderStr) . "&file=" . rawurlencode($fileStr) . "&var=2" . "&s=" . $stateTag ;
        $thumbnailMarkup = "
        <div class=advancedbox>
          <div style=\"text-align: center;\">
            <span style=\"display: inline-block;\">
              <img style=\"width: 50%;\" src=\"" . htmlspecialchars($imageLinkA) . "\">
            </span>
          </div>
        </div>
        ";
        
        $cancelInputMarkup = "
                      <input type=\"hidden\" name=\"page\" value=\"" . htmlspecialchars($pageNumber) . "\">
                      <input type=\"hidden\" name=\"op\" value=\"singleview\">
        ";
      }

      $imageTableMarkup = "
                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; color: red; padding-bottom:8px;\">Delete Confirmation!</span>
                      <br><b>Are you sure you want to remove this ".$targetThingStr."?</b>
                      <p><b>" . $displayedTargetStr . "</b>
                      ".$thumbnailMarkup."
                      <form style=\"margin-top: 10px;\" action=\"folderedit.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"reallydelitem\"> 
                        <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                        ".$fileInputMarkup."
                        <input type=\"submit\" value=\"Delete\" />
                      </form>
                      
                      <form style=\"margin-top: 10px;\" action=\".\" method=\"GET\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                        ".$cancelInputMarkup."
                        <input type=\"submit\" value=\"Cancel\" />
                      </form>
                      
                    </div>
                    ";      
    }
    else
    if( strcmp($opStr, 'newcol') === 0 ) // New Collection ==================================================================
    {
      $imageTableMarkup = "
                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Create New Image Collection</span>
                      <br>Please enter a new name for your Collection.
                      
                      <form style=\"margin-top: 10px;\" action=\"folderedit.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"newcol\"> 
                        Name : <input type=\"text\" size=\"40\" maxlength=\"64\" name=\"newcolname\">
                        <input type=\"submit\" value=\"Create\" />
                      </form>
                      <br><i>If you would like to allow other users or non-users to view this collection, please set it's \"Access-Level\" accordingly in the advanced menu (pencil) after creating it.</i>
                    </div>
                    ";
    }
    else
    if(strcmp($folderStr, '/') !== 0 && strcmp($opStr, 'upload') === 0 ) // Upload Page ==================================================================
    {
      // nav arrows 
      $arrowNavRowMarkup = "
                  <table class=arrowNavRowTable>
                    <tr>
                      <td>
                        <span style=\"padding-left: 16px;font:normal 14px/14px Arial; font-weight:bold; margin:0px 0px 0px 0px;\"> Uploader: " . htmlspecialchars(basename($folderStr)) . "</span>
                      </td>
                      <td class=navRightTd>
                        <div class=navRightDiv>
                          <span style=\"font:normal 12px/12px Arial; font-weight:bold; margin-right: 16px;\">
                            <a id=\"upLink\" href=\"".htmlspecialchars(".?fol=".rawurlencode($folderStr)."&page=".rawurlencode($pageNumber))."\">GRID</a>
                          </span>
                        </div>
                      </td>
                    </tr>
                  </table>
                  ";
      
      $imageTableMarkup = "
                    <div align='center'>
                      <div id=infobox>
                        <h2> Uploader </h2>
                        <div class='up-container'>
                          <p>
                              Select File(s): <input type='file' id='_file' multiple> <input type='button' id='_submit' value='Upload'> <input type='button' id='_abort' value='Cancel'>
                          </p>
                          <div class='up-progress-outer' align='left'>
                              <div id='_progress' class='up-progress' ></div>
                          </div>
                        </div>
                        
                      </div>
                      
                      <div style=\"width:80%;\">
                      <div id='uploadresult' >
                      </div>
                      </div>
                      
                    </div>
                    
                    <script>
                      // load in POST params
                      var usertoken = \"".$modTokenStr."\";
                      var folderStr = \"".htmlspecialchars($folderStr)."\";
                      // max number of files allowed
                      var maxFileNumber = \"".ini_get('max_file_uploads')."\";
                    </script>
                    <script src='upload.js'></script>
                    ";
    }
    else
    if( strcmp($opStr, 'act') === 0 ) // Account Settings ==================================================================
    {
      include 'AccountFns.php'; // pull in the necessary account fns
      
      $userDateStr = IH_GetUserCreateDate($usernameStr);
      
      $bCheckedMarkup = '';
      if($bShowCmtDelete)
        $bCheckedMarkup = 'checked';
      
      //clipboard parse
      $clipboardMarkup = '';
      $clpbrd = $_SESSION[IH_GetInstanceName().'-Clipboard'];
      //$clpbrd = 'abc;;def;;/ghi/jkl/a.jpg';
      if(strcmp($clpbrd,'')!==0)
      {
        $clpbrdArr = explode(CLPBRD_DELIMITER, $clpbrd);
        if(is_array($clpbrdArr) && count($clpbrdArr)>0)
        {
          $clipboardMarkup .= "
                        <div id=clipboardBox>";
          foreach($clpbrdArr as $item)
          {
            $clipboardMarkup .= "                          " . $item . "<br>\r\n";
          }
            
            $clipboardMarkup .= "
                        </div>";
                        
          $clipboardMarkup .= "
                      <form style=\"margin-top: 1px;\" action=\"act.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"clrclipboard\"> 
                        <input type=\"submit\" value=\"Clear\" />
                      </form>
          ";
        }
      }
      else
      {
        $clipboardMarkup .= "
      <p><i>empty</i>
      ";}
      
      $imageTableMarkup = "
                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Account Settings: " . $usernameStr . "</span>
                      <br>Create Date: " . $userDateStr . "
                      
                      <form style=\"margin-top: 10px;\" action=\"act.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"newpass\"> 
                        <table border=0>
                          <tr>
                            <td>
                              Old Password : 
                            </td>
                            <td>
                              <input type=\"password\" size=\"40\" maxlength=\"64\" name=\"oldpass\">
                            </td>
                          </tr>
                          <tr>
                            <td>
                              New Password : 
                            </td>
                            <td>
                              <input type=\"password\" size=\"40\" maxlength=\"64\" name=\"new1pass\">
                            </td>
                          </tr>
                          <tr>
                            <td>
                              New Password : 
                            </td>
                            <td>
                              <input type=\"password\" size=\"40\" maxlength=\"64\" name=\"new2pass\">
                            </td>
                          </tr>
                          <tr>
                            <td colspan=2>
                              <span style=\"float: right;\">
                                <input type=\"submit\" value=\"Change Password\" />
                              </span>
                            </td>
                          </tr> 
                        </table>
                      </form>
                      <br>
                    </div>
                    
                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Clipboard</span>
                      <br><i>Current list of file paths which can be copied or moved to a target folder.</i>
                      " . $clipboardMarkup . "
                    </div>
                    
                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Current Session Options</span>
                      <br><i>These options affect various appearance elements and will reset upon logging out. </i>
                      <form style=\"margin-top: 10px;\" action=\"act.php\" method=\"POST\" accept-charset=\"UTF-8\">
                        <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                        <input type=\"hidden\" name=\"op\" value=\"cmtdelicon\"> 
                        <input type=\"checkbox\" name=\"cmtdelicon\" value=\"1\" " . $bCheckedMarkup . "> Display Comment Delete Icon 
                        <br>
                        <br><input type=\"submit\" value=\"Set\" />
                      </form>
                    </div>
      ";
      // admin ops table 
      if(strcmp($usernameStr, 'admin')===0)
      {
        $imageTableMarkup .= "
                    <div id=infobox>
                      <span style=\"display: inline-block; font-weight:bold; padding-bottom:8px;\">Modify User Accounts</span>
                      
                      " . IH_ModifyUserAccountTableMarkup($modTokenStr) . "
                      " . IH_NewUserFieldMarkup($modTokenStr) . "
                    </div>
        
        ";
      }
    }
    else
    if(strcmp($folderStr, '/') !== 0 &&  strcmp($opStr, 'subfolders') === 0 ) // subfolders ==================================================================
    {
      $arrowNavRowMarkup = "
        <table class=arrowNavRowTable>
          <tr>
            <td>
              <span style=\"padding-left: 16px;font:normal 14px/14px Arial; font-weight:bold; margin:0px 0px 0px 0px;\"> &#x2022; " . htmlspecialchars(basename($folderStr)) . "</span>
              <a href=\"" . htmlspecialchars(".?fol=" . rawurlencode($folderStr) . "&op=folderedit" ) . "\"><img src=\"GRAPHICS/pencil.png\" title=\"Advanced Mode\"></a>
              <a href=\"" . htmlspecialchars(".?fol=" . rawurlencode($folderStr) . "&op=upload" ) . "\"><img src=\"GRAPHICS/up.png\" title=\"Upload File(s)\"></a>
            </td>
            <td class=navRightTd>
              <div class=navRightDiv>
                <span style=\"font:normal 12px/12px Arial; font-weight:bold; margin-right: 16px;\">
                  <a id=\"upLink\" href=\"".htmlspecialchars(".?fol=".rawurlencode($folderStr)."&page=".rawurlencode($pageNumber))."\">GRID</a>
                </span>
              </div>
            </td>
          </tr>
        </table>
        ";     
      $imageTableMarkup .= SubFoldersMarkup($folderStr);
    }
    else // HOME Page ==============================================================================================================================================
    {
      $newColMarkup = '';
      if(strcmp($usernameStr,'')!==0)
        $newColMarkup = "<a href=\"" . htmlspecialchars(".?op=newcol" ) . "\"><img src=\"GRAPHICS/pencil.png\" title=\"Create New Collection\"></a>";
      $collOwnedListMarkup = '';
      $collOtherListMarkup = '';
      $collectionsListMarkup .= "<!-- start of Collections -->
                <div id='leftcolumn'>
                  <h2 class=\"left\">
                    Collections
                    " . $newColMarkup . "
                  </h2>
                ";
      // this will be , outside of naive index generation, hopefully the only glob/readdir          
      $filesArr = glob(IH_DataCollectionsRoot() . DIRECTORY_SEPARATOR . '*'); // whatever directories we see in the data folder, spidered or not.
      foreach ($filesArr as $file)
      {
        if(is_dir($file))
        {
          $fileBasename = basename($file);
          
          // Bullet Coloring & Background Hue / Access Level & Owner Status
          $bulletMarkup = "<span class=albumdotERROR title=\"ERROR: Cannot determine collection level!\">&#x2022;</span>";
          
          // Ownership background color
          $ownerMarkup = '';  
          
          // does there exist an access file for this collection? 
          $accessFilePath =  IH_MetaCollectionsAccessRoot() . '/' . $fileBasename . '/.access' ; 
          if(file_exists($accessFilePath))
          {
            if(IH_CanUserReadCollection( $fileBasename, $usernameStr ))
            {
              $albumRowMarkup = ''; // the markup for the sampling of images show on 'HOME'
              
              $sizeCol = IH_GetFolderTotalSize('/'.$fileBasename.'/');
              
              // zeroth index 
              $zerothIndexArr = GetIndexIthFileAsArr('/'.$fileBasename.'/', 'A', 0);
              
              // Get a few images to display on the homepage...
              $imgsArr = GetIndexIthFileAsArr('/'.$fileBasename.'/', 'A', 1);
              
              if(!$imgsArr || !$zerothIndexArr) 
                $albumRowMarkup .= "<img src=GRAPHICS/placeholder128.png><!-- 1st index file not found -->"; // if index file was missing, put in a placeholder. 
              else // Happy Flow (when theres images to put in the albumrow)
              {
                $stateTag = ''; // load the index state, this allows us to override the cached copy if the folder was reindexed prior to cahced image expiry. 
                if(array_key_exists('3', $zerothIndexArr))
                  $stateTag = $zerothIndexArr[3];// 4th line 
                
                $numImgsRow = 9; 
                $i = 0;
                foreach($imgsArr as $img) // walks through the first index file and paginates the first n images of it, no randoms yet 
                {
                  if($i < $numImgsRow)
                  { 
                    $imageSrc = "img.php?fol=" . rawurlencode($fileBasename) . "&file=" . rawurlencode(trim($img)) . "&var=1" . "&s=" . $stateTag;
                    $albumRowMarkup .= "<img src=\"" . htmlspecialchars($imageSrc) . "\">";
                  }
                  else
                    break; // itll bail here if we get higher than the hard set limit, else we could also run out of items in the index file too. 
                  
                  $i++; 
                }
              }
              
              $bOwnedCol = false;
              $collectionArr = IH_GetCollectionMetaArr($fileBasename);              
              if($collectionArr !== false) 
              {
                $currentAccess = $collectionArr[1]; // accessLevel is the second line
                
                if( $currentAccess == AccessLevels::ACCESS_PUBLIC )
                  $bulletMarkup = "<span class=albumdotPUB title=\"Public Collection\">&#x2022;</span>";
                else if( $currentAccess == AccessLevels::ACCESS_USER )
                  $bulletMarkup = "<span class=albumdotUSER title=\"User Collection\">&#x2022;</span>";
                else if( $currentAccess == AccessLevels::ACCESS_RESTRICTED )
                  $bulletMarkup = "<span class=albumdotRES title=\"Restricted Collection\">&#x2022;</span>";
                
                $currentOwner = $collectionArr[0];
                if(strcmp($currentOwner, $usernameStr) === 0)
                {
                  $ownerMarkup = 'albumrowBLUE'; // add to alter background color 
                  $bOwnedCol = true;
                }
              }   
              
              $link = ".?fol=" . rawurlencode( '/' . $fileBasename . '/' ) ;
              $tempRowMarkup = "
                  <div class=\"albumrow ".$ownerMarkup."\">
                    ".$bulletMarkup." <a target=\"_top\" href=\"".htmlspecialchars($link)."\" class=\"menu_default\">".htmlspecialchars($fileBasename)."</a> <span id=albumszTxt>".$sizeCol." MiB</span>
                    <br><a href=\"".htmlspecialchars($link)."\" >" . $albumRowMarkup . "</a>
                  </div>" ;
              if($bOwnedCol)
                $collOwnedListMarkup .= $tempRowMarkup;
              else
                $collOtherListMarkup .= $tempRowMarkup;
            }
          }
          else // ACCESS FILE NON-EXISTANT 
          {
            if(strcasecmp($usernameStr, 'admin') === 0)
            {
              $link = ".?fol=" . rawurlencode( '/' . $fileBasename . '/' ) ;
              $collOtherListMarkup .= "
                  <div class=\"albumrow\">
                    ".$bulletMarkup." <a target=\"_top\" href=\"".htmlspecialchars($link)."\" class=\"menu_default\">".htmlspecialchars($fileBasename)."</a> <font color=red>&#x2757</font>
                    <br><img src=GRAPHICS/placeholder128.png>
                  </div>" ;
            }
          }
        }
      }
      $collectionsListMarkup .= $collOwnedListMarkup . "\r\n" . $collOtherListMarkup; // puts owned collections before non-owned 
      $collectionsListMarkup .= "
                </div>\r\n<!-- end of Collections -->";
    }

// COMBINE ALL MARKUP BELOW ==============================    
    $navMarkup = "
      <!DOCTYPE html>
      <html lang=\"en-US\">
      
      <head>
      <title>Image Hub</title>
      <meta charset=\"utf-8\">
      <link rel=\"icon\" href=\"favicon.ico\" type=\"image/x-icon\">
      <link rel=\"stylesheet\" type=\"text/css\" href=\"CSS/stdtheme.css\">
      
      <script type=\"text/javascript\" src=\"header-script.js\"></script> 
      </head>

      <body>
        <div id=\"top\">
          <div id=\"topLogo\">
            <img src=\"GRAPHICS/bullet1.png\" style='margin-right:15px;'>
            <span style=\"font:normal 16px/16px Arial; font-weight:bold;\">Image Hub</span>
          </div>
          <div id=messageBlock>  
            <i>" . htmlspecialchars($messageStr) . "</i>
          </div>
        </div>

        <div id=\"topnav\">
          <div id=\"topnavBar\">
             <a class=\"topnavBar\" href='.'>HOME</a>
             " . $linkRowMarkup . "
          " . $accountStatusMarkup . "
          </div>
        </div>";
      
    $belowNavMarkup = "
          <div id='belowTopnav'>
          <div id='page'>  

              <div id='main'>
                " . $collectionsListMarkup . "

                " . $arrowNavRowMarkup . "
                  
                ". $imageTableMarkup ."                
              </div>

            <!-- across bottom -->
            <p>
            <hr style=\"height:3px;\">
            <div class=\"footer\">
              <div id=\"footerText\">
              
              " . $footerStatusText . "

              </div>
              
              <div id=\"footerAbout\">
                <i>Image Hub v" . THE_VERSION . "</i>
              </div>
            </div>
            
          </div>
        </div>
      </body>
      </html>
"; 
    echo ($navMarkup . $belowNavMarkup);
  }

// ===================================================================================================
// MAIN ==============================================================================================
  
  if(!file_exists(IH_Data()) && !file_exists(IH_Meta())) // then we need to do a litte setting-up
  {
    include 'Setup.php'; // pull-in setup routines and execute them
    ExecSetup();
  }
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');  

  $usernameStrGlobal = '';
  $modTokenStrGlobal = '';
  $bShowCmtDeleteGlobal = false;
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
  {
    $usernameStrGlobal = IH_GetUserName(); 
    $modTokenStrGlobal = $_SESSION[IH_GetInstanceName().'-modtoken'];
    
    if(strcmp( $_SESSION[IH_GetInstanceName().'-ShowCmtDelete'], 'true')===0)
      $bShowCmtDeleteGlobal = true;
  }
  IH_SessionClose();// No Session-dependant calls after here
  
  $folderStrGlobal = '/';  // defaults to safe "Welcome" screen 
  $collectionStrGlobal = ''; // defaults to not being in a collection, welcome page
  $fileStrGlobal = ''; // which file(safe filename) we're looking at, currently only for delitem 
  
  $pageValue = 1;
  if(isset($_GET['page']))
    $pageValue = IH_NormalizePageVar($_GET['page']); 
  
  // operation mode of page
  $operationStr = ''; 
  if($_GET && isset($_GET['op']))
    $operationStr = (is_string($_GET['op']) ? $_GET['op'] : '');  // assign
  // valid op check
  if(strcmp($operationStr, '') !== 0 && 
     strcmp($operationStr, 'singleview') !== 0 && 
     strcmp($operationStr, 'folderedit') !== 0 && 
     strcmp($operationStr, 'fileedit') !== 0 && 
     strcmp($operationStr, 'newcol') !== 0 &&
     strcmp($operationStr, 'delitem') !== 0 &&
     strcmp($operationStr, 'act') !== 0 &&
     strcmp($operationStr, 'upload') !== 0 &&
     strcmp($operationStr, 'subfolders') !== 0)
  {     
    $operationStr = '';
  }
  
  if($_GET && isset($_GET['fol']) && is_string($_GET['fol']))
    $folderStrGlobal = $_GET['fol'];
  
  if($_GET && isset($_GET['file']) && is_string($_GET['file']) && strlen($_GET['file'])>0 )
  {
    if(IH_IsValidFilename($_GET['file']))
      $fileStrGlobal = $_GET['file'];
  }

  $msgString = '';
  if($_GET && isset($_GET['msg']) && is_string($_GET['msg']))  // message 
  {
    $msgString = $_GET['msg'] ;
    if( strlen($msgString) > 200 )
      $msgString = substr($msgString, 0, 197) . '...' ; // length limit
  }
    
  // Validate Folder String
  $bWasSanitized = IH_SanitizeBaseArg($folderStrGlobal);  
  // at this point $folderStrGlobal, is either '/' or '/A/' or '/A/*/**/' (something safe) 
  
  if(strcmp($operationStr, 'newcol') === 0) // if making a new col, we just need to be logged in. 
  {
    $folderStrGlobal = '/';
    $collectionStrGlobal = '';
    if(strcmp($usernameStrGlobal, '') === 0)
    {
      $operationStr = '';
      $msgString = 'Authorization Error: You must be logged in to perform this operation.';
    }
  }
  else
  if(strcmp($operationStr, 'act') === 0) // account settings page
  {
    $folderStrGlobal = '/';
    $collectionStrGlobal = '';
    if(strcmp($usernameStrGlobal, '') === 0)
    {
      $operationStr = '';
      $msgString = 'Authorization Error: You must be logged in to perform this operation.';
    }
  }
  else
  if(strcmp($folderStrGlobal, '/') !== 0) // if we're in a collection, make sure we're allowed to be there, based on which arg we pass
  {  
    $collectionStrGlobal = IH_GetCollectionNameFromFolderStr($folderStrGlobal);
  
    if(strcmp($collectionStrGlobal, '') !== 0 ) // if we're in a collection
    {
      // PERMS   // if mutative op 
      if(strcmp($operationStr, 'folderedit') === 0 || 
         strcmp($operationStr, 'fileedit') === 0 || 
         strcmp($operationStr, 'delitem') === 0)
      {
        if( IH_CanUserModCollection($collectionStrGlobal, $usernameStrGlobal) )
        {
        }
        else // not authorized to edit said collection 
        {
          if(strcmp($operationStr, 'fileedit') === 0) // back us out to singleview 
            $operationStr = 'singleview';
          else
            $operationStr = ''; // else back us out to grid 
          
          $msgString = 'Authorization Error: Insufficient Modify Permissions.';
          
          if( IH_CanUserReadCollection($collectionStrGlobal, $usernameStrGlobal) )
          {
          }
          else // FAILURE, revert to root '/'
          {
            $msgString = 'Authorization Error: Insufficient Read & Modify Permissions.'; 
            $folderStrGlobal = '/';
            $collectionStrGlobal = '';
          }    
        }
      }
      else
      if(strcmp($operationStr, 'upload') === 0) // 'special' upload page 
      {
        if( IH_CanUserUploadCollection($collectionStrGlobal, $usernameStrGlobal) )
        {
        }
        else // not authorized to upload to said collection 
        {
          $msgString = 'Authorization Error: Insufficient Upload Permissions.';
          $operationStr = '';
          if( IH_CanUserReadCollection($collectionStrGlobal, $usernameStrGlobal) )
          {
          }
          else // FAILURE, revert to root '/'
          {
            $msgString = 'Authorization Error: Insufficient Read & Upload Permissions.'; 
            $folderStrGlobal = '/';
            $collectionStrGlobal = '';
          }
        }
      }
      else // non mutative ops 
      {
        if( IH_CanUserReadCollection($collectionStrGlobal, $usernameStrGlobal) )
        {
          // Success , leave as set, and paginate
        }
        else // FAILURE, revert to root '/'
        {
          $msgString = 'Authorization Error: Insufficient Read Permissions.';
          $folderStrGlobal = '/';
          $collectionStrGlobal = '';
        }
      }
    }
  }
  /*
  if(0) // debugging
  {
    //var_dump($_GET);
    echo("page: " . $_GET['page'] . "<br>\r\n");
    echo("op: " . $_GET['op'] . "<br>\r\n");
    echo("fol: " . $_GET['fol'] . "<br>\r\n");
    echo("msg: " . htmlspecialchars($_GET['msg']) . "<br>\r\n");
    //die();
  }*/

  Echo_Layout($usernameStrGlobal, $collectionStrGlobal, $folderStrGlobal, $fileStrGlobal, $pageValue, $operationStr, '', $msgString, $modTokenStrGlobal, $bShowCmtDeleteGlobal, isMobile());    
