// Upload.js

  var _submit = document.getElementById('_submit'),
  _abort = document.getElementById('_abort'), 
  _file = document.getElementById('_file'), 
  _progress = document.getElementById('_progress'),
  _uploadresult = document.getElementById('uploadresult');

  _abort.disabled = true;

  //variables called during 'progress' event 
  var curLatestPercent = 0;
  var candidate = 0;
  
  var bAborted = false;
  
  var request;

  var upload = function()
  {
    if(_file.files.length === 0)
    {
      _uploadresult.innerHTML = '<p> No Files Selected.';
      return;
    }
    if(_file.files.length > maxFileNumber)
    {
      _uploadresult.innerHTML = '<p> Too Many Files Selected! Max:' + maxFileNumber;
      return;
    }
    
    _uploadresult.innerHTML = ''; // clear results if previous event occurred

    // switch off submit
    _submit.disabled = true;
    
    // switch on Cancel
    _abort.disabled = false;

    var data = new FormData();
    data.append('mode', "js"); // javascript uploader mode 
    data.append('jrr', usertoken); // session token
    data.append('fol', folderStr); // target folder   
    
    // File(s)
    var ins = _file.files.length; // num files 
    data.append('numfiles', ins); // intended number of files to upload. If this does not match at other end, an abort has occurred 
    for (var x = 0; x < ins; x++) 
      data.append("userfile[]", _file.files[x]);
      
    request = new XMLHttpRequest();
    
    request.onreadystatechange = function()
    {
      if(request.readyState == 4) // when the upload has finished 
      {
        curLatestPercent = 0;
        candidate = 0;
        _progress.style.width = curLatestPercent +  '%';
        
        // switch on submit
        _submit.disabled = false;

        // switch off Cancel
        _abort.disabled = true;
      
        try 
        {
            var resp = JSON.parse(request.response);
        } 
        catch (e)
        {
            var resp = 
            {
                status: 'Error',
                data: 'Unknown error occurred: [' + request.responseText + ']'
            };
        }
        
        if(!bAborted)
          _uploadresult.innerHTML = '<p><b> ' + resp.status + ':</b> ' + resp.data;
        else
          _uploadresult.innerHTML = '<p> Upload Operation Aborted.';
        
        bAborted = false; //reset
      }
    };
    
    /*request.upload.addEventListener('abort', function(e)
    {
      console.log("ABORT CALLED");
    }, false);*/

    request.upload.addEventListener('progress', function(e)
    {
      candidate = Math.ceil((e.loaded/e.total) * 100); 
      if ( candidate > curLatestPercent ) // sends only the necessary updates to the gui
      {
        curLatestPercent = candidate;
        _progress.style.width = curLatestPercent +  '%';
      }
        
    }, false);

    request.open('POST', 'upload_file.php');
    request.send(data);
  }

  _submit.addEventListener('click', upload);

  var abortUpload = function()
  {
    bAborted = true;
    request.abort();
  }

  _abort.addEventListener('click', abortUpload);
  