<?php

  include 'GenFns.php';
  include 'ModFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');
  
  // Output JSON
  function outputJSON($msg, $status = 'error')
  {
      header('Content-Type: application/json');
      die(json_encode(array(
          'data' => $msg,
          'status' => $status
      )));
  }
  
  // START ======================================================================================================================
  $usernameStrGlobal = '';
  $modTokenStrGlobal = '';
  
  // Mode (unset assume traditional form upload, else javascript which needs json...)
  $bModeJSON = false;
  if($_POST && isset($_POST['mode']) && is_string($_POST['mode']) && strcmp($_POST['mode'], 'js') === 0 )
    $bModeJSON = true;
  
  // numfiles (tells us the intended number of files that should be in the $_FILES array, if it doesn't match an abort was called... so dont keep anything 
  if($_POST && isset($_POST['numfiles']) && is_string($_POST['numfiles'])  )
  {
    $numfiles = $_POST['numfiles'];
    if(is_numeric($numfiles))
    {
      $iv = intval($numfiles);
      if( $numfiles == $iv )
      {
        $numfiles = $iv;
        if($numfiles >= 1 && $numfiles <= 10000000)
        {
          if($numfiles != count($_FILES['userfile']['name']))
            die(); // don't proceed
        }
        else
          die();
      }
      else
        die();
    }
    else
      die();
  }
  else
    die();
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
  {
    $usernameStrGlobal = IH_GetUserName(); 
    $modTokenStrGlobal = $_SESSION[IH_GetInstanceName().'-modtoken'];
  }
  else
  {
    if($bModeJSON)
      outputJSON('Not Authorized to Upload Files. (001)');
    else
      IH_RedirMessageHalt('/', "Not Authorized to Upload Files. (001)" , false);
  }
  
  IH_SessionClose();// No Session-dependant calls after here
  
  $passedToken = '';
  if($_POST && isset($_POST['jrr']) && is_string($_POST['jrr']))
    $passedToken = $_POST['jrr'];
  
  // Validate Token "Credentials"
  if((strlen($passedToken) === 0) || (strlen($modTokenStrGlobal) === 0) || !hash_equals($modTokenStrGlobal, $passedToken))
  {
    if($bModeJSON)
      outputJSON('Not Authorized to Upload Files. (002)');
    else
      IH_RedirMessageHalt('/', "Not Authorized to Upload Files. (002)" , false);  
  }
  
  $folderStrGlobal = '';  
  $collectionStrGlobal = ''; 
  
  if($_POST && isset($_POST['fol']) && is_string($_POST['fol']))
      $folderStrGlobal = $_POST['fol'];
    
  // Validate Folder String
  $bWasSanitized = IH_SanitizeBaseArg($folderStrGlobal);
  
  $collectionStrGlobal = IH_GetCollectionNameFromFolderStr($folderStrGlobal);

  if(!$bWasSanitized && (strcmp($usernameStrGlobal, '') !==0) && IH_CanUserUploadCollection($collectionStrGlobal, $usernameStrGlobal)) // logged in and has access 
  {
    ignore_user_abort(true); // Ignore user aborts and allow the script to run forever
    set_time_limit(0);

    $successfulUploadCnt = 0;
    $successfulFileList = '';
    
    $uploadedPathsArr = array();
    
//upload_file specific
    $ErrorString = '';
    
    if( ($fp = IH_GetFolderLock($folderStrGlobal)) !== false) // LOCK
    {
      // Loop through each file (per-file upload loop)
      // ===============================================================================================================
      for($i=0; $i<count($_FILES['userfile']['name']); $i++)
      {
        $tmpFilePath = $_FILES['userfile']['tmp_name'][$i]; // where its stored currently, usually "/tmp/randomname"

        if ($tmpFilePath != '' && ($_FILES["userfile"]["size"][$i] > 0))//Make sure we have a filepath and some size!
        {
          $path_info1 = pathinfo($_FILES["userfile"]["name"][$i]);
          $path_info1_extension = strtolower($path_info1['extension']) ; // ie. "jpg", "png" 
          $path_info1_filename = $path_info1['filename']; // yields an EXTENSION-LESS name of the file
          
          if (strcasecmp("PHP", $path_info1['extension']) == 0) // no .phps allowed
          {
            $ErrorString .= "<br>Disallowed Extension: " . $_FILES["userfile"]["name"][$i] ;
            continue; 
          }
          
          if ($_FILES["userfile"]["error"][$i] > 0) // any errors in the associative array.
          {
            $ErrorString.="<br>Return Code:&nbsp;".$_FILES["userfile"]["error"][$i]."&nbsp;&nbsp;File:&nbsp;&nbsp;".$_FILES["userfile"]["name"][$i] ;
            continue;
          }
          else
          {
            if(0) // degugging
            {
              echo "<p>";
              echo "Upload: " . $_FILES["userfile"]["name"][$i] . "<br />";
              echo "Type: " . $_FILES["userfile"]["type"][$i] . "<br />";
              echo "Size: " . ($_FILES["userfile"]["size"][$i] / 1024) . " Kb<br />";
              echo "Temp file: " . $_FILES["userfile"]["tmp_name"][$i] . "<br />";
            }

            $bValidOriginalFilename = IH_IsValidFilename($_FILES["userfile"]["name"][$i]); // name passed in in associative array ie. "mypic.jpg" 
            
            $finalFilename = '' ;
            if($bValidOriginalFilename)
              $finalFilename = $path_info1_filename;
            else
              $finalFilename = 'NewFile';
            
            $finalExtension = '';
            if(strlen($path_info1_extension) > 0)
              $finalExtension = '.' . $path_info1_extension ;
            
            $finalFilename = IH_NameAdjuster( IH_DataCollectionsRoot() . $folderStrGlobal , $finalFilename, $finalExtension ) ;
            
            $finalFilePath = IH_DataCollectionsRoot() . $folderStrGlobal . $finalFilename . $finalExtension  ;     
    
            $uploadedPathsArr[] = $folderStrGlobal . $finalFilename . $finalExtension ; // only generate ihars for the files uploaded NOW

            move_uploaded_file($_FILES["userfile"]["tmp_name"][$i], $finalFilePath);  
            
            if(file_exists($finalFilePath)) // if the file now resides there, bump the success counter.
            {
              $successfulUploadCnt++;

              if(!empty($successfulFileList))
                $successfulFileList .= ', ' ;
              $successfulFileList .= $finalFilename . $finalExtension ;
            }
            
            if(!$bValidOriginalFilename)
            {
              $ErrorString.="<br><b>". htmlspecialchars($_FILES["userfile"]["name"][$i]) . "</b> Contains Illegal Characters, renaming to <b>" . htmlspecialchars($finalFilename . $finalExtension) . "</b>" ;
            }
          }
        }
      } // end of per-file loop...
      
      IH_ReleaseFolderLock($fp);
    } 
    else
    {
      if($bModeJSON)
        outputJSON('Unable to move uploaded files to final directory.');
      else
        IH_RedirMessageHalt('/', "Unable to move uploaded files to final directory." , false);
    }
    
    IH_InitializeFolder( $folderStrGlobal, false );
    
    IH_InitiateIHARMaker($uploadedPathsArr);
    
    
    // SUCCESS
    if($bModeJSON)
      outputJSON("Upload Routine Finished. " . $successfulUploadCnt . " files received. (" . $successfulFileList . ")", 'success');
    else
      IH_RedirMessageHalt($folderStrGlobal, "Upload Routine Finished. " . $successfulUploadCnt . " files received" , false); // successful redirect
  }
  else
  {
    if($bModeJSON)
      outputJSON('Not Authorized to Upload Files.  (003)');
    else
      IH_RedirMessageHalt('/', "Not Authorized to Upload Files.  (003)" , false);
  }
  
?>