<?php

  // Comment Functions
  // Storage/Retrieval/POD etc.
  
  // Concurrency
  function IH_GetCmtLock($folderStr, $fileStr) 
  {
    $lockFilename = IH_GetCommentFileLocation($folderStr, $fileStr) . '.lock';
    touch ($lockFilename);
    $fp = fopen($lockFilename, "r+");
    if($fp)
    {
      if(flock($fp, LOCK_EX)) // should block if unavailable
        return $fp;
      else
        return false;      
    }
    else
      return false; 
  }
  function IH_ReleaseCmtLock($filePointer)
  {
    flock($filePointer, LOCK_UN);
    fclose($filePointer);
  }
  // USAGE
  /* if( ($fp = IH_GetCmtLock("abc")) !== false)
  {
    // do work here     
    IH_ReleaseCmtLock($fp);
  } */
  
  // ======== CommentItem ================================================================
  class CommentItem
  {
    public $titleStr = '';
    public $userStr = '';
    public $commentStr = '';
    public $timestampStr = ''; 
    public $guidStr = '';
    
    function __construct($title, $user, $com, $guid)
    {
      $this->titleStr = $title;
      $this->userStr = $user;
      $this->commentStr = $com;
      $this->timestampStr = IH_GetTimestamp();
      $this->guidStr = $guid;
    }
  }
  
  function IH_ArrContainsCmtGuid($theArr, $guidCand) // loops through the array of CommentItems and determines if the guid is present. 
  {
    foreach($theArr as $item)
    {
      if(strcmp($item->guidStr, $guidCand)===0)
        return true; // found it 
    }
    return false;
  }
  
  function IH_ActualizeCommentFolder($folderStr, $fileStr)
  {
    $path = IH_GetCommentFileLocation($folderStr, $fileStr); // is the FOLDER containing the comment/lock files 
    
    // if folder isnt there, make it...
    if(!file_exists($path))
      mkdir($path, 0755, true); // makes all intermediate folders if they dont exist either
    
    touch ($path . '.lock'); 
  }
  
  function IH_MartializeCommentArray($commentArr, $folderStr, $fileStr) // take the array of comment objects and commit them to the .comment file, deleting the previous one if existing 
  {
    $path = IH_GetCommentFileLocation($folderStr, $fileStr);
    
    // if folder isnt there, make it...
    if(!file_exists($path))
      mkdir($path, 0755, true); // makes all intermediate folders if they dont exist either 
    
    return file_put_contents($path . '.comment', base64_encode(serialize($commentArr))); // returns error codes from put_contents fn          the existing file is also overwritten
  }
  
  function IH_UnMartializeCommentArray($folderStr, $fileStr)// take what resides on disk and load an array with it, returning it to the caller 
  {
    $path = IH_GetCommentFileLocation($folderStr, $fileStr);
    $toReturnArr = unserialize(base64_decode( file_get_contents($path . '.comment') ));
    if(is_array($toReturnArr)) // lil check
      return $toReturnArr;
    
    return false;
  }
  
  function IH_GetCommentDivMarkup($folderStr, $fileStr, $usernameStr, $modTokenStr, $pageNumber, $bShowCmtDelete) // given the params, returns correct markup for comment table sidebar. called from gridview and singleview 
  {
    $retStr = '';
    if(($theArr = IH_UnMartializeCommentArray($folderStr, $fileStr)) !== false)
    {
      $retStr .= "
                      <td id=TableCmtTD>
                        <div style=\"width: 350px; height: 646px; margin: 0px; padding: 0px; overflow: scroll \">
                        <div id=cmtRowDivFirst>
                          <b>COMMENTS</b>
                        </div>
                        ";
                        
      //<img style=\"margin-right:0px;\" src=\"GRAPHICS/delicon.png\">";
      foreach($theArr as $elem) // print out each comment 
      {
        $retStr .= "
                          <div id=cmtRowDiv>
                            <b>" . htmlspecialchars($elem->userStr) . "</b>: " . htmlspecialchars($elem->commentStr) . "
                            ";
        if($bShowCmtDelete && ((strcmp($usernameStr, $elem->userStr)===0)||(strcmp($usernameStr, 'admin')===0)))
        {                    
        $retStr .= "                    
                            <div align=right>
                              <form action=\"comment.php\" method=\"POST\" accept-charset=\"UTF-8\">
                                <input type=\"hidden\" name=\"jrr\" value=\"" . $modTokenStr . "\">
                                <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                                <input type=\"hidden\" name=\"file\" value=\"" . htmlspecialchars($fileStr) . "\">
                                <input type=\"hidden\" name=\"page\" value=\"" . $pageNumber . "\">
                                <input type=\"hidden\" name=\"op\" value=\"delcmt\">
                                <input type=\"hidden\" name=\"cmtguid\" value=\"" . $elem->guidStr . "\">
                                <input type=\"image\" src=\"GRAPHICS/delicon.png\" alt=\"Submit\" width=\"9\" height=\"9\">
                              </form>
                            </div>
                        ";
        }
        $retStr .= "</div>
        ";
      }                            
      $retStr .= "
                          </div>          
                      </td>
                      ";
    }
    return $retStr;
  }  
  
  