<?php

  /*  ----------------------------------------------------------------------------------
  *   --USER DEFINED PARAMETERS, HANDLE WITH CARE---------------------------------------
  *   ---------------------------------------------------------------------------------- */
  
  require 'Config-Dirs.php'; // bring in installation-specific paths separately, here

  const THE_VERSION = '0.98'; 

  // Account Parameters
  const PASSWORD_FILENAME = 'passwd.txt';

  // names can only contain these chars or they will fail upon creation, dont put commas in here!
  const USERNAME_CHAR_WHITELIST = '-_0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz@';  

  const IHAR_CACHE_AGE = '4838400'; // Cache-Control Setting (8-weeks)

  // Mini Thumbnail Dimensions, shouldnt be changed unless you want to throw things out of alignment
  const THUMB_WIDTH = 128;
  const THUMB_HEIGHT = 128;
  const IMGMAG_MINITHUMB_SETTINGS = "-thumbnail ?w?x?h?^ -background \"#000000\" -gravity center -extent ?w?x?h? -format jpg -quality 70"; // ?w?, ?h?  placeholders

  // Medium Thumb for single image screen mode.
  const MEDTHUMB_WIDTH = 800;
  const MEDTHUMB_HEIGHT = 600;
  const IMGMAG_MEDTHUMB_SETTINGS = "-thumbnail ?w?x?h? -background \"#101020\" -gravity center -extent ?w?x?h? -format jpg -quality 90"; // ?w?, ?h?  placeholders
  const IMGMAG_MEDTHUMB_SETTINGS2 = "-format jpg -quality 90"; // used when we dont need to resize it, its already below the MEDTHUMB limits in both dimensions

  const IMGMAG_MEDTHUMB_CMD_DET_ORI = "identify -format '%[EXIF:Orientation]' "; // orientation detection cmd 
  const IMGMAG_MEDTHUMB_SETTINGS_ORIENT  = "-format jpg -quality 100 -auto-orient"; // 'straightens' the image and sets its orientation exif data to 1

  // Index Files Settings
  const IMGS_PER_PAGE = 24; // each index file contains at most this many items. 

  const GRID_COLS = 6;
  const GRID_ROWS = 5;

  // Image MIME Types...
  function IH_GET_IMAGE_MIME_TYPES()
  {
    return array( 
     'image/jpeg', 
     'image/png', 
     'image/gif' 
    ); // when we encounter these during IHAR generation, process the file as an image 
  }

  const COMMENT_GUID_LEN = 8;

  const CLPBRD_DELIMITER = ';;'; // must constitute an invalid filename character

  // Video Settings...
  const VID_WIDTH = 640; // dimensions for the html5 video tag
  const VID_HEIGHT = 480;
  function IH_GET_VIDEO_MIME_TYPES()
  {
    return array( 
      'video/mp4', 
      'video/webm', 
      'video/quicktime', // mov
      'video/x-m4v', // new (as of php 7, thanks apple)
      'video/x-msvideo' // avi
    ); // when we encounter these during IHAR generation, process the file as video 
  }
  function IH_GET_VIDEO_VIEW_MODE_EXTS() // Determine if we're in the Video view mode (html5 player)
  {
    return Array(
      'mp4', 
      'm4v', 
      'mov', 
      'webm', 
      'avi'
    );
  }
  // ffmpeg settings strings 
  const FFMPEG_DOWNSAMPLE = "ffmpeg -i ?in? -vf scale=w=?w?:h=?h?:force_original_aspect_ratio=decrease -c:v libx264 -preset medium -pix_fmt yuv420p -c:a aac -movflags +faststart ?strict? ?out? -hide_banner";
  const FFMPEG_SNAPSHOT = "ffmpeg -i ?in? -q:v 2 -vframes 1 ?out?"; // inFile to rnd.jpg

  // .sample file line delimiter (needs to be an illegal char or group of them)
  const SAMPLE_FILE_DELIM = '???';