<?php
  
  // Creates a multi-tiered tree structure based-off of (exiftool -a -G1)'s output 
  // Return: false (for any abnormality encountered)
  function ParseExifToolOutput($inStr)
  {
    $firstChar = substr($inStr, 0, 1);
    
    if($firstChar == '[') // in an error condition, the first char of output wont begin with a bracket 
    {
      
      $retArr = Array();
      
      $lineArr = preg_split("/\r\n|\n|\r/", $inStr); // accepts all types of newline permutations; though we should only ever need "\n"
      
      $i = 0;
      foreach($lineArr as $lineStr) //  walks through each line
      {
        $i++;
        
        if($lineStr == '') // skip blank lines 
          continue;
        
        $openBracketIndex = strpos($lineStr, '[');
        $closeBracketIndex = strpos($lineStr, ']');
        
        if($openBracketIndex !== false && $closeBracketIndex !== false && $closeBracketIndex > $openBracketIndex) // both indices MUST exit 
        {
          
          $topKeyStr = trim(substr($lineStr, $openBracketIndex + 1, $closeBracketIndex - $openBracketIndex - 1)); // ie. ExifTool, System, File, IFD0 
          
          $remainderStr = substr($lineStr, $closeBracketIndex + 1);
          
          // Of the remainder, find the first occurence of ':' and split on it...
          $colonPos = strpos($remainderStr, ':');
          if($colonPos !== false)
          {
            $leftOfColonStr = trim(substr($remainderStr, 0, $colonPos));
            $rightOfColonStr = trim(substr($remainderStr, $colonPos + 1)); 
            
            if(!isset($retArr[$topKeyStr])) // if 2nd-level array at that key isn't populated yet, start an array now
              $retArr[$topKeyStr] = Array();
            
            $retArr[$topKeyStr][$leftOfColonStr] = $rightOfColonStr; // pack into array 
          }
          else
          {
            error_log('ExifTool Parse Error: Colon Delimiter Position Wrong Line ' . $i);
            return false;
          }
        }
        else
        {
          error_log('ExifTool Parse Error: Wrong Bracket Indices Line ' . $i);
          return false;
        }
      }
      
      if(count($retArr) > 0)
      {
        return $retArr;
      }
      else 
      {
        error_log('ExifTool Parse Error: Empty Return Array');
        return false;
      }
    }
    else
    {
      error_log('ExifTool Parse Error: Open Brace Missing');
      return false;
    }
        
    error_log('ExifTool Parse Error: Generic');
    return false; // catch
  }
  
  // given possible dates present in file's exif, get one of theese in following precedence 
  function GetDateGivenExif($exifToolStr)
  {
    $arr = ParseExifToolOutput($exifToolStr);
    
    if(is_array($arr))
    {
      // JPG
      if(isset($arr['ExifIFD'])) 
      {
        if(isset($arr['ExifIFD']['Create Date']))
          return $arr['ExifIFD']['Create Date'];
        if(isset($arr['ExifIFD']['Date/Time Original']))
          return $arr['ExifIFD']['Date/Time Original'];
      }
      if(isset($arr['IFD0']))
      {
        if(isset($arr['IFD0']['Modify Date']))
          return $arr['IFD0']['Modify Date'];
      }
      if(isset($arr['Composite']))
      {
        if(isset($arr['Composite']['Create Date']))
          return $arr['Composite']['Create Date'];
        if(isset($arr['Composite']['Date/Time Original']))
          return $arr['Composite']['Date/Time Original'];
      }
      
      // M4V & MOV
      if(isset($arr['QuickTime'])) 
      {
        if(isset($arr['QuickTime']['Content Create Date']))
          return $arr['QuickTime']['Content Create Date'];
        if(isset($arr['QuickTime']['Creation Date']))
          return $arr['QuickTime']['Creation Date'];
        if(isset($arr['QuickTime']['Create Date']))
          return $arr['QuickTime']['Create Date'];
      }
      if(isset($arr['Track1'])) 
      {
        if(isset($arr['Track1']['Track Create Date']))
          return $arr['Track1']['Track Create Date'];
        if(isset($arr['Track1']['Media Create Date']))
          return $arr['Track1']['Media Create Date'];
      }
      if(isset($arr['Track2'])) 
      {
        if(isset($arr['Track2']['Track Create Date']))
          return $arr['Track2']['Track Create Date'];
        if(isset($arr['Track2']['Media Create Date']))
          return $arr['Track2']['Media Create Date'];
      }
      
      error_log('ExifTool Parse Error: No Appropriate Date/Time Key Could Be Found');
    }
    
    return false;
  }
  
  function CheckReturnedDateChars($inStr)
  {
    if(preg_match('/^[\d]+$/', $inStr))
      return true;
    
    return false; 
  }
  
  // public call-in point
  // when fed the output of ExifTool, find and return the Final date to be used as filename.
  function GetSanitizedDateFromExif($exifToolStr)
  {
    $rawDateStr = GetDateGivenExif($exifToolStr);
    
    // at this point expecting a format of ie. '2020:03:29 12:06:12'
    // some have sub-second resolution of form '2020:03:29 12:06:12.496'
    // m4v  'Content Create Date  : 2019:03:21 11:24:12-06:00'
    
    if(is_string($rawDateStr))
    {
      $arr = explode(' ', $rawDateStr);
      
      if(isset($arr[0]) && isset($arr[1]))
      {
        $dateStr = $arr[0];
        $timeStr = $arr[1];
        
        // remove colons from both.
        $dateStr = str_replace(':', '', $dateStr);
        $timeStr = str_replace(':', '', $timeStr);
        
        // for the time, search for a period off the right side and chop off if found.
        $dotPos = strrpos($timeStr, '.');
        if($dotPos !== false)
          $timeStr = substr($timeStr, 0, $dotPos);
        
        // m4v Content Create Date has timezone offset so... at this point just take the first 6 digits of the time...
        if(strlen($timeStr) > 6)
          $timeStr = substr($timeStr, 0, 6);
        
        if(CheckReturnedDateChars($dateStr) && CheckReturnedDateChars($timeStr))
          return $dateStr . '_' . $timeStr; // android image filename format 
        else
        {
          error_log('ExifTool Parse Error: Date/Time String Contained Illegal Characters');
          return false;
        }
      }
    }
    
    error_log('ExifTool Parse Error: Could Not Retrieve Sanitized Date/Time String');
    return false;
  }
  
  // public call-in 
  // success: the shell's raw output
  // fail: false
  function ExifShellExecWrapper($inFileStr)
  {
    $shellRetStr = shell_exec('exiftool -a -G1 ' . escapeshellarg($inFileStr));
    if(is_string($shellRetStr) && (strlen($shellRetStr) > 0))
      return $shellRetStr;
    
    return false;
  }
  