<?php

  // Objectification of a single folder's (/folderStr/) index files
  class FolderIndexNode
  {
    var $inceptionStr; // mod time of zeroth (and thusly all) index files to show when they were generated 
    
    var $theFolderStr; // formatted canonically as '/MyCol1/';
    
    var $zerothArr; // just the zeroth index
    var $indexesArr; // an array of arrays; each sub-array just being loaded via file()
    
    var $invertedIndexArr; // 'filename.jpg' => 'pagenumber_ithImageNumber';
    
    var $subFolderArr; // if this folder has any subfolders load them in here 
    
    var $bLoaded;
    
    function __construct($folderStrCandidate) // must be of form '/MyCol1/subfolder/'
    {
      $this->bLoaded = false;
      $this->zerothArr = false;
      $this->indexesArr = false;
      $this->invertedIndexArr = false;
      $this->subFolderArr = false; // this can remain <false> after loading to signify that there arent' any subfolders for where we are currently
      
      $bWasSanitized = IH_SanitizeBaseArg($folderStrCandidate);
      if(!$bWasSanitized) // if the input was good without any modification
      {
        $this->theFolderStr = $folderStrCandidate;
        $this->LoadZerothIndexArray();
        $this->LoadIndexesArray();
        $this->LoadSubFolders();
        
        $this->bLoaded = true;
      }
    }
    
    function __destruct()
    {
    }
    
    function LoadZerothIndexArray()
    {
      $indexArr = GetIndexIthFileAsArr($this->theFolderStr, 'A', 0);
      if(is_array($indexArr))
      {
        $this->zerothArr['imgsperpage'] = $indexArr[0];
        $this->zerothArr['totalnumimages'] = $indexArr[1];
        $this->zerothArr['totalnumpages'] = $indexArr[2];
        $this->zerothArr['statetag'] = $indexArr[3];
        $this->zerothArr['sizemb'] = $indexArr[4];
      }
      else
        error_log("Couldn't Load Zeroth Index File");
    }
    
    function LoadIndexesArray()
    {
      $masterCounter = 1; // ith image in the entire folder
      for($i = 0; $i < $this->zerothArr['totalnumpages']; $i++)
      {
        $arr = GetIndexIthFileAsArr($this->theFolderStr, 'A', ($i + 1));
        if(is_array($arr))
        {
          $this->indexesArr[] = $arr;
          
          foreach($arr as $filename)
          {
            $this->invertedIndexArr[$filename] = strval($i + 1) . '_' . strval($masterCounter); // page numbers are 1-indexed
            $masterCounter++;
          }
        }
        else
          error_log("Could Not Load ".($i + 1)." Index File.");
      }
    }
    
    function LoadSubFolders()
    {
      if(HasSubFolders($this->theFolderStr))
      {
        $folderIndexFilename = IH_MetaCollectionsIndexRoot() . $this->theFolderStr . '.folders';
        if(file_exists($folderIndexFilename) && (filesize($folderIndexFilename) > 0) )
        {
          $arr = file($folderIndexFilename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
          if($arr !== FALSE && is_array($arr) && count($arr) > 0 )
          {
            foreach($arr as $item)
            {
              $this->subFolderArr[] = $item;
            }
          }
        }
      }
    }
    
    function PageOutStructure() // only for debugging (CALLING 2 OF THEESE IN SUCCESSION FAILS DUE TO HEADERS THINGY, ugh no easy way)
    {
      if(!headers_sent())
      {
        header('Content-Type:text/plain'); // if we just use pre, then '&#44' gets messed-up
        
        echo("FolderIndexNode : " . $this->theFolderStr . "\r\n");
        
        echo("->Zeroth Array\r\n");
        print_r($this->zerothArr);
        
        echo("->Indexes Array\r\n");
        print_r($this->indexesArr);
        
        echo("->Inverted Index Array\r\n");
        print_r($this->invertedIndexArr);
        
        if($this->subFolderArr !== false)
        {
          echo("->SubFolders Array\r\n");
          print_r($this->subFolderArr);
        }
      }
      else
        return false;
    }
    
    function ReturnIthIndexGivenFilename($filenameStr) // singleview index
    {
      if(!isset($this->invertedIndexArr[$filenameStr]))
        return false;
      return explode('_', $this->invertedIndexArr[$filenameStr])[1];
    }
    
    function ReturnIndexPageGivenFilename($filenameStr) // grid index
    {
      if(!isset($this->invertedIndexArr[$filenameStr]))
        return false;
      return explode('_', $this->invertedIndexArr[$filenameStr])[0];
    }
    
    function ReturnIthFilenameGivenIndex($imageNumber)
    {
      $imageNumber = $imageNumber - 1; // everythings zero-indexed in the array world 
      
      $perPage = $this->zerothArr['imgsperpage'];
      
      $indexIntoIndexesArr = intval($imageNumber / $perPage);
      $remainder = ($imageNumber % $perPage);
      
      return $this->indexesArr[$indexIntoIndexesArr][$remainder]; 
    }
  }
