<?php

  // returns markup displaying which tools are unavailable on the current system; to be echoed via die()
  // or true if all progs found 
  function ThirdPartyToolsCheck()
  {
    $progArr = Array // the keys of this need to be present on system 
    (
      'zip' => 'ZIP',
      'convert' => 'ImageMagick',
      'identify' => 'ImageMagick',
      'ffmpeg' => 'FFMpeg',
      'exiftool' => 'libimage-exiftool-perl'
    );
    
    $bMissed = false;
    $retMarkupStr = "<!DOCTYPE html>\r\n<body>\r\n<table>\r\n";
    $retMarkupStr .= "<tr><td><b>Command</b></td><td><b>Library/Package</b></td><td><b>Status</b></td></tr>\r\n";
    
    foreach($progArr as $keyStr => $valStr)
    {
      $retMarkupStr .= "<tr><td>".$keyStr."</td><td>".$valStr."</td>";

      if(IH_CommandExists($keyStr))
      {
        $retMarkupStr .= "<td>Found</td></tr>\r\n";
      }
      else
      {
        $retMarkupStr .= "<td><i>Missing</i></td></tr>\r\n";
        $bMissed = true;
      }
    }
    $retMarkupStr .= "</table>\r\n";   
    $retMarkupStr .= "<h4><i>Please install the packages listed as missing above, and reload this page.</i></h4>\r\n";
    $retMarkupStr .= "</body>\r\n</html>\r\n";
    
    
    if($bMissed)
      return $retMarkupStr;
    
    return true;
  }

  function GetRandStr($len = 24, $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789')
  {
    $retStr = '';
    for ($i = 0; $i < $len; $i++) 
      $retStr .= $characters[rand(0, strlen($characters) - 1)];

    return $retStr;
  }

  // Attempt to Create a folder in cwd, based off of the stub plus random tail
  function AttemptFolder($stubStr, $bRandTail)
  {
    $perms = 0755; // Everything for owner, read for group and others
    
    $attemptStr = $stubStr;
    
    if($bRandTail)
      $attemptStr .= GetRandStr();
    
    if(mkdir($attemptStr , $perms))
      return $attemptStr;
    
    return false;
  }

  // Main Entry Point 
  function ExecSetup()
  {
    // third party libraries/commands check 
    if((($prgzMarkup = ThirdPartyToolsCheck()) !== true) && is_string($prgzMarkup))
      die($prgzMarkup);
    
    $finalDataStr = '';
    $finalMetaStr = '';    
    
    if(!file_exists(IH_Data())) // Generate/Create Data Dir
    {
      if((($finalDataStr = AttemptFolder('Data-', true)) !== false) && 
         (AttemptFolder($finalDataStr . DIRECTORY_SEPARATOR . 'Files', false) !== false)
      )
      {
        // created all Data Dirs 
      }
      else
      {
        die("Could Not Create Data Directory Or One Of Its Subdirectories");
      }     
    }
    
    if(!file_exists(IH_Meta())) // Generate/Create Meta Dir
    {
      if((($finalMetaStr = AttemptFolder('Meta-', true)) !== false) && 
        (AttemptFolder($finalMetaStr . DIRECTORY_SEPARATOR . 'Access', false) !== false)&& 
        (AttemptFolder($finalMetaStr . DIRECTORY_SEPARATOR . 'Cmt', false)    !== false)&& 
        (AttemptFolder($finalMetaStr . DIRECTORY_SEPARATOR . 'Files', false)  !== false)&& 
        (AttemptFolder($finalMetaStr . DIRECTORY_SEPARATOR . 'Index', false)  !== false)&& 
        (AttemptFolder($finalMetaStr . DIRECTORY_SEPARATOR . 'TEMP', false)   !== false)
      )
      {
        // created all Meta Dirs 
      }
      else
      {
        die("Could Not Create Meta Directory Or One Of Its Subdirectories");
      }
    }

    // REWRITE CONFIG HERE!
    if(!ConfigWriter('Config-Dirs.php','Config-Dirs.php', $finalDataStr, $finalMetaStr, ('IMGHUB' . GetRandStr(4, '123456789'))))
      die("Could not Write to Config-Dirs.php");
    
    // MANUALLY Create a single user 'admin'-'admin' because IH_CreateUser() wasn't purely functional... :/ 
    $salt = GetRandTail(16); // new salt
    if(file_put_contents($finalMetaStr . DIRECTORY_SEPARATOR . PASSWORD_FILENAME,
    ('admin' . ' ' . IH_ApplyCrypt('admin', $salt) . ' ' . IH_GetTimestamp() . ' ' . $salt), FILE_APPEND | LOCK_EX) === false)
      die("Could Not Create Admin User");
    
    // OP CACHE TIME 
    if(!opcache_reset())
      die("Could Not Flush the OP Cache");    
    
    $setupMsgStr = "Image Hub Setup Completed Successfully! User 'admin' - 'admin' Created!";
    IH_RawRedirMessageHalt(".?fol=", $setupMsgStr);
  }
  
  // rewrites the config with new lines changed...
  function ConfigWriter($sourceFilePath, $outputFilePath, $newDataPathStr, $newMetaPathStr, $newInstStr)
  {
    $tempOutputFile = $outputFilePath . '.tmp';

    // clear it if its somehow already there
    if(file_exists($tempOutputFile))
      if(!unlink($tempOutputFile)) 
        return false;

    $handleRead = fopen($sourceFilePath, 'r'); // from this
    $handleWrite = fopen($tempOutputFile, 'w'); // to this (temp)
    if($handleRead && $handleWrite)
    {
      while (($lineStr = fgets($handleRead)) !== false)
      {
        // loops once per line from input
        $writeMe = '';

        if((strpos($lineStr,      'const DATA_CACHE_FOLDER') !== false) && (strlen($newDataPathStr) > 0) )
          $writeMe =             '  const DATA_CACHE_FOLDER = \'' . $newDataPathStr . '\';' . "\r\n"; 
        else if((strpos($lineStr, 'const META_CACHE_FOLDER') !== false) && (strlen($newMetaPathStr) > 0) )
          $writeMe =             '  const META_CACHE_FOLDER = \'' . $newMetaPathStr . '\';'  . "\r\n";
        else if((strpos($lineStr, 'const IH_INST_NAME') !== false) && (strlen($newInstStr) > 0) )
          $writeMe =             '  const IH_INST_NAME = \'' . $newInstStr . '\';' . "\r\n";
        else
          $writeMe = $lineStr; // write the line verbatim 

        fwrite($handleWrite, $writeMe);      
      }
      fclose($handleRead);
      fclose($handleWrite);
      
      if(rename($tempOutputFile, $outputFilePath)) // If renaming a file and targetname exists, it will be overwritten.
        if(chmod($outputFilePath, 0755))
          return true;
        
    }
    return false;
  }
