<?php
//CLI-only worker wrapper for calling asynchronous jobs, ie. Generating batches of .IHARs 

  include 'GenFns.php';
  include 'ModFns.php';
  include 'ExifFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');

  if(php_sapi_name() == 'cli')
  {
    
    if( (ini_set("log_errors", 1) !== false) && 
        (ini_set("error_log", IH_Meta() . DIRECTORY_SEPARATOR . "php-cli-errors.log") !== false) )
    {
      
      if(isset($argc) && isset($argv))
      {
        // Arg1: opertioin to be performed, ie. 'gen-ihars'
        if(isset($argv[1]) && is_string($argv[1]) && strlen($argv[1]) > 0)
        {
          $op = $argv[1];
          
          if(strcasecmp($op, 'gen-ihars') === 0)
          {
            if(isset($argv[2]) && is_string($argv[2]) && strlen($argv[2]) > 0)
            {
              // Arg2: name of temp file (not path) containing a list of files we want to generate for.
              $inFileList = $argv[2]; 
              
              //get array from temp file
              $theFilePath = IH_MetaTEMPRoot() . DIRECTORY_SEPARATOR . $inFileList;
              if(is_file($theFilePath))
              {
                $inFileListArr = file($theFilePath , FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
                
                if(is_array($inFileListArr))
                {
                  unlink($theFilePath);
                
                  foreach($inFileListArr as $row)
                    IH_CreateIHAR($row, false);
                }
                else
                  error_log("Error: IHAR input file could not be read! " . $inFileList);
              }
              else
                error_log("Error: specified temp file did not exist! " . $inFileList);       
            }
            else
              error_log('Error: (gen-ihars) temp file argument not currectly supplied.');
          }
          else
            error_log('Error: unknown operation supplied.');
        }
        else
          error_log('Error: operation argument not correctly supplied.');
      }
      else
        error_log('Error: argc/argv not set.');
    }
    /* 
    else
      touch("HELP-ERRORS-NOT-WORKING.txt"); 
    */
  }
  else
    echo ('NA');
  