<?php

  // Called to copy/move files from users clipboard to final destination ("fol" argument)
  // slightly different flow from folderedit, with session variable updates and all...

  include 'GenFns.php';
  include 'ModFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');
  
  $usernameStrGlobal = '';
  $modTokenStrGlobal = '';
  $operationStr = ''; 
  $clpbrdListArr = array();
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
  {
    $usernameStrGlobal = IH_GetUserName(); 
    $modTokenStrGlobal = $_SESSION[IH_GetInstanceName().'-modtoken'];
    
    if(strlen($_SESSION[IH_GetInstanceName().'-Clipboard']) > 0)
      $clpbrdListArr = explode(CLPBRD_DELIMITER , $_SESSION[IH_GetInstanceName().'-Clipboard'] );

  }
  else 
    IH_RedirMessageHalt('/', "Not Authorized for this operation." , false);
    
  //IH_SessionClose();// no session close, we need to possibly edit the clipboard afterwards 
  
  $passedToken = '';
  if($_POST && isset($_POST['jrr']) && is_string($_POST['jrr']))
    $passedToken = $_POST['jrr'];
  
  // Validate Token "Credentials"
  if((strlen($passedToken) === 0) || (strlen($modTokenStrGlobal) === 0) || !hash_equals($modTokenStrGlobal, $passedToken))
    IH_RedirMessageHalt('/', "Invalid Credentials (folderedit.php)" , false);  // bail 
    
  $folderStrGlobal = '';   
  $collectionStrGlobal = ''; 
  $opStrGlobal = '';
  
  if($_POST && isset($_POST['fol']) && is_string($_POST['fol']))
      $folderStrGlobal = $_POST['fol'];
    
  // Validate Folder String
  $bWasSanitized = IH_SanitizeBaseArg($folderStrGlobal);

  if( !$bWasSanitized && (strcmp($folderStrGlobal, '') !==0) && (strcmp($folderStrGlobal, '/') !==0) ) 
  {
    $collectionStrGlobal = IH_GetCollectionNameFromFolderStr($folderStrGlobal); // get col 
    
    if(IH_CanUserModCollection($collectionStrGlobal, $usernameStrGlobal))
    {
      if(count($clpbrdListArr) > 0) // if clipboard isn't empty
      {
        $opStrGlobal = '';
        
        if($_POST && isset($_POST['op']) && is_string($_POST['op']))
          $opStrGlobal = $_POST['op'];
        
        if(strcmp($opStrGlobal,'copy') !== 0 && strcmp($opStrGlobal,'move') !== 0 )
          IH_RedirMessageHalt( $folderStrGlobal, "Error: Invalid op arg." , false); 
        
        $bCopy = true;
        if(strcmp($opStrGlobal,'move') === 0)
          $bCopy = false;
        
        
        $inputDirListArr = array(); // list of canonical folderStr paths, which need to be re-indexed (without building IHARs) after doing a MOVE...
        
        $outputFileListArr = array(); // output file(s) which are passed to the IHAR maker  
        
        $arr1 = array(); // temp
        foreach($clpbrdListArr as $entry) 
        {
          $trimmed = trim($entry);
          if(!in_array($trimmed, $arr1)) // clean duplicates
            $arr1[] = $trimmed; 
          
          $dirName = (dirname($trimmed) . '/'); // put the slash back on to make it in the format of a folderStr
          if(!$bCopy) // moving, then we need list of "from" dirs to re-index later... 
          {
            if(!in_array($dirName, $inputDirListArr))
              $inputDirListArr[] = $dirName;

            if(!IH_CanUserModCollection(IH_GetCollectionNameFromFolderStr($dirName), $usernameStrGlobal))
              IH_RedirMessageHalt( $folderStrGlobal, "Error: User cannot modify all input directories for this Move operation." , false); 
          }
          else // if copying, check input dirs read perms
          {
            if(!IH_CanUserReadCollection(IH_GetCollectionNameFromFolderStr($dirName), $usernameStrGlobal))
              IH_RedirMessageHalt( $folderStrGlobal, "Error: User cannot read all input directories for this Copy operation." , false);
          }         
        }
        $clpbrdListArr = $arr1; // $clpbrdListArr is deduplicated 
        
        $dataStub = IH_DataCollectionsRoot();
        
        // HEART
        foreach($clpbrdListArr as $entry) 
        {
          $realSource = $dataStub . $entry; // ie. "Data/Files" . "/MyCol1/abc123.jpg"
          $realSourceBase = basename($entry); // ie. "abc123.jpg" 
          
          // ensure the target path doesnt exist, if it does, adjust the finalfilename(which also includes the extension)             
          $finalFilename = IH_NameAdjuster2($folderStrGlobal, $realSourceBase);
          
          $realTarg = $dataStub . $folderStrGlobal . $finalFilename ;
          
          copy($realSource, $realTarg);
          
          // TODO: Heres where we need to copy the comments if some exist. 
          
          
          if(file_exists($realTarg))
          {
            $outputFileListArr[] = $folderStrGlobal . $finalFilename; // if theres something in the target at this point, add it to the list thats passed to the IHAR maker routine. 
          
            if(!$bCopy) // Moving
              IH_DeleteFile($entry);
          }
        }
        
        if(!$bCopy) // moving 
        {
          foreach($inputDirListArr as $entry)
          {
            IH_InitializeFolder($entry, false);
          }
        }
        
        IH_InitializeFolder($folderStrGlobal, false); // rebuild the targ (obviously)
        
        IH_InitiateIHARMaker($outputFileListArr);
        
        if(!$bCopy) // if you're moving, clear the clipboard 
          $_SESSION[IH_GetInstanceName().'-Clipboard'] = ''; // clear clipboard
        
        if($bCopy)
          IH_RedirMessageHalt( $folderStrGlobal, "Completed the Copy operation. (" . count($outputFileListArr) . ") Files" , false);
        else
          IH_RedirMessageHalt( $folderStrGlobal, "Completed the Move operation. (" . count($outputFileListArr) . ") Files" , false);
      }
      else
        IH_RedirMessageHalt( $folderStrGlobal, "Error: Your clipboard is currently empty." , false);       
    }
    else
      IH_RedirMessageHalt( $folderStrGlobal, "Error: User permissions on target folder are insufficient." , false); 
  }
  else
    IH_RedirMessageHalt('/', "Error: Invalid input arguments." , false); 
    
  
  
  ?>