<?php

  // POST handler

  include 'GenFns.php';
  include 'ModFns.php';
  include 'ExifFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');
  
  $usernameStrGlobal = '';
  $modTokenStrGlobal = '';
  $operationStr = ''; 
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
  {
    $usernameStrGlobal = IH_GetUserName(); 
    $modTokenStrGlobal = $_SESSION[IH_GetInstanceName().'-modtoken'];
  }
  IH_SessionClose();// No Session-dependant calls after here
  
  $passedToken = '';
  if($_POST && isset($_POST['jrr']) && is_string($_POST['jrr']))
    $passedToken = $_POST['jrr'];
  
  // Validate Token "Credentials"
  if((strlen($passedToken) === 0) || (strlen($modTokenStrGlobal) === 0) || !hash_equals($modTokenStrGlobal, $passedToken))
    IH_RedirMessageHalt('/', "Invalid Credentials (folderedit.php)" , false);  // bail 
    
  $folderStrGlobal = '';   
  $collectionStrGlobal = ''; 
  
  if($_POST && isset($_POST['op']) && is_string($_POST['op']) && (strcmp($_POST['op'], 'newcol') === 0) ) // Create New Collection 
  {
    if(strcmp($usernameStrGlobal, '') !== 0)     // Make sure logged in...
    {
      if(isset($_POST['newcolname']) && is_string($_POST['newcolname']) && IH_IsValidFilename($_POST['newcolname'])) // valid new col name check 
      {
        $newColNameGlobal = $_POST['newcolname'];
        if(!file_exists(IH_DataCollectionsRoot() . '/' . $newColNameGlobal)) // if its already there!
        {
          mkdir ( IH_DataCollectionsRoot() . '/' . $newColNameGlobal );
          if(file_exists(IH_DataCollectionsRoot() . '/' . $newColNameGlobal)) // its there 
          {
            $initResults = IH_InitializeCollection($newColNameGlobal, $usernameStrGlobal);
            IH_RedirMessageHalt( '/' . $newColNameGlobal . '/', "(" . $newColNameGlobal . ") Initialization Complete " . $initResults , false);  
          }
          else
            IH_RawRedirMessageHalt('.?op=newcol', "Could not create the new collection's data folder. Aborting.");
        }
        else
          IH_RawRedirMessageHalt('.?op=newcol', "A collection with this name already exists! " . $newColNameGlobal);
      }
      else
        IH_RawRedirMessageHalt('.?op=newcol', "The supplied name for the new collection is empty, or contains illegal characters.");
    }
    else
      IH_RawRedirMessageHalt('.', "Invalid Credentials (folderedit.php)");
  }
  else // we're doing an op which requires a $folderStrGlobal AND $collectionStrGlobal to work on ...
  {
    if($_POST && isset($_POST['fol']) && is_string($_POST['fol']))
      $folderStrGlobal = $_POST['fol'];
    
    // Validate Folder String
    $bWasSanitized = IH_SanitizeBaseArg($folderStrGlobal);

    if($_POST && isset($_POST['op']) && is_string($_POST['op']) && (strcmp($_POST['op'], 'scanfolder') === 0))  // scan files found under the Data Dir + folderstrglobal and ensure that they conform to valid naming standards
    {
      if(strcmp($usernameStrGlobal, 'admin') === 0) // admin ONLY
      {
        // folderStrGlobal could be '/' , '/MyCol1/', '/MyCol2/subfolder/' as it is sanitizied 
        
        $actualStartingPath = IH_DataCollectionsRoot() . $folderStrGlobal; // ie. 'Data/Files/MyCol1/'
        $actualStartingPath = rtrim($actualStartingPath, DIRECTORY_SEPARATOR); // removes trailing slashes that are by-design part of the folderStr
        // ie. 'Data/Files/MyCol1' or abs path '/Files/Something/Files/MyCol1'
        
        echo("<pre>\r\n");
        echo("Running Valid Names Scan on : " . $folderStrGlobal . "\r\n\r\n");
        IH_TraverseFilenames($actualStartingPath, 'IH_SafeName');
        echo("</pre>");
      }
      else
        IH_RedirMessageHalt('/', "Cannot Authenticate" , false);
    }
    else
    if( !$bWasSanitized && (strcmp($folderStrGlobal, '') !==0) && (strcmp($folderStrGlobal, '/') !==0) ) // if we aren't supplied a correct argument, we cannot put it into the fallback location
    {
      $collectionStrGlobal = IH_GetCollectionNameFromFolderStr($folderStrGlobal); // get col 
      
      if(IH_CanUserModCollection($collectionStrGlobal, $usernameStrGlobal))
      {
        if($_POST && isset($_POST['op']) && is_string($_POST['op'])) // action slector for this folder
        {
          if(strcmp($_POST['op'], 'init') === 0) // initialization for "dragged" folders to Data. INIT ALWAYS TAKES THE COLLECTION and recursively indexes everything, page will block... 
          {
            if($usernameStrGlobal == 'admin') // only admin can do an init TODO: create an isOwner() to allow owners to init sub folders. 
            {
              $initResults = IH_InitializeCollection($collectionStrGlobal, 'admin');
              IH_RedirMessageHalt( '/' . $collectionStrGlobal . '/', "(" . $collectionStrGlobal . ") Initialization Complete " . $initResults , false);  
            }
          }
          else if(strcmp($_POST['op'], 'exifrename') === 0)  // EXIF Rename; attempt to rename all files in this folder to thier embedded exif dates if available.
          {
            $bVerboseErrors = false; // switch for debugging
            
            error_log('(exifrename) Notice: Starting folder: ' . $folderStrGlobal);
            
            // initialize stuff at outer level
            $cmtCntStr = '';
            $filesToMakeNewIHARsForArr = Array();
            $filesWhoseIHARsNeedDeletion = Array();
            
            $commentCounter = 0; // just count which ones had comments successfully moved, for sanity
            
            // get an actual list of files on disk which are in specified folder
            $actualStubPathStr = IH_DataCollectionsRoot() . $folderStrGlobal . '*' ;
            $filesArr = glob($actualStubPathStr);
            foreach($filesArr as $filePath)
            {
              if(!is_file($filePath)) // skip non-files
                continue;
              
              if(($shellRet = ExifShellExecWrapper($filePath)) !== false)
              {
                if(($dateStr = GetSanitizedDateFromExif($shellRet)) !== false)
                {
                  $myPathinfo = pathinfo($filePath); // INPUT-> '/blah/myfile.jpg'
                  $oldDirname =  $myPathinfo['dirname']; // '/blah'
                  $oldBasename = $myPathinfo['basename']; // 'myfile.jpg'
                  $oldFilename = $myPathinfo['filename']; // 'myfile'
                  $newFilename = $dateStr; // 20200101_123000 (12:30 PM January 01, 2020)
                  $oldExtension= strtolower($myPathinfo['extension']); // 'jpg'
                  
                  $lenOld = mb_strlen($oldFilename);
                  $lenNew = mb_strlen($newFilename);
                  
                  if( // cases where we want to go forward with the renaming process 
                    ($lenOld < $lenNew) || 
                    (strcmp(mb_substr($oldFilename, 0, $lenNew), $newFilename) !== 0)
                  )
                  {
                  
                    // actual FINAL path on disk where renamed file will reside 
                    $finalRenamedPath = $oldDirname . DIRECTORY_SEPARATOR . $newFilename . '.' . $oldExtension;
                      
                    // Check Here in case final renamed path is SOMEHOW already populated :/
                    if(file_exists($finalRenamedPath))
                    {
                      if($bVerboseErrors)
                        error_log('(exifrename) Warning: final path ' . $finalRenamedPath . ' already exists!');
                      
                      // adjust the name 
                      $newFilename = IH_NameAdjuster( 
                        ($oldDirname . DIRECTORY_SEPARATOR), 
                        $newFilename, 
                        ('.' . $oldExtension)
                      );
                      
                      error_log('(exifrename) Notice: final name adjusted to ' . $newFilename . '.' . $oldExtension);
                      
                      // re-assign the actual filename again :/
                      $finalRenamedPath = $oldDirname . DIRECTORY_SEPARATOR . $newFilename . '.' . $oldExtension;
                    }
                      
                    if(rename($filePath ,$finalRenamedPath))
                    {
                      // if the file now resides at the new name, delete old IHAR and add the new name to filesToMakeNewIHARsForArr
                      if(is_file($finalRenamedPath) && !is_file($filePath))
                      {
                        if($bVerboseErrors)
                          error_log('(exifrename) Notice: File ('.$oldFilename.$oldExtension.') has moved successfully');
                        
                        // path to old one's IHAR
                        $pathToOldIHAR = IH_MetaCollectionsRoot() . $folderStrGlobal . $oldBasename . '.IHAR' ;
                        
                        if(is_file($pathToOldIHAR))
                          $filesWhoseIHARsNeedDeletion[] = $pathToOldIHAR;
                        
                        // Rename Comment 'folder' 
                        if(IH_RenameComment($folderStrGlobal, $oldBasename, $newFilename . '.' . $oldExtension))
                          $commentCounter++;
                        
                        $filesToMakeNewIHARsForArr[] = 
                          $folderStrGlobal . $newFilename . '.' . $oldExtension; // load with Canonical Path of NEW file
                      }
                    }
                  }
                }
              }
            } // foreach
            
            if(count($filesToMakeNewIHARsForArr) > 0) // if we actually have any which had thier name changed 
            {
              // assess counted comments...
              if($commentCounter > 0)
                $cmtCntStr = ' (' . $commentCounter . ') Comment(s).';
              
              IH_InitializeFolder($folderStrGlobal, false); // locks the folder while rebuilding index (which is what pagination reads off of)
              
              IH_InitiateIHARMaker($filesToMakeNewIHARsForArr); // async
              
              // dont remove the old IHARs until now, when the new index is made, since if someone is intermittently browsing it'll have
              // empty thumbs and thus a lesser experience.
              foreach($filesWhoseIHARsNeedDeletion as $oldIHAR)
                if(file_exists($oldIHAR))
                  unlink($oldIHAR);
                else
                  error_log('(exifrename) Warning: Tried Deleting ' . $oldIHAR . ' but file was not found.');
            }
            
            error_log('(exifrename) Notice: Ended ' . count($filesToMakeNewIHARsForArr) . ' file(s) renamed from EXIF data.' . $cmtCntStr);
            
            IH_RedirMessageHalt($folderStrGlobal, count($filesToMakeNewIHARsForArr) . ' file(s) renamed from EXIF data.' . $cmtCntStr, false);
          }
          else if(strcmp($_POST['op'], 'makefolder') === 0)  // Crate Subfolder 
          {
            if(isset($_POST['newfolder']) && is_string($_POST['newfolder']) && strlen($_POST['newfolder']) > 0) // the name of the new folder 
            {
              if(IH_IsValidFilename($_POST['newfolder']))
              {
                $newFolderName = $_POST['newfolder'] ;
                
                //folders to make, data, meta-access, meta-index, meta-files, etc. 
                if(!file_exists(IH_DataCollectionsRoot() . $folderStrGlobal . $newFolderName))
                {
                  mkdir (IH_DataCollectionsRoot() . $folderStrGlobal . $newFolderName);
                  
                  IH_InitializeFolder($folderStrGlobal, false);
                  IH_InitializeFolder($folderStrGlobal . $newFolderName . '/' , false);
                  
                  IH_RedirMessageHalt($folderStrGlobal . $newFolderName . '/', "(" . $newFolderName . ") Folder Added ", false);
                }
                else
                  IH_RedirMessageHalt( $folderStrGlobal, "(" . ($_POST['newfolder']) . ") already exists! " , false);
              }
              else
                IH_RedirMessageHalt( $folderStrGlobal, "(" . ($_POST['newfolder']) . ") Invalid Folder Name " , false);
            }
            else
              IH_RedirMessageHalt( $folderStrGlobal, "Invalid input." , false);
          }
          else if(strcmp($_POST['op'], 'perms') === 0)  // Set Permissions
          {
            $newOwner = '';
            $newAccess = '';
            $newMembers = '';
            if(isset($_POST['owner']) && is_string($_POST['owner']))
              $newOwner = $_POST['owner'];
            if(isset($_POST['access']) && is_string($_POST['access']))
              $newAccess = $_POST['access'];
            if(isset($_POST['members']) && is_string($_POST['members']))
              $newMembers = $_POST['members'];
            
            // Validate Owner and Access 
            if( IH_IsValidUsername($newOwner) && 
                $newAccess >= 0 && $newAccess <=3 )
            {
              $newMembersLowerArr = array(); // lowercase array of whats passed-in 
              
              //Check members list...
              if(strlen($newMembers) > 0)
              {
                $newMembers = str_replace(' ', '', $newMembers); // remove spaces 
                $newMembersArr = explode(',', $newMembers);
                foreach($newMembersArr as $name)
                {
                  if(!IH_IsValidUsername($name)) 
                    IH_RawRedirMessageHalt( ".?fol=" . rawurlencode($folderStrGlobal) . "&op=folderedit", "ERROR: Members List Argument Invalid!");
                  else
                    $newMembersLowerArr[] = strtolower($name);
                }
              }
              
              $newOwner = strtolower($newOwner); // make owner lowercase
              
              // Update Access File... 
              $accessFilePath = IH_MetaCollectionsAccessRoot() . '/' . $collectionStrGlobal . '/.access' ;
              unlink($accessFilePath);
              touch ($accessFilePath);
              $fp = fopen( $accessFilePath , 'w');
              if($fp)
              {
                fwrite($fp, $newOwner . "\r\n");   //owner
                fwrite($fp, $newAccess . "\r\n");  //access
                fwrite($fp, implode(',', $newMembersLowerArr) . "\r\n"); //members list
                fclose($fp);
              }
              IH_RawRedirMessageHalt( ".?fol=" . rawurlencode($folderStrGlobal) . "&op=folderedit", "Permissions Changed Successfully!");
            }
            else
              IH_RawRedirMessageHalt( ".?fol=" . rawurlencode($folderStrGlobal) . "&op=folderedit", "ERROR: Permission Arguments Incorrect!");       
          }
          else if(strcmp($_POST['op'], 'reallydelitem') === 0)  // Confirmed Deletion of specified folder/file, and all content/children.
          {
            // check if we have file set and if so delete a file...
            if(isset($_POST['file']) && is_string($_POST['file']) && (strlen($_POST['file'])>0))
            {
              if(IH_IsValidFilename($_POST['file']))
              {
                $fileStr = $_POST['file'];
                
                $pathtoIHAR   = IH_MetaCollectionsRoot() . $folderStrGlobal . $fileStr . '.IHAR' ;
                $dataFilePath = IH_DataCollectionsRoot() . $folderStrGlobal . $fileStr ;
                
                if(is_file($dataFilePath))
                {
                  if(is_file($pathtoIHAR))
                    unlink($pathtoIHAR);
                  
                  IH_DeleteComments($folderStrGlobal, $fileStr);
                  
                  // TODO: Re-implement using pre-existing delete Item function in IH_DeleteFile() from ModFns 
                  
                  unlink($dataFilePath);
                  
                  if(!file_exists($dataFilePath))
                  {
                    // Reindex the current folder since its now down a file.
                    if( ($fp = IH_GetFolderLock($folderStrGlobal)) !== false)
                    {
                      IH_Create_Index_Files($folderStrGlobal, IMGS_PER_PAGE);
                      IH_ReleaseFolderLock($fp);
                    }
                    else
                    {
                      echo("ERROR: could not get lock! (reallydelitem (file)) " . $collectionStrGlobal);
                      die();
                    }
                    
                    IH_RedirMessageHalt($folderStrGlobal, "Deleted File: " . trim($folderStrGlobal . $fileStr) , false);
                  }
                  else
                  {
                    IH_RedirMessageHalt($folderStrGlobal, "ERROR: Couldn't Delete File: " . trim($folderStrGlobal . $fileStr) , false);
                  }
                }
                else
                  error_log("Error: Data file Not found for deletion!");
              }
            }
            else // folder delete 
            {
              $metaDirsArr = IH_FolderMetaDirsArr($folderStrGlobal);
              $dataDirPath = IH_DataCollectionsRoot() . $folderStrGlobal;    
              
              // DELETES
              foreach($metaDirsArr as $entry)
                shell_exec("rm -rf " . escapeshellarg( $entry )  );
                
              shell_exec("rm -rf " . escapeshellarg( $dataDirPath )  );
              
              // rebuild the parent's folder index to remove this entry from it, if we're not in the root of the collection
              if( count( $pathArr = explode('/', trim($folderStrGlobal, ' /')) ) > 1)
              {
                // accumulates all the paths in folderStr up to but not including the currently deleted one. 
                $folderToRefresh = '/';
                for($i = 0; $i < (count($pathArr)-1) ; $i++)
                {
                  $folderToRefresh .= $pathArr[$i] . '/';
                }
                // FIRST LOCK 'PARENT' FOLDER
                if( ($fp = IH_GetFolderLock($folderToRefresh)) !== false)
                {
                  IH_Create_Index_Files($folderToRefresh, IMGS_PER_PAGE);
                  
                  IH_ReleaseFolderLock($fp);
                }
                else
                {
                  echo("ERROR: could not get lock! (reallydelitem) " . $collectionStrGlobal);
                  die();
                } 
              }          
              IH_RedirMessageHalt('/', "Deleted Folder: " . $folderStrGlobal , false);
            }
          }
          else if(strcmp($_POST['op'], 'resetsamples') === 0)  // Reset Samples on the Homepage
          {
            if(GenerateNewHomeSampling($collectionStrGlobal))
              IH_RedirMessageHalt('/', "Reset Thumbnail Samples For : " . $collectionStrGlobal , false); // Put them Back on the Homepage
            else
              IH_RedirMessageHalt('/', "Could NOT Reset Thumbnail Samples For : " . $collectionStrGlobal , false); 
          }
          else if(strcmp($_POST['op'], 'resetsamplesdel') === 0)  // Clear Samples
          {
            if(GenerateNewHomeSampling($collectionStrGlobal, true))
              IH_RedirMessageHalt('/', "Cleared Random Thumbnail Samples For : " . $collectionStrGlobal , false); 
            else
              IH_RedirMessageHalt('/', "Could NOT Clear Random Thumbnail Samples For : " . $collectionStrGlobal , false); 
          }
          else if(strcmp($_POST['op'], 'reindex') === 0)  // Force Re-Indexing
          {
            //TODO: this reindex code is copied, fix that 
            $bDoThumbs = false;
            if(isset($_POST['tmbs']) && is_string($_POST['tmbs']))
              if(strcmp($_POST['tmbs'], '1') === 0)
                $bDoThumbs = true;
            
            //TODO: make this lock the folder, then IH_Create_Index_Files()
            $filesListArr = IH_InitializeFolder($folderStrGlobal, false);
            if($bDoThumbs && count($filesListArr) > 0 )
            {
              // if we're doing thumbs, take the opportunity to delte all .IHARs just to prune any strays.
              // the cli-worker will overwrite any ihar it knows to make, but if there is a stray it would otherwise not be pruned.
              shell_exec("rm -f " . escapeshellarg(IH_MetaCollectionsRoot() . $folderStrGlobal) . '*.IHAR'); // ie. 'Meta/Index' . '/MyCol1/' . '*.IHAR' 
              
              $randTail = '';
              $randPath = '';
              do
              {
                $randTail = GetRandTail(16);
                $randPath = IH_MetaTEMPRoot() . '/' . $randTail ;
              }while(file_exists($randPath));
              
              $fh = fopen( $randPath , 'w');
              if($fh)
              {
                foreach($filesListArr as $row)
                  fwrite($fh, $row . "\r\n");
                 
                fclose($fh);
              }           
              // call the cli-wrapper async
              $cmd = "php cli-worker.php" . " gen-ihars " . $randTail ;
              shell_exec($cmd . " > /dev/null 2> /dev/null & ");             
            }
            IH_RedirMessageHalt($folderStrGlobal, "Re-Indexed Folder: " . $folderStrGlobal , false);
          }
          else     
            IH_RedirMessageHalt('/', "Op Argument incorrect." , false);
        }
        else
          IH_RedirMessageHalt('/', "Op Argument unset." , false);
      }
      else
        IH_RedirMessageHalt('/', "The currently logged-in user cannot modify (" . $folderStrGlobal . ")" , false);
    }
    else
      IH_RedirMessageHalt('/', "Invalid Input Folder (" . $folderStrGlobal . ")" , false); 
  }    
