<?php

  include 'GenFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');
  
  function Echo_Placeholder($whichThumb, $bImg)
  {
    if($bImg)
    {
      $placeholderPath = 'GRAPHICS/placeholder128.png';
      if($whichThumb == 2)
        $placeholderPath = 'GRAPHICS/placeholder640.png';
    }
    else // special thumbs for non-images 
    {
      $placeholderPath = 'GRAPHICS/placeholder128file.png';
      if($whichThumb == 2)
        $placeholderPath = 'GRAPHICS/placeholder640file.png';
    }
    
    $sz_placeholder = filesize($placeholderPath);
    $fh = fopen($placeholderPath, "rb");
    header('Content-type: '.'image/png');
    header('Content-length: '. $sz_placeholder );
    echo fread($fh, $sz_placeholder );
    fclose($fh);
  }

  $usernameStrGlobal = '';
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
    $usernameStrGlobal = IH_GetUserName(); 
  IH_SessionClose();// No Session-dependant calls after here
  
  $fileStr = '';
  $folderStr = '';  // should be "at least" -> '/MyCol1/' 
  $collectionStr = ''; 
  
  if($_GET && isset($_GET['fol']) && is_string($_GET['fol']))
    $folderStr = $_GET['fol'];
    
  // Validate Folder String
  $bWasSanitized = IH_SanitizeBaseArg($folderStr);
  
  if($_GET && isset($_GET['file']) && is_string($_GET['file']))
    $fileStr = $_GET['file'];
  
  // Thumb Size Selector Variable
  $thumbVarStr = '';
  $thumbVar = 1;
  if($_GET && isset($_GET['var']) && is_string($_GET['var']))
    $thumbVarStr = $_GET['var'];
  if(strcmp($thumbVarStr, '2') === 0) 
    $thumbVar = 2;
  else 
  if(strcmp($thumbVarStr, '4') === 0) 
    $thumbVar = 4;
  
  // VAR DUMPS
  /* echo ("<br>fileString = " . $fileStr . "\r\n");
  echo ("<br>folderString = " . $folderStr . "\r\n");
  echo ("<br>thumbVarStr = " . $thumbVarStr . "\r\n");
  
  
  if(! IH_IsValidFilename($fileStr) )
    echo("<br>Filenamebad\r\n");

  if($bWasSanitized)
    echo("<br>WAS SANITIZED\r\n"); */
  
  if( !$bWasSanitized && IH_IsValidFilename($fileStr) )
  {
    $pathtoIHAR = IH_MetaCollectionsRoot() . $folderStr . $fileStr . '.IHAR' ;  // again, folderstr is at least '/MyCol/' shouldn't be just '/'
    
    if(file_exists($pathtoIHAR))
    {
      // so then its there and valid, now we just need to see if we're permitted access. 
      
      // get 'collection' part of the folder path
      $tokensArr = explode('/', trim($folderStr,'/'));
      $collectionStr = $tokensArr[0];
      if(strcmp($collectionStr, '') !== 0 ) // if we're in a collection
      {
        if(IH_CanUserReadCollection($collectionStr, $usernameStrGlobal))
        {
          
          // Remove potential headers which surpress "if-modified-since" lookups in newer browsers.
          header_remove('x-powered-by');
          header_remove('expires');
          header_remove('cache-control');
          header_remove('pragma');
          
          if ($thumbVar != 4) // not supported for videos 
          {
            // HTTP 304 response, IFF the IHAR hasn't changed, which is usually the case.
            if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) && 
              strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']) >= filemtime($pathtoIHAR) )
            {
              header('HTTP/1.0 304 Not Modified');
              exit(0); // normal termination 
            }
          }
          
          if(IH_OutputImage_IHAR($pathtoIHAR, $thumbVar) === false) // didnt find the thumb inside, and nothing was echoed
            Echo_Placeholder($thumbVar, false); // send (NON-IMG) placeholder
        }
      }      
    }  
    else
    {
      Echo_Placeholder($thumbVar, true);
      //echo("ERROR: Parameters are invalid.");
      exit(1);
    }
  }
  else
  {
    Echo_Placeholder($thumbVar, true);
    //echo("ERROR: Filename invalid.");
    exit(1);
  }  
?>