<?php

  include 'GenFns.php';
  include 'LayoutFns.php';

  // ===================================================================================================
  // MAIN ==============================================================================================
  
  if(!file_exists(IH_Data()) && !file_exists(IH_Meta())) // then we need to do a litte setting-up
  {
    include 'Setup.php'; // pull-in setup routines and execute them
    ExecSetup();
  }

  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');  

  $usernameStrGlobal = '';
  $modTokenStrGlobal = '';
  $bShowCmtDeleteGlobal = false;
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
  {
    $usernameStrGlobal = IH_GetUserName(); 
    $modTokenStrGlobal = $_SESSION[IH_GetInstanceName().'-modtoken'];
    
    if(strcmp( $_SESSION[IH_GetInstanceName().'-ShowCmtDelete'], 'true')===0)
      $bShowCmtDeleteGlobal = true;
  }
  IH_SessionClose();// No Session-dependant calls after here
  
  $folderStrGlobal = '/';  // defaults to safe "Welcome" screen 
  $collectionStrGlobal = ''; // defaults to not being in a collection, welcome page
  $fileStrGlobal = ''; // which file(safe filename) we're looking at, currently only for delitem 
  
  $pageValue = 1;
  if(isset($_GET['page']))
    $pageValue = IH_NormalizePageVar($_GET['page']); 
  
  // operation mode of page
  $operationStr = ''; 
  if($_GET && isset($_GET['op']))
    $operationStr = (is_string($_GET['op']) ? $_GET['op'] : '');  // assign
  // valid op check
  if(strcmp($operationStr, '') !== 0 && 
     strcmp($operationStr, 'singleview') !== 0 && 
     strcmp($operationStr, 'folderedit') !== 0 && 
     strcmp($operationStr, 'fileedit') !== 0 && 
     strcmp($operationStr, 'newcol') !== 0 &&
     strcmp($operationStr, 'delitem') !== 0 &&
     strcmp($operationStr, 'act') !== 0 &&
     strcmp($operationStr, 'upload') !== 0 &&
     strcmp($operationStr, 'subfolders') !== 0)
  {     
    $operationStr = '';
  }
  
  if($_GET && isset($_GET['fol']) && is_string($_GET['fol']))
    $folderStrGlobal = $_GET['fol'];
  
  if($_GET && isset($_GET['file']) && is_string($_GET['file']) && strlen($_GET['file'])>0 )
  {
    if(IH_IsValidFilename($_GET['file']))
      $fileStrGlobal = $_GET['file'];
  }

  $msgString = '';
  if($_GET && isset($_GET['msg']) && is_string($_GET['msg']))  // message 
  {
    $msgString = $_GET['msg'] ;
    if( strlen($msgString) > 200 )
      $msgString = substr($msgString, 0, 197) . '...' ; // length limit
  }
    
  // Validate Folder String
  $bWasSanitized = IH_SanitizeBaseArg($folderStrGlobal);  
  // at this point $folderStrGlobal, is either '/' or '/A/' or '/A/*/**/' (something safe) 
  
  if(strcmp($operationStr, 'newcol') === 0) // if making a new col, we just need to be logged in. 
  {
    $folderStrGlobal = '/';
    $collectionStrGlobal = '';
    if(strcmp($usernameStrGlobal, '') === 0)
    {
      $operationStr = '';
      $msgString = 'Authorization Error: You must be logged in to perform this operation.';
    }
  }
  else
  if(strcmp($operationStr, 'act') === 0) // account settings page
  {
    $folderStrGlobal = '/';
    $collectionStrGlobal = '';
    if(strcmp($usernameStrGlobal, '') === 0)
    {
      $operationStr = '';
      $msgString = 'Authorization Error: You must be logged in to perform this operation.';
    }
  }
  else
  if(strcmp($folderStrGlobal, '/') !== 0) // if we're in a collection, make sure we're allowed to be there, based on which arg we pass
  {  
    $collectionStrGlobal = IH_GetCollectionNameFromFolderStr($folderStrGlobal);
  
    if(strcmp($collectionStrGlobal, '') !== 0 ) // if we're in a collection
    {
      // PERMS   // if mutative op 
      if(strcmp($operationStr, 'folderedit') === 0 || 
         strcmp($operationStr, 'fileedit') === 0 || 
         strcmp($operationStr, 'delitem') === 0)
      {
        if( IH_CanUserModCollection($collectionStrGlobal, $usernameStrGlobal) )
        {
        }
        else // not authorized to edit said collection 
        {
          if(strcmp($operationStr, 'fileedit') === 0) // back us out to singleview 
            $operationStr = 'singleview';
          else
            $operationStr = ''; // else back us out to grid 
          
          $msgString = 'Authorization Error: Insufficient Modify Permissions.';
          
          if( IH_CanUserReadCollection($collectionStrGlobal, $usernameStrGlobal) )
          {
          }
          else // FAILURE, revert to root '/'
          {
            $msgString = 'Authorization Error: Insufficient Read & Modify Permissions.'; 
            $folderStrGlobal = '/';
            $collectionStrGlobal = '';
          }    
        }
      }
      else
      if(strcmp($operationStr, 'upload') === 0) // 'special' upload page 
      {
        if( IH_CanUserUploadCollection($collectionStrGlobal, $usernameStrGlobal) )
        {
        }
        else // not authorized to upload to said collection 
        {
          $msgString = 'Authorization Error: Insufficient Upload Permissions.';
          $operationStr = '';
          if( IH_CanUserReadCollection($collectionStrGlobal, $usernameStrGlobal) )
          {
          }
          else // FAILURE, revert to root '/'
          {
            $msgString = 'Authorization Error: Insufficient Read & Upload Permissions.'; 
            $folderStrGlobal = '/';
            $collectionStrGlobal = '';
          }
        }
      }
      else // non mutative ops 
      {
        if( IH_CanUserReadCollection($collectionStrGlobal, $usernameStrGlobal) )
        {
          // Success , leave as set, and paginate
        }
        else // FAILURE, revert to root '/'
        {
          $msgString = 'Authorization Error: Insufficient Read Permissions.';
          $folderStrGlobal = '/';
          $collectionStrGlobal = '';
        }
      }
    }
  }
  
  /*
  if(0) // debugging
  {
    //var_dump($_GET);
    echo("page: " . $_GET['page'] . "<br>\r\n");
    echo("op: " . $_GET['op'] . "<br>\r\n");
    echo("fol: " . $_GET['fol'] . "<br>\r\n");
    echo("msg: " . htmlspecialchars($_GET['msg']) . "<br>\r\n");
    //die();
  }
  */
  
  $argArr = Array(
    'usernameStr' => $usernameStrGlobal,
    'collectionStr' => $collectionStrGlobal,
    'folderStr' => $folderStrGlobal,
    'fileStr' => $fileStrGlobal,
    'pageNumber' => $pageValue,
    'opStr' => $operationStr,
    'editItemStr' => '',
    'messageStr' => $msgString,
    'modTokenStr' => $modTokenStrGlobal,
    'bShowCmtDelete' => $bShowCmtDeleteGlobal,
    'bMobile' => isMobile()    
  );
  
  // ($usernameStr, $collectionStr, $folderStr, $fileStr, $pageNumber, $opStr, $editItemStr, $messageStr, $modTokenStr, $bShowCmtDelete, $bMobile)

  Echo_Layout($argArr);    
