// Upload.js

  var _submit = document.getElementById('_submit'),
  _abort = document.getElementById('_abort'), 
  _file = document.getElementById('_file'), 
  _progress = document.getElementById('_progress'),
  _uploadresult = document.getElementById('uploadresult'),
  _renamecheck = document.getElementById('exifrncheck');

  _abort.disabled = true;

  //variables called during 'progress' event 
  var curLatestPercent = 0;
  var candidate = 0;
  
  var bAborted = false;
  
  var request;

  var upload = function()
  {
    if(_file.files.length === 0)
    {
      _uploadresult.innerHTML = '<p> No Files Selected.';
      return;
    }
    if(_file.files.length > maxFileNumber)
    {
      _uploadresult.innerHTML = '<p> Too Many Files Selected! Max:' + maxFileNumber;
      return;
    }
    
    _uploadresult.innerHTML = ''; // clear results if previous event occurred

    _submit.disabled = true; 
    _renamecheck.disabled = true;  
    _file.disabled = true;
    _abort.disabled = false; // switch on Cancel

    var data = new FormData();
    data.append('mode', "js"); // javascript uploader mode 
    data.append('jrr', usertoken); // session token
    data.append('fol', folderStr); // target folder   
    
    if(_renamecheck.checked == true)
    {
      data.append('exifrn', ''); // doesnt have to be anything in particular, reciever only checks that it's set 
    }
    
    // File(s)
    var ins = _file.files.length; // num files 
    data.append('numfiles', ins); // intended number of files to upload. If this does not match at other end, an abort has occurred 
    for (var x = 0; x < ins; x++) 
      data.append("userfile[]", _file.files[x]);
      
    request = new XMLHttpRequest();
    
    request.onreadystatechange = function()
    {
      if(request.readyState == 4) // when the upload has finished 
      {
        curLatestPercent = 0;
        candidate = 0;
        _progress.style.width = curLatestPercent +  '%';
        
        _submit.disabled = false; 
        _renamecheck.disabled = false; 
        _file.disabled = false; 
        _abort.disabled = true; // switch off Cancel
      
        try 
        {
            var resp = JSON.parse(request.response);
        } 
        catch (e)
        {
            var resp = 
            {
                status: '1',
                markup: 'Unknown error occurred: [' + request.responseText + ']'
            };
        }
        
        if(!bAborted) // happy flow
        {
          //if(resp.status == '0')

          _uploadresult.innerHTML = resp.markup;

        }
        else
        {
          _uploadresult.innerHTML = '<p> Upload Operation Aborted.';
        }
        
        bAborted = false; //reset
      }
    };
    
    /*request.upload.addEventListener('abort', function(e)
    {
      console.log("ABORT CALLED");
    }, false);*/

    request.upload.addEventListener('progress', function(e)
    {
      candidate = Math.ceil((e.loaded/e.total) * 100); 
      if ( candidate > curLatestPercent ) // sends only the necessary updates to the gui
      {
        curLatestPercent = candidate;
        _progress.style.width = curLatestPercent +  '%';
      }
        
    }, false);

    request.open('POST', 'upload_file.php');
    request.send(data);
  }

  _submit.addEventListener('click', upload);

  var abortUpload = function()
  {
    bAborted = true;
    request.abort();
  }

  _abort.addEventListener('click', abortUpload);
  