<?php

  include 'GenFns.php';
  include 'ModFns.php';
  include 'ExifFns.php';
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');
  
  function is_base64($inStr) // just a sanity check
  {
    return (bool) preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $inStr);
  }
  
  // based on what was processed this run, create markup to display on the client. 
  function GenerateResponseTable($statusStr, $inArr, $msgStr, $bAttemptedRename)
  {
    if($statusStr === '0')
    {
      $helpfulStr = '';
      if($bAttemptedRename)
        $helpfulStr = '<br><span style="color:green;">&#10004;</span> = <i>Denotes file was successfully renamed from EXIF date data.</i>';
      
      $rowsMarkup = '';
      foreach($inArr as $pair)
      {
        $oldName = $newName = '!!!!ERROR!!!!';
        
        $checkStr = ''; // default to NOT displaying anything 
        
        if(isset($pair[0]))
          $oldName = $pair[0];
        if(isset($pair[1]))
          $newName = $pair[1];
        if(isset($pair[2]) && ($pair[2] === true))
          $checkStr = "<span style=\"color:green;\"> &#10004; </span>";
        
        $rowsMarkup .= "
        <tr>
            <td>
              ".htmlspecialchars($oldName)."
            </td>
            <td>
              ".htmlspecialchars($newName).$checkStr."
            </td>
        </tr>
        ";
      }
      
      $retStr = "
        <table border=0 style=\"margin-bottom: 32px;\">
          <tr>
            <td colspan=2>
              <div align=center>
                <h3><b>Status:</b> <i>Success</i></h3>
              </div>
            </td>
          </tr>
          <tr>
            <td>
              <h4>Recieved ".count($inArr)." file(s).</h4>
            </td>
            <td>
              ".$helpfulStr."
            </td>
          </tr>
          
          <tr>
            <td width=50%>
              <h4>Original Filename</h4>
            </td>
            <td>
              <h4>Final Filename</h4>
            </td>
          </tr>
          
          ".$rowsMarkup."
        </table>
      ";
    }
    else // for failure modes, generate something presentable 
    {
      $retStr = "
        <table border=0 style=\"margin-bottom: 32px;\">
          <tr>
            <td>
              <div align=center>
                <h3><b>Status:</b> <i>Error</i></h3>
              </div>
            </td>
          </tr>
          <tr>
            <td>
              <div align=center>
                <h4>".htmlspecialchars($msgStr)."</h4>
              </div>
            </td>
          </tr>
        </table>
      ";
    }
    
    return $retStr;
  }
  
  // Output JSON
  function outputJSON($statusStr, $markupStr)
  {
      header('Content-Type: application/json');
      die(json_encode(array(
          
          'status' => $statusStr, // 0 = succcess, 1 = ANY errors occurred
          'markup' => $markupStr  // what we want to display in the div below, sever generated
          
      )));
  }
  
  // START ======================================================================================================================
  $usernameStrGlobal = '';
  $modTokenStrGlobal = '';
  
  // Mode (unset assume traditional form upload, else javascript which needs json...)
  $bModeJSON = false;
  if($_POST && isset($_POST['mode']) && is_string($_POST['mode']) && strcmp($_POST['mode'], 'js') === 0 )
    $bModeJSON = true;
  else
    outputJSON('1', 'Error: Mode Deprecated');
  
  // numfiles (tells us the intended number of files that should be in the $_FILES array, if it doesn't match an abort was called... so dont keep anything 
  if($_POST && isset($_POST['numfiles']) && is_string($_POST['numfiles'])  )
  {
    $numfiles = $_POST['numfiles'];
    if(is_numeric($numfiles))
    {
      $iv = intval($numfiles);
      if( $numfiles == $iv )
      {
        $numfiles = $iv;
        if($numfiles >= 1 && $numfiles <= 10000000)
        {
          if($numfiles != count($_FILES['userfile']['name']))
            outputJSON('1', 'Error: The number of files expected was different than what was recieved. This is most likely due to the connection being terminated prematurely.');
        }
        else
          outputJSON('1', 'Error: The number of files expected was out of range.');
      }
      else
        outputJSON('1', 'Error: The number of files expected was invalid.');
    }
    else
      outputJSON('1', 'Error: The number of files expected was not a number.');
  }
  else
    outputJSON('1', 'Error: The number of files expected was not supplied!');
  
  IH_SessionStart();
  if(IH_IsLoggedIn())
  {
    $usernameStrGlobal = IH_GetUserName(); 
    $modTokenStrGlobal = $_SESSION[IH_GetInstanceName().'-modtoken'];
  }
  else
  {
    if($bModeJSON)
      outputJSON('1', 'Not Authorized to Upload Files. (001)');
    else
      IH_RedirMessageHalt('/', "Not Authorized to Upload Files. (001)" , false);
  }
  
  IH_SessionClose();// No Session-dependant calls after here
  
  $passedToken = '';
  if($_POST && isset($_POST['jrr']) && is_string($_POST['jrr']))
    $passedToken = $_POST['jrr'];
  
  // Validate Token "Credentials"
  if((strlen($passedToken) === 0) || (strlen($modTokenStrGlobal) === 0) || !hash_equals($modTokenStrGlobal, $passedToken))
  {
    if($bModeJSON)
      outputJSON('1', 'Not Authorized to Upload Files. (002)');
    else
      IH_RedirMessageHalt('/', "Not Authorized to Upload Files. (002)" , false);  
  }
  
  $folderStrGlobal = '';  
  $collectionStrGlobal = ''; 
  
  if($_POST && isset($_POST['fol']) && is_string($_POST['fol']) && (strlen($_POST['fol']) > 0) && is_base64($_POST['fol']))
    $folderStrGlobal = base64_decode($_POST['fol']); // this was encoded when it was printed to the page such that we dont need to escape anything.
  else
    outputJSON('1', 'Error: The target folder supplied was invalid.');
    
  // Validate Folder String
  $bWasSanitized = IH_SanitizeBaseArg($folderStrGlobal);
  
  $collectionStrGlobal = IH_GetCollectionNameFromFolderStr($folderStrGlobal);

  if(!$bWasSanitized && (strcmp($usernameStrGlobal, '') !==0) && IH_CanUserUploadCollection($collectionStrGlobal, $usernameStrGlobal)) // logged in and has access 
  {
    ignore_user_abort(true); // Ignore user aborts and allow the script to run forever
    set_time_limit(0);

    $successfulUploadCnt = 0;
    $successfulFileList = '';
    
    $uploadedPathsArr = array();
    
//upload_file specific
    $ErrorString = ''; // any errors on a per-file basis, while trying to move from temp to final location.
    
    $namingArr = Array(); // the results of what we uploaded successfully, thier past and present names, each element is a 2-element sub array
    
    $bExifRename = false; // if user opts, attempt to search file metadata for appropriate original 'shot date' and use it for entire filename in android fmt.
    if($_POST && isset($_POST['exifrn']) && IH_CommandExists('exiftool'))
      $bExifRename = true;
    
    if( ($fp = IH_GetFolderLock($folderStrGlobal)) !== false) // LOCK
    {
      // Loop through each file (per-file upload loop)
      // ===============================================================================================================
      for($i=0; $i<count($_FILES['userfile']['name']); $i++)
      {
        $bWasRenamedToDate = false;
        
        $tmpFilePath = $_FILES['userfile']['tmp_name'][$i]; // where its stored currently, usually "/tmp/randomname"

        if ($tmpFilePath != '' && ($_FILES["userfile"]["size"][$i] > 0))//Make sure we have a filepath and some size!
        {
          $path_info1 = pathinfo($_FILES["userfile"]["name"][$i]);
          $path_info1_extension = strtolower($path_info1['extension']) ; // ie. "jpg", "png" 
          $path_info1_filename = $path_info1['filename']; // yields an EXTENSION-LESS name of the file
          
          if (strcasecmp("PHP", $path_info1['extension']) == 0) // no .phps allowed
          {
            $ErrorString .= "<br>Disallowed Extension: " . $_FILES["userfile"]["name"][$i] ;
            continue; 
          }
          
          if ($_FILES["userfile"]["error"][$i] > 0) // any errors in the associative array.
          {
            $ErrorString.="<br>Return Code:&nbsp;".$_FILES["userfile"]["error"][$i]."&nbsp;&nbsp;File:&nbsp;&nbsp;".$_FILES["userfile"]["name"][$i] ;
            continue;
          }
          else
          {
            /*
            $perFileDebugOutput  = "<p>";
            $perFileDebugOutput .= "Upload: " . $_FILES["userfile"]["name"][$i] . "<br />";
            $perFileDebugOutput .= "Type: " . $_FILES["userfile"]["type"][$i] . "<br />";
            $perFileDebugOutput .= "Size: " . ($_FILES["userfile"]["size"][$i] / 1024) . " Kb<br />";
            $perFileDebugOutput .= "Temp file: " . $_FILES["userfile"]["tmp_name"][$i] . "<br />";
            */

            $bValidOriginalFilename = IH_IsValidFilename($_FILES["userfile"]["name"][$i]); // name passed in in associative array ie. "mypic.jpg" 
            
            $finalFilename = '' ;
            
            // do this work even if $bExifRename == false, since exif rename process has potential to fail 
            if($bValidOriginalFilename)
              $finalFilename = $path_info1_filename;
            else
              $finalFilename = 'NewFile';


            if($bExifRename) // attempt to reach into the file and grab a useable name derived from various fields as defined in ExifFns 
            {
              if(($shellRet = ExifShellExecWrapper($_FILES["userfile"]["tmp_name"][$i])) !== false)
              {
                if(($dateStr = GetSanitizedDateFromExif($shellRet)) !== false)
                {
                  $bWasRenamedToDate = true;
                  $finalFilename = $dateStr; // this comes back sanitized as per android-style date_time stirng
                }
              }
            }
            
            $finalExtension = '';
            if(strlen($path_info1_extension) > 0)
              $finalExtension = '.' . $path_info1_extension ;
            
            $finalFilename = IH_NameAdjuster( IH_DataCollectionsRoot() . $folderStrGlobal , $finalFilename, $finalExtension ) ;
            
            $finalFilePath = IH_DataCollectionsRoot() . $folderStrGlobal . $finalFilename . $finalExtension  ;     
    
            $uploadedPathsArr[] = $folderStrGlobal . $finalFilename . $finalExtension ; // only generate ihars for the files uploaded NOW

            move_uploaded_file($_FILES["userfile"]["tmp_name"][$i], $finalFilePath);  
            
            if(file_exists($finalFilePath)) // if the file now resides there, bump the success counter.
            {
              $successfulUploadCnt++;
              
              $namingArr[] = Array(
                ($path_info1_filename . '.' . $path_info1_extension), // OLD name (user-supplied)
                ($finalFilename . $finalExtension), // new name
                $bWasRenamedToDate // if it was renamed to date
              );

              if(!empty($successfulFileList))
                $successfulFileList .= ', ' ;
              $successfulFileList .= $finalFilename . $finalExtension ;
            }
            
            if(!$bValidOriginalFilename)
            {
              $ErrorString.="<br><b>". htmlspecialchars($_FILES["userfile"]["name"][$i]) . "</b> Contains Illegal Characters, renaming to <b>" . htmlspecialchars($finalFilename . $finalExtension) . "</b>" ;
            }
          }
        }
        //TODO add to errror log that "File empty: check your max_upload_size limits in php.ini"
      } // end of per-file loop...
      
      IH_ReleaseFolderLock($fp);
    } 
    else
    {
      if($bModeJSON)
        outputJSON('1', 'Unable to move uploaded files to final directory.');
      else
        IH_RedirMessageHalt('/', "Unable to move uploaded files to final directory." , false);
    }
    
    IH_InitializeFolder( $folderStrGlobal, false );
    
    IH_InitiateIHARMaker($uploadedPathsArr);
    
    
    // SUCCESS
    if($bModeJSON)
    {
      //outputJSON('0', "Upload Routine Finished. " . $successfulUploadCnt . " files received. (" . $successfulFileList . ")");
      outputJSON('0', GenerateResponseTable('0', $namingArr, '', $bExifRename));
    }
    else
      IH_RedirMessageHalt($folderStrGlobal, "Upload Routine Finished. " . $successfulUploadCnt . " files received" , false); // successful redirect
  }
  else
  {
    if($bModeJSON)
      outputJSON('1', 'Not Authorized to Upload Files.  (003)');
    else
      IH_RedirMessageHalt('/', "Not Authorized to Upload Files.  (003)" , false);
  }
  