<?php
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/
  // Handles Calls for Create/Edit/Removal of User accounts from password file

  function Noter_EditUser($username, $op)
  {
    // $op == 0 (remove user)
    // $op !== "" (op contains string of new password, hash it and write it in file
    
    $sourceFilePath = Noter_GetPasswordFile();
    $outputFilePath = Noter_GetPasswordFile();
    
    $tempOutputFile = $outputFilePath . '.tmp';
    if(file_exists($tempOutputFile))
      unlink($tempOutputFile);
    
    $handleRead = fopen($sourceFilePath, "r");
    $handleWrite = fopen($tempOutputFile, 'w');
    if ($handleRead && $handleWrite) 
    {
      $lineCnt = 1;
      while (($lineStr = fgets($handleRead)) !== false) // loops once per line from input
      {
        $writeMe = $lineStr;
        
        $token = strtok($lineStr, " "); // should be the username
        
        if(strcasecmp($token, $username) == 0)// found this user
        {
          if($op === 0) // then we want to delete
          {
            continue;
          }
          else // op contains the new password
          {
            $token = strtok(" ");//existing pass
            $token = strtok(" ");//user creation date
            
            $writeMe = $username . " " . Noter_ApplyCrypt($op) . " " . $token; 
          } 
        }
        
        // line gotten from $lineStr will have trialing return so...
        // remove trailing returns
        $writeMe = str_replace("\r", '', $writeMe);
        $writeMe = str_replace("\n", '', $writeMe);
        
        // prefix line with return, except first
        if($lineCnt > 1)
          $writeMe = "\r\n" . $writeMe;  //prepend a return ONLY if we're going to put something on this line...
            
        fwrite( $handleWrite, $writeMe );  
        
        $lineCnt++;
      }
      fclose($handleRead);
      fclose($handleWrite);
      
      shell_exec('mv ' . escapeshellarg($tempOutputFile) . ' ' . escapeshellarg($outputFilePath));
      //shell_exec('chmod 777 ' . escapeshellarg($outputFilePath));    
    }  
  }
  
  function Noter_DoesUserExist($username)
  {
    $fh = fopen(Noter_GetPasswordFile(), "r");
    if($fh) 
    {
      while ( !feof($fh) )   // loops once per line in the file
      {
        $line = fgets($fh);        // now we have a line
        $token = strtok($line, " ");       // tokenize it on spaces, should have a username now
        if($token !== false)
        {
          //echo "entire ".$line."<br>";
          if(strcasecmp($token, $username) == 0)// If the first token matches the username supplied.
          {
            return true;
          }
        }
      }
    }
    fclose($fh);
    
    return false;
  }

  function Noter_CreateUser($username, $password)
  {
    $username = strtolower($username); // Only lowercase usernames
    
    $lineStr = '';
    if(strcasecmp('admin', $username) !== 0)
      $lineStr = "\r\n" . $username . " " . Noter_ApplyCrypt($password) . " " . date('Y-m-d_H:i:s') ;
    else
      $lineStr = "" . $username . " " . Noter_ApplyCrypt($password) . " " . date('Y-m-d_H:i:s') ;
        
    $statusMsg = '';
    if( file_put_contents(Noter_GetPasswordFile(), $lineStr, FILE_APPEND | LOCK_EX) === false )
      $statusMsg = 'Failed to Create new user "' . htmlentities($username) .'"';
    else
      $statusMsg = 'Created new user "' . htmlentities($username) .'"';
        
    return $statusMsg;
  }

  ?>