<?php
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/
  // Noter Global Function File
  
  include 'Config.php';    
  
  function Noter_GetDataFolderPath()
  {
    return DATA_CACHE_FOLDER;
  }
  
  function Noter_GetMetaFolderPath()
  {
    return META_CACHE_FOLDER;
  }
  
  // start FOLDER PATH FNs =========================================================================================
  function Noter_GetUserDataFolderPath($usernameStr) // deeper than above, with user specific context
  {
    return Noter_GetDataFolderPath() . DIRECTORY_SEPARATOR . 'Users' . DIRECTORY_SEPARATOR . $usernameStr;
  }
  function Noter_GetUserMetaFolderPath($usernameStr) // deeper than above, with user specific context
  {
    return Noter_GetMetaFolderPath() . DIRECTORY_SEPARATOR . 'Users' . DIRECTORY_SEPARATOR . $usernameStr;
  }
  function Noter_GetPubDataFolderPath() 
  {
    return Noter_GetDataFolderPath() . DIRECTORY_SEPARATOR . 'Pub' ;
  }
  function Noter_GetPubMetaFolderPath() 
  {
    return Noter_GetMetaFolderPath() . DIRECTORY_SEPARATOR . 'Pub' ;
  }
  // end FOLDER PATH FNs =========================================================================================
  
  function Noter_GetPasswordFile()
  {
    return Noter_GetMetaFolderPath() . DIRECTORY_SEPARATOR . PASSWORD_FILENAME ;
  }
  
  function Noter_GetCryptSalt()
  {
    return '$6$rounds=5000$' . JUST_PASSWORD_SALT . '$'; // SHA-512, with 16 char salt
  }
  
  function Noter_ApplyCrypt($inputStr)
  {
    return crypt($inputStr, Noter_GetCryptSalt());
  }
  
  // pre php5.6.0 implementation of const time str compare
  if(!function_exists('hash_equals')) 
  {
    function hash_equals($str1, $str2) 
    {
      if(strlen($str1) != strlen($str2)) 
      {
        return false;
      } 
      else 
      {
        $res = $str1 ^ $str2; // xor, makes a bit vector of differences between them, $res is a string of potentially many non-printable characters.
        // res shouldnt be considerd a string at this point, ie. in the case of equal strings it is an array of ints, more or less, all with values as \x00
          //echo ("RES: " . strlen($res). ' ' . bin2hex($res) . "<br>\r\n");
          
        // the rest is just basically 'adding' the values of each char up and seeing if its still zero at the end. 
        $ret = 0;
        for($i = strlen($res) - 1; $i >= 0; $i--) 
        {
          $ret |= ord($res[$i]); // getting the int val of the char at i
          //echo (ord($res[$i]) . "<br>\r\n"); 
        }
        
        //echo ("At End: " . bin2hex($ret) . ' ' . $ret . "<br>\r\n");
        //echo ("At End!: " . bin2hex(!$ret) . ' ' . !$ret . "<br>\r\n");
        
        // at this point if they're equal, $ret will contain all zeros
        // http://php.net/manual/en/function.boolval.php
        return !$ret;
      }
    }
  }
  
  function Noter_GetInstanceName()
  {
    return NOTER_INST_NAME;   
  }
  
  function Noter_GetLogonCookieName() // the cookie named by this stores what we fill in the logon field for the next time we logon
  {
    return 'Noter-' . Noter_GetInstanceName() . '-Username';
  }
  
  function Noter_GetUserSessionVariable()
  {
    return ''.Noter_GetInstanceName().'-UserName';
  }
  
  function Noter_LogOnThisUser($usernameStr)
  {
    $var = Noter_GetUserSessionVariable();
    $_SESSION[$var]=$usernameStr;
  }
  
  function Noter_LogOffThisUser()
  {
    // wipes out ONLY the entry in the session file corresponding to the instance-username
    unset($_SESSION[ Noter_GetUserSessionVariable() ]);
  }
  
  function Noter_GetUserName()
  {
  	return $_SESSION[Noter_GetUserSessionVariable()] ;
  }

  function Noter_IsLoggedIn()
  {
  	$var = Noter_GetUserSessionVariable();
  	if(isset($_SESSION[$var]))
	    return true;

    return false;
  }

  function Noter_IsLoggedInAsAdmin()
  {
  	$var = Noter_GetUserSessionVariable();
  	if(isset($_SESSION[$var]) && strcasecmp($_SESSION[$var], "admin") == 0)
	    return true;

	  return false;
  }
  
  
  
  
  // return: true/false
  function Noter_EvalPassword($usernameStr, $passwordStr)
  {
    $user = $usernameStr;

    // general vars
    $passwordfile = Noter_GetPasswordFile();
    $foundmatch = false;
    $fh = fopen($passwordfile, "r");

    if($fh) 
    {
      while ( !feof($fh) )   // loops once per line in the file
      {
        $line = fgets($fh);        // now we have a line
        $token = strtok($line, " ");       // tokenize it on spaces, should have a username now
        if($token !== false)
        {
          //echo "entire ".$line."<br>";
          if(strcasecmp($token, $user) == 0)// If the first token matches the username supplied.     case insensitive
          {
            //echo "matched  ".$token."<br>";
            $token = strtok(" "); // move on to the next token
            // apparently this'll have the \r \n garbage on the end... remove it
            $token = str_replace("\r", '', $token);
            $token = str_replace("\n", '', $token);

            //echo "next token  \"".$token."\"<br>";
            //echo "THE STR CMP ".strcmp((string)$token,(string)$pass)."<br>";
            if( ($token !== false) && hash_equals($token, Noter_ApplyCrypt($passwordStr)) )// And password matches
            {
              $foundmatch = true;
            }
            break;  // we encountered an entry for this user, we either found a match or not at this point.
          }
        }
      }
    }
    fclose($fh);
    return $foundmatch;    
  }
  
  
  // Cur Dir Functions ===========================================
  function Noter_GetCurDirFilePath($username)
  {
    return Noter_GetMetaFolderPath() . DIRECTORY_SEPARATOR . 'Users' . DIRECTORY_SEPARATOR . $username . '.curdir' ; 
  }  
  // returns a 2-string array , the current dom/folder string. 
  function Noter_GetCurDir() 
  {
    $toReturn = Array();
    $username = Noter_GetUserName();
    if(strlen($username) > 0)
    {
      $path = Noter_GetCurDirFilePath($username);
      if(file_exists($path))
      {
        $handleRead = fopen($path, "r");
        if ($handleRead) 
        {
          while (($lineStr = fgets($handleRead)) !== false) // loops once per line from input
          {
            $lineStr = str_replace("\r", '', $lineStr);
            $lineStr = str_replace("\n", '', $lineStr);
            $toReturn[] = $lineStr;
          }
          fclose($handleRead);
        }
      }
    }
    return $toReturn;
  }  
  function Noter_SetCurDir($domStr, $folderPathStr)
  {
    $username = Noter_GetUserName();
    if(strlen($username) > 0)
    {
      $path = Noter_GetCurDirFilePath($username);
      if(file_exists($path))
        unlink($path);
      
      $handleWrite = fopen($path, 'w');
      if ($handleWrite) 
      {
        fwrite($handleWrite, $domStr . "\r\n" );  
        fwrite($handleWrite, $folderPathStr . "\r\n" );  
        fclose($handleWrite);
      }      
    }
  }
  
  function my_mime_content_type($filename) 
  {
    $finfo = new finfo(FILEINFO_MIME);
    $type  = $finfo->file($filename);
    return $type;
  }
  
  /* 
  // FILE-SPECIFIC META FILE
  // called with the contents of the meta file from "upload_file.php"
  // 1st Line: MIMEtype
  */
  function CreateMetaFile($filePath, $MIMEtype)
  {
    if(file_exists($filePath))
      unlink($filePath);
    
    $fh = fopen($filePath, 'w') or die("Error: Can't open metafile handle! (writing ".$filePath.")" );
    fwrite($fh, $MIMEtype); // line 1 is MIME
    //fwrite($fh, "\r\n");
    fclose($fh);
  }
  function ReadMetaFileLine($filePath, $lineNum)
  {
    $toReturn = '';
    $handle = fopen($filePath, "r");

    if ($handle) 
    {
      $counter = 1;
      while (($toReturn = fgets($handle)) !== false)
      {
        if($lineNum == $counter)
          break;
        $counter++;
      }
      fclose($handle);
      
      if($toReturn === false) // we ran out of lines, dont return false, explicity return empty string. This will help future-proof, when format of meta file changes
        return '';
      else 
        $toReturn = str_replace("\r\n", '', $toReturn); // newline cleanup
      
      return $toReturn;
    }
    return '';
  }
  function GetMimeFromFile($metaFilePath)
  {
    if(file_exists($metaFilePath))
      return ReadMetaFileLine($metaFilePath, 1);
    else
      return '';
  }
  
  // for ensuring the "folderStr" path lies under a respective data/meta folder prefix "folderPrefixStr"
  // folder str could also point to file, caller should subsequently verify if its a folder if necessary
  function Noter_ValidateFolderPath ($folderStr, $folderPrefixStr)
  {
    $realStr1 = realpath($folderStr); // will either be NULL if nonexistant or point to sth
    $realStr2 = realpath($folderPrefixStr); // SHOULD BE SAFE ALREADY
    if($realStr1 === false ) //if it wasnt there
      return false;
    
    $pos = strpos($realStr1, $realStr2);//find first occurence of str2 in str1.
    if($pos !== 0)
      return false;
    else
      return true;
    /*else // if we know its a prefix, still check to see that Str1 is a dir
    {
      if(is_dir($realStr1))
        return true;
      else
        return false;
    }*/
  }

  // ========================================================================================
  // INPUT VALIDATION CHECKERS
  function Noter_IsValidUsername($usernameStr) // username is displayed in page
  {
    if (strlen($usernameStr) == 0) 
      return false;
    if (strlen($usernameStr) > 64) 
      return false;
    
    // Whitelist checking
    $whitelist = USERNAME_CHAR_WHITELIST;
    for ($x = 0; $x < strlen($usernameStr); $x++) // iterates through whitelist characters of the username 
    {
      $pos = strpos($whitelist, substr($usernameStr, $x, 1) ); 
      if ($pos === false) // the x'th char of input was not located in the set of valid whitelist characters 
        return false;
    } 
    
    /* Subsequent Illegal character check...
    $searchArr  = array('[',']','{','}','(',')','<','>',';',':','/','\\','?','!','.',',');
    $replaceArr = array('');
    $processedStr = str_replace($searchArr, $replaceArr, $usernameStr);
    
    if(strcmp($processedStr, $usernameStr) !== 0 ) // if they aren't the same.
      return false;*/
    
    return true;
  }
  function Noter_IsValidPassword($passwordStr) // pass is never displayed so can't inject to page, it is fed to crypt only
  {
    if (strlen($passwordStr) == 0) 
      return false;
    if (strlen($passwordStr) > 256) 
      return false;
    
    return true;
  }
  
  // Sanitize and MODIFY domainStr and folderStr
  function Noter_SanitizeBaseArgs($user, &$dom, &$fol)  
  {
    //DEFAULTS
    $domDefault = 'pri'; // private
    $folDefault = '/'; // root of the current domain
    
    if(is_string($dom)) 
    {
      if(strcmp($dom, 'pri') !== 0 && strcmp($dom, 'pub') !== 0 )
        $dom = $domDefault;
    }
    else
      $dom = $domDefault;
    
    if(is_string($fol))
    {
      // Remove known trouble characters, and make sure something still remains, otherwise set to default root char '/'
      
      // Control Character removal (00-31,127)
      preg_replace('/[\x00-\x1F\x7F]/', '', $fol); // will work with mb
      
      // Maybe more goes here?...
      
      // trim space from ends 
      $fol = trim($fol);
      
      // ensure leading slash
      if(mb_strlen($fol) > 0)
      {
        if(strcmp( '/', mb_substr($fol, 0, 1) ) !== 0) 
          $fol = '/' . $fol;
      }
      else
        $fol = $folDefault;
      
      // ensure trailing slash...
      if ( strcmp('/', mb_substr($fol, -1)) !==0)
        $fol .= '/';
      
      // Check if folders(Data/Meta) exists (with realpath) under a specific root
      if(strcmp($dom,'pri') === 0)
      {
        $data = Noter_GetUserDataFolderPath($user) . $fol; // 'Data/Users/$user' . '/' 
        $meta = Noter_GetUserMetaFolderPath($user) . $fol; // 'Meta/Users/$user' . '/' 
        if(Noter_ValidateFolderPath($data, Noter_GetUserDataFolderPath($user)) && Noter_ValidateFolderPath($meta, Noter_GetUserMetaFolderPath($user)) && 
           is_dir($data) && is_dir($meta) )
        {
          return true;
        }
        else
        {
          $fol = $folDefault;
          return false;
        }
      }
      else if(strcmp($dom,'pub') === 0)
      {
        $data = Noter_GetPubDataFolderPath() . $fol; // 'Data/Pub' . '/' 
        $meta = Noter_GetPubMetaFolderPath() . $fol; // 'Meta/Pub' . '/' 
        if(Noter_ValidateFolderPath($data, Noter_GetPubDataFolderPath()) && Noter_ValidateFolderPath($meta, Noter_GetPubMetaFolderPath()) && 
           is_dir($data) && is_dir($meta) )
        {
          return true;
        }
        else
        {
          $fol = $folDefault;
          return false;
        }
      }
    }
    $fol = $folDefault;
    return false;
  }
  
  // Called to check the new file/folder name candidate before making folder/moving uploaded file to it.
  // Called anytime a Creation event occurs
  function Noter_IsValidNewFilename($newNameStr)
  {
    if(is_string($newNameStr))
    {
      // can't be an empty string for a name
      if(strcmp($newNameStr, '') === 0)
        return false;
      
      if(strcmp($newNameStr, '.') === 0)
        return false;
      
      // No .filenames (hidden), glob chokes and can't be trivially rectified without causing something else to break, ie. '{}' chars
      // still good enough for now.
      if(mb_strpos($newNameStr, '.') === 0)
        return false;
      
      // '[]' brackets are a mess with our friend glob
      if(mb_strpos($newNameStr, '[') !== false) 
        return false;
      if(mb_strpos($newNameStr, ']') !== false) 
        return false;
      
      // no double periods anywhere
      if(mb_strpos($newNameStr, '..') !== false)
        return false;
      
      // no slashes anywhere
      if(mb_strpos($newNameStr, '/') !== false)
        return false;
      
      // no backslashes anywhere
      if(mb_strpos($newNameStr, "\\") !== false)
        return false;
      
      // no semicolon (for terminal commands)
      if(mb_strpos($newNameStr, ';') !== false)
        return false;
      
      // Control Character detection (00-31,127)
      if(preg_match('/[\x00-\x1F\x7F]/', $newNameStr))
        return false;

      return true;
    }
    return false;
  }
  
  // No validation, just apply paths based on user/dom/fol
  function Noter_SetDataMetaFolderStrings($user, $dom, $fol, &$data, &$meta)
  {
    // Derive Data/Meta globals.
    if(strcmp($dom,'pri') === 0)
    {
      $data = Noter_GetUserDataFolderPath($user) . $fol; // 'Data/Users/$user' . '/'
      $meta = Noter_GetUserMetaFolderPath($user) . $fol; // 'Meta/Users/$user' . '/' 
    }
    else if(strcmp($dom,'pub') === 0)
    {
      $data = Noter_GetPubDataFolderPath() . $fol;
      $meta = Noter_GetPubMetaFolderPath() . $fol;
    }
  }
  
  function Noter_PrepUserDirs($userStr)
  {
    $data = Noter_GetUserDataFolderPath($userStr);
    $meta = Noter_GetUserMetaFolderPath($userStr);
    // Check that the user directories for the current user exists, if not, make them.
    if(!is_dir($data))
    {
      if(file_exists($data)) // if somehow there was a file there...
        unlink($data);
      
      mkdir($data);
    }
    if(!is_dir($meta))
    {
      if(file_exists($meta)) // if somehow there was a file there...
        unlink($meta);
      
      mkdir($meta);
    }
  }
  
  //recursively delete everything in the folder and it itself...
  function Noter_rrmdir($path)
  {
    if(0)//debugging
      echo("<br>PATH : " . $path);
    
    $output = '';
    if( strcmp($path,'/') !== 0 && strcmp($path,'~') !== 0 ) // make sure its not obvously bad...
    {
      $output = shell_exec("rm -rfv " . escapeshellarg($path) . ""); 
    }
    else
      $output = 'Error: Unsafe path in rrmdir()';
    
    if(0)//debugging
      echo("<br>OUTPUT : " . $output); 
    
    return $output;
  }

  // Returns "filename + $suffix" which is the first to NOT exist under the supplied path with the given extension 
  function Noter_NameAdjuster($path, $filename, $extension)// <-- extension must be .ext
  {
    $suffix = '';
    $potential = $path . $filename . $suffix . $extension; // 'Data/Pub/talkin&walkin/talking and walking/' . 'xyz' . '' . '.txt'
    
    $counter = 1;
    while(file_exists($potential))
    {
      $counter++;
      
      $counterStr = '';
      if($counter < 10)
        $counterStr = '0' . $counter;
      else
        $counterStr = '' . $counter;
      
      $suffix = ' (' . $counterStr . ')';
      
      $potential = $path . $filename . $suffix . $extension;
    }
    return ($filename . $suffix);
  }
  
  // performs a du -sh on the directory denoted by instr
  function MyDirSize($inStr)
  {
    $output = shell_exec("du -sh " . escapeshellarg($inStr)); 
    if(is_string($output))
      if( ($pos = strpos($output, "\t")) !== false)
        return substr($output, 0, $pos );
    
    return 'error'; // error case
  }
