<?php
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/
  include 'Fns.php';
  include 'AccountFns.php';
  session_start();
  
  function GetUsersTable()
  {
    $currentUsername = '';
    
    $retStr = "<table>\r\n";
    $retStr .= "      <tr><td width=\"128\"><b>User</b></td>
    <td width=\"256\"><b>CreateDate</b></td>
    <td width=\"128\"><b>RemoveUser</b></td>
    <td width=\"320\"><b>ChangePassword</b></td></tr>\r\n\r\n";
    $passwordfile = Noter_GetPasswordFile();
    $fh = fopen($passwordfile, "r");

    if($fh) 
    {
      while ( !feof($fh) )   // loops once per line in the file
      {
        $retStr .= "<tr>\r\n";
        
        $line = fgets($fh);        // now we have a line
        $token = strtok($line, " ");       // tokenize it on spaces, should have a username now
        if($token !== false)
        {
          $currentUsername = $token;
          $retStr .= "\t<td>" . $token . "</td>\r\n";
        }
        else
          continue; // if first token isnt there , dont bother with rest of line.
          
        $token = strtok(" ");//skip password field
        $token = strtok(" ");//date field
        //remove \r\n
        $token = str_replace("\r", '', $token);
        $token = str_replace("\n", '', $token);
        if($token !== false)
          $retStr .= "\t<td>" . $token . "</td>\r\n";
        else
          continue; 

        // remove user button
        if(strcasecmp($currentUsername, "admin") == 0)
          $retStr .= "\t<td><i>NA</i></td>\r\n"; // cant remove admin, so empty field
        else
        {
          $retStr .= "\t<td> <form action=\"admin.php\" method=\"POST\">
        <input type=\"hidden\" name=\"op\" value=\"nixuser\">
        <input type=\"hidden\" name=\"username\" value=\"" . $currentUsername . "\">
        <input type=\"submit\" value=\"Remove\"></form>
        </td>\r\n";
        }
        
        // Change Pass Field
        $retStr .= "\t<td> <form action=\"admin.php\" method=\"POST\">
        <input type=\"hidden\" name=\"op\" value=\"passuser\">
        <input type=\"hidden\" name=\"username\" value=\"" . $currentUsername . "\">
        <input type=\"text\" name=\"password\">
        <input type=\"submit\" value=\"Change\"></form>
        </td>\r\n";
        
        
        $retStr .= "</tr>\r\n";
      }
    }
    $retStr .= "</table>\r\n";
    return $retStr;
  }
  
  function GetNewUserFieldArea()
  {
    $retStr = "<p>
        <form action=\"admin.php\" method=\"POST\">
        <input type=\"hidden\" name=\"op\" value=\"newuser\">
        User:<input type=\"text\" name=\"username\">
        &nbsp;&nbsp;Pass:<input type=\"text\" name=\"password\">
        <input type=\"submit\" value=\"Create New User\"></form>";    
    
    return $retStr;
  }
  
  function Echo_Layout($statusMsg)
  {
    $usersTableStr = GetUsersTable();
    $newUserAreaStr = GetNewUserFieldArea();
    
    $statusMsg = "<font color=\"#FF0000\"><b>" . $statusMsg . "</b></font>";
    
    echo("
    <html>
    <head>
    <title>Admin Page</title>
    <link rel=\"stylesheet\" type=\"text/css\" href=\"CSS/logonstyle.css\">
    </head>
    <body>
      <div align=\"center\">
      " . $statusMsg . "
      
      <h3>Admin Page</h3>
      <div class=\"soft-tbl-10\">
      
      ".$usersTableStr."
      </div>
      ".$newUserAreaStr."
      <p><strong>[<a href=\".\">HOME</a>]</strong>
      </div>
    </body>
    </html>");
  }
  
  if( Noter_IsLoggedInAsAdmin() )
  {
    $statusMsg = '';
    if( $_POST && isset($_POST['op']) && is_string($_POST['op']) )
    {
      if(strcasecmp($_POST['op'], 'nixuser') == 0)
      {
        if(isset($_POST['username']) && is_string($_POST['username']))
        {
          if(Noter_IsValidUsername($_POST['username']))
          {
            if(strcasecmp($_POST['username'], "admin") !== 0) // if the username is NOT admin
            {
              // Find the line in the password file and nix it...
              Noter_EditUser($_POST['username'], 0);
            
              $statusMsg = 'Removed User "' . htmlentities($_POST['username']) .'"';
            }
          }
          else
            $statusMsg = 'Username "' . htmlentities($_POST['username']) .'" contains illegal characters<br>Please check the character whitelist for more information.';
        }
      }
      else if(strcasecmp($_POST['op'], 'passuser') == 0)
      {
        if(isset($_POST['username']) && is_string($_POST['username']))
        {
          if(isset($_POST['password']) && is_string($_POST['password']))
          {
            if(Noter_IsValidUsername($_POST['username']))
            {
              Noter_EditUser($_POST['username'], $_POST['password'] );
              $statusMsg = 'Changed Password for user "' . htmlentities($_POST['username']) .'"';
            }
            else
              $statusMsg = 'Username "' . htmlentities($_POST['username']) .'" contains illegal characters<br>Please check the character whitelist for more information.';
          }
        }
      }
      else if(strcasecmp($_POST['op'], 'newuser') == 0)
      {
        if(isset($_POST['username']) && is_string($_POST['username']))
        {
          if(isset($_POST['password']) && is_string($_POST['password']))
          {
            if(Noter_IsValidUsername($_POST['username']))
            {
              if(!Noter_DoesUserExist($_POST['username']))
              {
                $statusMsg = Noter_CreateUser($_POST['username'], $_POST['password']);
              }
              else
              {
                $statusMsg = 'User "' . htmlentities($_POST['username']) .'" already exists!';
              }
            }
            else
              $statusMsg = 'Username "' . htmlentities($_POST['username']) .'" contains illegal characters<br>Please check the character whitelist for more information.';
          }
        }
      }
      
    }      
    
    Echo_Layout($statusMsg);
  }
  else
  {
    header('Location: .'); // go to root
  }
  
  ?>