<?php
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/
  include 'Fns.php';
  session_start();

  if(Noter_IsLoggedIn())
  {
    $userStrGlobal = Noter_GetUserName();  
    
    session_write_close();// No Session-dependant calls after here, we neeed to close session handler asap to be able to do "concurrent" downloads. 
    
    $domainStrGlobal = 'pri'; // 'pri' or 'pub'
    $folderStrGlobal = '/';  // '/' or '/abc/' or '/abc/123/'
    
    //Derived from dom/folder
    $dataFolderStrGlobal = ''; // actual path on the system for data
    $metaFolderStrGlobal = ''; // actual path on the system for meta  

    if($_GET && isset($_GET['dom']) && is_string($_GET['dom']))
      $domainStrGlobal = $_GET['dom'];

    if($_GET && isset($_GET['fol']) && is_string($_GET['fol']))
      $folderStrGlobal = $_GET['fol'];
      
    $bWasSanitized = Noter_SanitizeBaseArgs($userStrGlobal, $domainStrGlobal, $folderStrGlobal);
    
    // NOW AT THIS POINT WE KNOW THE $folderStrGlobal IS SAFE, EITHER BY NEVER HAVING BEEN SUPPLIED OR FAILING VALIDATION CHECK, or working
      
    Noter_SetDataMetaFolderStrings($userStrGlobal, $domainStrGlobal, $folderStrGlobal, $dataFolderStrGlobal, $metaFolderStrGlobal);  

// DL-specific
    $operationStrGlobal = ''; // 'dl' or 'view'
    $itemStrGlobal = ''; // target
    
    if($_GET && isset($_GET['op']) && is_string($_GET['op']) && (strcmp($_GET['op'], 'dl')===0 || strcmp($_GET['op'], 'view')===0) )
      $operationStrGlobal = $_GET['op'];

    if($_GET && isset($_GET['item']) && is_string($_GET['item']) && Noter_IsValidNewFilename($_GET['item']))
      $itemStrGlobal = $_GET['item'];
    
    $dlTargetPath = $dataFolderStrGlobal . $itemStrGlobal;
    
    if(strlen($operationStrGlobal) > 0 && strlen($itemStrGlobal) > 0 && Noter_ValidateFolderPath($dlTargetPath , $dataFolderStrGlobal)) // vars were set and path checks out, lying under dataFolderStrGlobal
    {
      // HEADERS stanza
      // Downloading, MIME TYPE assumes octet-stream (dumb bytes)
      if( strcasecmp($operationStrGlobal, "dl") == 0 )
      {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header("Content-Disposition: attachment; filename=\"". ($itemStrGlobal) ."\"");
      }
      else if(strcasecmp($operationStrGlobal, "view") == 0 )  // viewing, get MIME type from  mime_content_type
      {
        header('Content-Type: ' . mime_content_type($dlTargetPath) );
        header("Content-Disposition: inline; filename=\"" . ($itemStrGlobal) . "\"");
      }

      // Common headers, same for all op modes
      header('Expires: 0');
      header('Cache-Control: must-revalidate');
      header('Pragma: public');
      header('Content-Length: ' . filesize($dlTargetPath)); 
      
      // New code with fread that should handle large files bigger than 128MB...
      if(!file_exists($dlTargetPath))
      {
        echo("Error: Somehow the output file path was empty, or nonexistant. Just prevented fread from going into a tizzy!");
        exit(1); 
      }
      ob_clean();
      ob_end_flush();
      $handle = fopen($dlTargetPath, "rb");
      while (!feof($handle)) 
      {
        echo fread($handle, 1000);
      }
      fclose($handle);
    }
    else
      header('Location: .'); // goto root
  }
  else
  {
    header('Location: logon.php'); // goto logon
  }

?>