<?php	
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/	
  include 'Fns.php';
  session_start();

  
  function var_dump_ret($mixed = null) 
  {
    ob_start();
    var_dump($mixed);
    $content = ob_get_contents();
    ob_end_clean();
    return $content;
  }
  
  // converts an already SANITIZIED path of the form:
  // '/folder1/'
  // '/folder1/folder2/' etc...
  // to an array 
  function ConvertPathToArray($pathStr)
  {
    if(strcmp('/', $pathStr) === 0)
      return array();
    
    // remove outer slashes
    if(mb_strlen($pathStr) > 2) // is at least of form '/a/'
    {
      $pathStr = mb_substr($pathStr, 1, mb_strlen($pathStr)-2 );
    }
    
    //chop up via tokenizer
    $token = strtok($pathStr, '/'); 
    $toReturnArr = array();
    while ($token !== false) // while we have more to go
    {
      $toReturnArr[] = $token; //tack it on the end
      $token = strtok('/');
    }
    return $toReturnArr;
  }
  
  // given the username, returns a markup section to be embedded into the upper left of the page
  function LayoutHelperUsernameMarkup($usernameStr)
  {
    if(Noter_IsLoggedInAsAdmin())
      return "[<a href=\"admin.php\">" . htmlspecialchars($usernameStr) . "</a>]";
    else
      return htmlspecialchars($usernameStr);
  }
  
  // returns a common header for all page states
  function GiveLayoutHeader($usernameStr)
  {
    return "
<html>
<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\">
	<head>
		<title>Noter v" .THE_VERSION. "</title>
		<meta charset=\"utf-8\">
		<link rel=\"shortcut icon\" href=\"/favicon.ico\"></link>
		<link href=\"CSS/style1.css\" rel=\"stylesheet\" type=\"text/css\" media=\"all\">
	</head>

	<body>
		<div class=\"MainDiv\">
			
      <div class=\"CenterDiv\">
      
      
        <div class=\"NavigationDivSub\" style=\"position:relative;\"> 
          <div style=\"float:left;\">
            <span class=\"RedText\">Logged in as: " . LayoutHelperUsernameMarkup($usernameStr) . "</span>
          </div>
            [ <a href=\"logoff.php\" class=\"RedText\">Logout</a> ] 
        </div>
        
        <br><!-- firefox needs -->
        ";
  }
  
  // returns a common footer for all page states
  function GiveLayoutFooter()
  {
    return "
      </div>
		</div>
	</body>
</html>
";
  }
  
  // Normal Page Content Layout (all modes)
  function Echo_Layout($usernameStr, $domainStr, $folderStr, $dataStr, $metaStr, $opStr, $editItemStr)
  {    
    // Domain / Folder String
    $domainFolderMarkup = strtoupper($domainStr) . ":" . htmlspecialchars($folderStr); 
    
    // Listing Selection Markup
    if(strcasecmp($domainStr, 'pri') === 0)
    {
      $listingSelectMarkup = "<span class=\"RedText\">[</span><span class=\"GreenText\">PRIVATE</span><span class=\"RedText\">] [<a href=\".?dom=pub\">PUBLIC</a>] </span>";
      $linkedPathMarkup = "<img src=\"CSS/sitemap.png\">&nbsp;<a href=\".?dom=pri&fol=/\">PRI</a>" . ':/' ;
    }
    else
    {
      $listingSelectMarkup = "<span class=\"RedText\">[<a href=\".?dom=pri\">PRIVATE</a>] [</span><span class=\"GreenText\">PUBLIC</span><span class=\"RedText\">] </span>";
      $linkedPathMarkup = "<img src=\"CSS/sitemap.png\">&nbsp;<a href=\".?dom=pub&fol=/\">PUB</a>" . ':/' ;
    }
    
    // linked path markup (just section dealing with folder path, not domain root (pub/pri))
    if(strcmp('/', $folderStr) !== 0)
    {
      $folderArr = ConvertPathToArray($folderStr);
      if(is_array($folderArr))
      {
        $sz_folderArr = count($folderArr);
        $currentPath = '/';
        for ($x = 0; $x < $sz_folderArr; $x++) 
        {
          $currentPath .= $folderArr[$x] . '/' ;
          $linkedPathMarkup .=  "<a href=\".?dom=" . $domainStr . "&fol=" . rawurlencode($currentPath) . "\">" . htmlspecialchars( $folderArr[$x] ) . "</a>" . '/' ;
        }
      }
    }
     
     
    // FILEZ Table rows markup
    $filezRowsMarkup = '';    
    $filesArr = glob($dataStr.'*'); // this glob will surpress .hidden files, and {} chars...
    foreach ($filesArr as $file)
    {
      // DIRECTORIES
      if (is_dir($file))
      {
        $dirLinkStr = ".?dom=" . $domainStr . "&fol=" . rawurlencode($folderStr . basename($file) . DIRECTORY_SEPARATOR) ;
        
        $delLinkStr = ".?dom=" . $domainStr . "&fol=" . rawurlencode($folderStr) . "&op=delitem&item=" . rawurlencode(basename($file)) ;
        
        $filezRowsMarkup .= "
        <tr class=\"TableContent\">
        <td class=\"tdtext GreenText\"><p>" . date('Y-m-d H:i:s', filemtime($file)) . "</p></td>
        <td class=\"tdtext YellowText\"><a href=\"" . htmlspecialchars($dirLinkStr) . "\"><h3 class=\"table_h3\">" . htmlspecialchars(basename($file)) . "</h3></a></td>
        <td class=\"tdtext GreenText\"><p>-</p></td>	
        <td class=\"tdtext GreenText\"><p>". MyDirSize($file) ."</p></td>
        <td class=\"tdtext GreenText\"><p><a href=\"" . htmlspecialchars($delLinkStr) . "\"><img src=\"CSS/delicon.png\"></a></p></td>
        </tr>
        ";
      }
    } 
    $filesArr = glob($dataStr.'*'); 
    foreach ($filesArr as $file)
    {
      if (is_file($file))
      {
        $fl_sz = filesize($file);
        if($fl_sz >= (1024 * 1024 * 1024))
          $sizeFormatted = "" . round(($fl_sz/1024/1024/1024), 1) . " GiB";
        else if($fl_sz >= (1024 * 1024))
          $sizeFormatted = "" . round(($fl_sz/1024/1024), 1) . " MiB";
        else if($fl_sz >= (1024))
          $sizeFormatted = "" . round(($fl_sz/1024), 1) . " KiB";
        else
          $sizeFormatted = "" . $fl_sz . " Bytes";
        
        $dirLinkStr = '';
        $dirLinkStrColor = 'GreenText';
        $targetBlankTag = ''; // no tag for txt files
        $mimeStr = GetMimeFromFile($metaStr.basename($file)) ;
        if(strcasecmp(pathinfo($file, PATHINFO_EXTENSION), 'txt') === 0 || (strlen($mimeStr) >= 4 && strcmp('text',substr($mimeStr, 0, 4)) === 0)  )
          $dirLinkStr = ".?dom=" . $domainStr . "&fol=" . rawurlencode($folderStr) . "&op=edit&item=" . rawurlencode(basename($file)) ;
        else
        {
          $targetBlankTag = " target=\"_blank\" "; /// so when you click on "other" files it goes to a new tab
          $dirLinkStrColor = 'RedText';
          $dirLinkStr = "dl.php?dom=" . $domainStr . "&fol=" . rawurlencode($folderStr) . "&op=view&item=" . rawurlencode(basename($file)) ;
        }
        
        $delLinkStr = ".?dom=" . $domainStr . "&fol=" . rawurlencode($folderStr) . "&op=delitem&item=" . rawurlencode(basename($file)) ;  

        $arrowLinkStr = "dl.php?dom=" . $domainStr . "&fol=" . rawurlencode($folderStr) . "&op=dl&item=" . rawurlencode(basename($file)) ;
        
        $filezRowsMarkup .= "
          <tr class=\"TableContent\">
					<td class=\"tdtext GreenText\"><p>" . date('Y-m-d H:i:s', filemtime($file)) . "</p></td>
					<td class=\"tdtext ".$dirLinkStrColor."\"><a href=\"" . htmlspecialchars($dirLinkStr) . "\"" . $targetBlankTag . "><h3 class=\"table_h3\">" . htmlspecialchars(basename($file)) . "</h3></a></td>
          <td><p><a href=\"" . htmlspecialchars($arrowLinkStr) . "\"><img src=\"CSS/down0000.png\"></a></p></td>          
					<td class=\"tdtext GreenText\"><p>" . $sizeFormatted . "</p></td>
          <td class=\"tdtext GreenText\"><p><a href=\"" . htmlspecialchars($delLinkStr) . "\"><img src=\"CSS/delicon.png\"></a></p></td>          
				  </tr>
        ";
      }
    }   
    
    $realPageMarkup = ''; // FINAL MARKUP BUILT HERE

    $topMsgString = 'Editing Note';

    $editFormTitleValue = ''; 
    $editFormContentsValue = ''; 
    $encodingLinkMarkup = '';
    // "Editng-a-Note" considerations
    if((strcmp($opStr, 'edit') === 0 || strcmp($opStr, 'edit1252') === 0) /*&& strlen($editItemStr) > 0*/)
    {
      $editFormTitleValue = htmlspecialchars($editItemStr);//htmlspecialchars(substr($editItemStr, 0, (strlen($editItemStr)-4))); // chop off the extension of the filename to edit
      
      if(strcmp('', $editItemStr) !== 0) // if we dont have an empty target, load up from file, 
      {
        if(strcmp($opStr, 'edit1252') === 0)// load from file processing as 1252
        {
          $editFormContentsValue = htmlspecialchars(iconv("windows-1252", "utf-8", file_get_contents($dataStr . $editItemStr))); // load and convert from 'windows'
        }
        else // load from file verbatim and make the 1252 link
        {
          $editFormContentsValue = htmlspecialchars(file_get_contents($dataStr . $editItemStr)); // load it under defaults (utf-8)
          $linkMeat = ".?dom=" . $domainStr . "&fol=" . rawurlencode($folderStr) . "&op=edit1252&item=" . rawurlencode($editItemStr) ;
          $encodingLinkMarkup = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" . htmlspecialchars($linkMeat) . "\">Reload with win-1252 enc</a>";
        }
      }
      
      // Delete Icon (only if something previously saved which we're editing)
      $deliconMarkup = '';
      if(strlen($editItemStr) > 0)
      {
        $deleteTargStr = ".?dom=" . $domainStr . "&fol=" . rawurlencode($folderStr) . "&op=delitem&item=" . rawurlencode(basename($editItemStr)) ;
        $deliconMarkup = "&nbsp;&nbsp;<a href=\"".$deleteTargStr."\"><img src=\"CSS/delicon.png\"></a>&nbsp;&nbsp;";
      }

      $ModMarkupStr = '';
      if(strlen($editItemStr) > 0)
        $ModMarkupStr = 'Modified : '.date('Y-m-d H:i:s', filemtime( $dataStr . $editItemStr )).' (Server Time '.date_default_timezone_get().')';

      $realPageMarkup = "
      <div align=\"center\">
      <table>
      <tr>
      <td>
      <div align=\"center\">
        <table class=\"addresstable\">
          <tr>
            <td height=\"8\">
            </td>
          </tr>
        
          <tr>
            <td>               
              <p class=\"address\">
                <strong>
                  <span class=\"RedText\">Listing </span>" . $listingSelectMarkup . "
                </strong>
              </p>
              <p class=\"address\">
                <strong>
                  <span class=\"RedText\">" . $linkedPathMarkup . "</span>
                </strong>
              </p>          
            </td>
          </tr>
        </table>
      </div>
      </td>
      </tr>
      </table>
      </div>
      
      <p class=\"YellowText\">
            " . $topMsgString . "
			</p>
			<br>
						<div id=\"editor\">
							<div id=\"editorContainer\">
              
                <form method=\"POST\" action=\"makenote.php\" accept-charset=\"UTF-8\" style=\"margin: 0px;\" >
                  Filename : <input type=\"text\" size=\"80\" maxlength=\"150\" name=\"title123\" value=\"" . $editFormTitleValue . "\"> ".$deliconMarkup." ".$encodingLinkMarkup."
                  <textarea rows=\"26\" cols=\"138\" name=\"textarea123\">" . $editFormContentsValue . "</textarea>
                  <input type=\"hidden\" name=\"dom\" value=\"" . $domainStr . "\">
                  <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                  
                  <input type=\"submit\" name=\"savepressed\" value=\"Save\" style=\"margin-top: 6px;\" />
                  ".$ModMarkupStr."
                  <br>
                  <input type=\"submit\" name=\"saveandclosepressed\" value=\"Save and Close\" style=\"margin-top: 6px;\" /> 
                </form>
                
                <form method=\"GET\" action=\".\" style=\"margin: 0px;\" >
                  <input type=\"hidden\" name=\"dom\" value=\"" . $domainStr . "\">
                  <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
                  
                  <input type=\"submit\" value=\"Close\" style=\"margin-top: 6px;\" /> 
                </form>
                
							</div>
						</div>		
            ";
    }
    else // show file directory tree and actions sections (NEUTRAL PAGINATION)
    {
      $realPageMarkup = "
      <div align=\"center\">
      <table>
      <tr>
      <td>
        <div align=\"center\">
          <table class=\"addresstable\">
            <tr>
              <td height=\"8\">
              </td>
            </tr>
          
            <tr>
              <td>               
                <p class=\"address\">
                  <strong>
                    <span class=\"RedText\">Listing </span>" . $listingSelectMarkup . "
                  </strong>
                </p>
                <p class=\"address\">
                  <strong>
                    <span class=\"RedText\">" . $linkedPathMarkup . "</span>
                  </strong>
                </p>          
              </td>
            </tr>
          </table>
        </div>
      </td></tr>
      <tr><td>
        <div align=\"center\" class=\"FileTableDiv\">		
          <table class=\"FilezTable\">
            <tr class=\"TableHeader\">
              <td>&nbsp;MOD DATE</td>
              <td>&nbsp;NAME</td>
              <td>&nbsp; </td>
              <td>&nbsp;SIZE</td>
              <td>&nbsp;DELETE</td>
            </tr>
        
            " . $filezRowsMarkup . "
            
          </table>
        </div>
      </td></tr>
      <tr><td>

        <div align=\"center\" style=\"font-size:10px;\">
          <p><strong><span class=\"GreenText\">Actions</span></strong></p>
          <br>
          <form method=\"GET\" action=\".\">
          <input type=\"hidden\" name=\"dom\" value=\"" . $domainStr . "\">
          <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
          <input type=\"hidden\" name=\"op\" value=\"edit\">
          <input type=\"hidden\" name=\"item\" value=\"\">
          <input type=\"submit\" value=\"Create New Note\" /> 
          </form>
          <form method=\"POST\" action=\"makefolder.php\" accept-charset=\"UTF-8\">
            <input type=\"hidden\" name=\"dom\" value=\"" . $domainStr . "\">
            <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
            Make New Folder : <input type=\"text\" size=\"40\" maxlength=\"64\" name=\"newfolder\">
            <input type=\"submit\" value=\"Create Folder Here\" /> 
          </form>
          <form action=\"upload_file.php\" method=\"POST\" enctype=\"multipart/form-data\">
            <input type=\"hidden\" name=\"dom\" value=\"" . $domainStr . "\">
            <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
            <input type=\"file\" name=\"userfile[]\" size=\"45\" multiple=\"multiple\" />
            <input type=\"submit\" name=\"submit\" value=\"Upload File(s)\" />
          </form>
        </div>
      </td></tr></table>
      </div>
      ";
    }
    
    // ECHO what has been constructed
    echo(GiveLayoutHeader($usernameStr) . "\r\n" . $realPageMarkup . "\r\n" . GiveLayoutFooter() );
  
  }
  
  // Called when you just want to send a message to the user, and allow them to return, ie. something went awry
  function Echo_MessageLayout($user, $domain, $folderStr, $dataFolderStr, $metaFolderStr, $titleStr, $messageStr)
  {
    echo(GiveLayoutHeader($user) . 
    "
    <br></ br>
      <div id=\"msgBox\">
        <div id=\"msgBoxContainer\">
          <p class=\"RedTextAlert\"><strong>" . $titleStr . "</strong></ p>
          <p class=\"GreenTextAlert\">" . $messageStr . "</ p>

          <p class=\"BottomText\">
            <strong>
              <span class=\"RedText\">[<a href=\".?dom=" . $domain . "&amp;fol=" . rawurlencode($folderStr) . "\">RETURN</a>]</span>
            </strong>
          </p>
          
        </div>
      </div>     
    "    
    . GiveLayoutFooter() );    
  } 
  
  function Echo_ConfirmDeleteLayout($user, $domain, $folderStr, $dataFolderStr, $metaFolderStr, $itemStr, $messageStr)  // reallydelitem
  {
    echo(GiveLayoutHeader($user) . 
    "
    <br></ br>
      <div id=\"msgBox\">
        <div id=\"msgBoxContainer\">
          <p class=\"RedTextAlert\"><strong>Warning!</strong></ p>
          <p class=\"GreenTextAlert\">" . $messageStr . "</ p>

          </br>
          <div align=\"center\">
            <form action=\".\" method=\"GET\">
              <input type=\"hidden\" name=\"dom\" value=\"" . $domain . "\">
              <input type=\"hidden\" name=\"fol\" value=\"" . htmlspecialchars($folderStr) . "\">
              <input type=\"hidden\" name=\"op\" value=\"reallydelitem\">
              <input type=\"hidden\" name=\"item\" value=\"" . htmlspecialchars($itemStr) . "\">
              <input type=\"submit\" value=\"DELETE\">
            </form>
          </div>
          
          <p class=\"BottomText\">
            <strong>
              <span class=\"RedText\">[<a href=\".?dom=" . $domain . "&amp;fol=" . rawurlencode($folderStr) . "\">CANCEL</a>]</span>
            </strong>
          </p>
          
        </div>
      </div>   
    "
    . GiveLayoutFooter() );    
  }    

  function ValidIndexOpItemString($op, $item)
  {
    if(is_string($op) && is_string($item) )
    {
      if(strcmp($op, 'delitem') === 0 || strcmp($op, 'reallydelitem') === 0 ) 
      {
        if(Noter_IsValidNewFilename($item))
          return true;
      }
      else if(strcmp($op, 'edit') === 0 || strcmp($op, 'edit1252') === 0 )
      {
        if(strcmp ('', $item) === 0 || Noter_IsValidNewFilename($item))
          return true;
      }
    }    
    return false;
  }
  
  // MAIN ===============================================
  
  if(!file_exists(Noter_GetDataFolderPath()) && !file_exists(Noter_GetMetaFolderPath())) // then we need to do a litte setting-up
  {
    header('Location: setup.php');
    exit(0); // no more execution
  }  
  
  // Locale, for basename, other fns, etc. 
  setlocale(LC_ALL, 'en_US.UTF-8');
  
  if(Noter_IsLoggedIn())
  {
    $userStrGlobal = Noter_GetUserName();  
    
    Noter_PrepUserDirs($userStrGlobal);
    
    $domainStrGlobal = 'pri'; // 'pri' or 'pub'
    $folderStrGlobal = '/';  // '/' or '/abc/' or '/abc/123/'
    
    //Derived from dom/folder
    $dataFolderStrGlobal = ''; // actual path on the system for data
    $metaFolderStrGlobal = ''; // actual path on the system for meta  
    
    //Override dom/folder defaults if curdir is there, which it usually will be.
    $curDirArr = Noter_GetCurDir();
    if(count($curDirArr) > 0)
    {
      $domainStrGlobal = $curDirArr[0];
      $folderStrGlobal = $curDirArr[1];
    }  

    /*if(0) //Debugging 
    {
      echo("<br>ARGUMENT DEBUGGING\r\n");
      echo("<br>folArg1&nbsp;&nbsp;&nbsp;&nbsp;" . $_GET['fol'] . "\r\n");
      echo("<br>folArg2&nbsp;&nbsp;&nbsp;&nbsp;" . rawurldecode($_GET['fol']) . "\r\n");
      echo("<br>itemArg1&nbsp;&nbsp;&nbsp;&nbsp;" . $_GET['item'] . "\r\n");
      echo("<br>itemArg2&nbsp;&nbsp;&nbsp;&nbsp;" . rawurldecode($_GET['item']) . "\r\n");
    }*/

    if($_GET && isset($_GET['dom']) && is_string($_GET['dom']))
      $domainStrGlobal = $_GET['dom'];

    if($_GET && isset($_GET['fol']) && is_string($_GET['fol']))
      $folderStrGlobal = $_GET['fol'];
      
    $bWasSanitized = Noter_SanitizeBaseArgs($userStrGlobal, $domainStrGlobal, $folderStrGlobal);
    
    // NOW AT THIS POINT WE KNOW THE $folderStrGlobal IS SAFE, EITHER BY NEVER HAVING BEEN SUPPLIED OR FAILING VALIDATION CHECK, or working
      
    Noter_SetDataMetaFolderStrings($userStrGlobal, $domainStrGlobal, $folderStrGlobal, $dataFolderStrGlobal, $metaFolderStrGlobal);  

    // This point is all thats needed for a neutral(browsing) pagination.
    
    // Set curdir user setting in Meta folder!
    Noter_SetCurDir($domainStrGlobal, $folderStrGlobal);
    
    // ================================================================================
    $operationStrGlobal = ''; // special op that may be supplied
    $itemStrGlobal = ''; // 1st param for operation
    
    if($_GET && isset($_GET['op']) && is_string($_GET['op']))
      $operationStrGlobal = $_GET['op'];

    if($_GET && isset($_GET['item']) && is_string($_GET['item']))
      $itemStrGlobal = $_GET['item'];
    
    if(ValidIndexOpItemString($operationStrGlobal, $itemStrGlobal))
    { 
      // now that input validators were passed, check to see if the "item" to "operate on" actually exists
      // meta may or may not, so dont require it
      if(Noter_ValidateFolderPath($dataFolderStrGlobal . $itemStrGlobal , $dataFolderStrGlobal) )
      {
        if( strcmp($operationStrGlobal, 'reallydelitem') === 0 ) // go ahead and really kill the file/folder + metas 
        {
          Noter_rrmdir($dataFolderStrGlobal . $itemStrGlobal );
          Noter_rrmdir($metaFolderStrGlobal . $itemStrGlobal );
          
          header('Location: .?dom=' . $domainStrGlobal . '&fol=' . rawurlencode($folderStrGlobal) );
        }
        else if( strcmp($operationStrGlobal, 'delitem') === 0 ) // delitem 
        {
          $statusMsgStr = 'Are you sure you want to delete <br>' . htmlspecialchars($itemStrGlobal) . '?';
          
          if(is_dir($dataFolderStrGlobal . DIRECTORY_SEPARATOR . $itemStrGlobal))
            $statusMsgStr = 'Are you sure you want to delete <br>' . htmlspecialchars($itemStrGlobal) . '<br>This item is a folder and all of its contents will also be permanently deleted!' ;

          Echo_ConfirmDeleteLayout($userStrGlobal, $domainStrGlobal, $folderStrGlobal, $dataFolderStrGlobal, $metaFolderStrGlobal, $itemStrGlobal, $statusMsgStr);
        }
        else if( strcmp($operationStrGlobal, 'edit') === 0 || strcmp($operationStrGlobal, 'edit1252') === 0 )
        {
            Echo_Layout($userStrGlobal, $domainStrGlobal, $folderStrGlobal, $dataFolderStrGlobal, $metaFolderStrGlobal, $operationStrGlobal, $itemStrGlobal ); 
        }
      }
      else // This is where we determine the Warning String we will construct for the user, we're going to the op page...
      {        
        $statusTitleStr = 'ERROR!';
        $statusMsgStr = "The specified item, " . htmlspecialchars($itemStrGlobal) . ", was not found!";
        Echo_MessageLayout($userStrGlobal, $domainStrGlobal, $folderStrGlobal, $dataFolderStrGlobal, $metaFolderStrGlobal, $statusTitleStr, $statusMsgStr);
      }
    }
    else // most basic pagination
    {
      Echo_Layout($userStrGlobal, $domainStrGlobal, $folderStrGlobal, $dataFolderStrGlobal, $metaFolderStrGlobal, '', ''); 
    }

    // ================================================================================

  }
  else // not logged in
  {
    header('Location: logon.php'); // goto login
  }
