<?php
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/
// Validate post args and set sess UserName var or show form to accept intput.
  include 'Fns.php';
  session_start();
  
  function Echo_Logon_Form($statusStr)
  {    
    //Cookie
    $nameOfCookie = Noter_GetLogonCookieName() ;
    $usernameCookieStr = '';
    if(isset($_COOKIE[$nameOfCookie]) && is_string($_COOKIE[$nameOfCookie]) && strlen($_COOKIE[$nameOfCookie]) > 0 ) 
      if( Noter_IsValidUsername($_COOKIE[$nameOfCookie]) )
        $usernameCookieStr = $_COOKIE[$nameOfCookie] ;
  
    echo("
    <html><head>
    <title>Noter v" .THE_VERSION. " (Logon)</title>
    <link rel=\"stylesheet\" type=\"text/css\" href=\"CSS/logonstyle.css\">
    </head>

    <body>
    <br>

    <div align=\"center\">

      <div class=\"soft-tbl-10\">

        <table>
        <TR><TD>

        <div align=\"center\">
        
        <img style=\"vertical-align:middle\" SRC=\"CSS/noterlogo.png\">
        
        <p>

        <FORM ENCTYPE=\"multipart/form-data\" ACTION=\"logon.php\" METHOD=\"POST\" NAME=\"login\">

        <img style=\"vertical-align:middle\" SRC=\"CSS/paddy.gif\"> <b>Log on</b>

        <br><font color=\"#FF0000\"><b>" . $statusStr . "</b></font>

        <p>Username: <INPUT NAME=\"user1\" SIZE=10 VALUE=\"" . htmlspecialchars($usernameCookieStr) . "\">

        <p>Password: &nbsp;<INPUT TYPE=PASSWORD NAME=\"pass1\" SIZE=10 VALUE=\"\">

        <p><INPUT TYPE=submit value=\"Logon\" name=j1 style=\"font-size:1.25em;\"><br><br> 
        </div>

        </table>

      </div>
    </div>

    </body>
    </html>
    ");
  }
  
  // if already logged on, redirect to root
  // example, for instance, you're logged on and you try to switch user, just go to root, you must logoff first, its more discrete 
  if(Noter_IsLoggedIn())
  {
    header('Location: .');
    exit(0);
  }
  
  // if we were sent something to validate, ideally from ourself
  if( $_POST && isset($_POST['user1'],$_POST['pass1'])  )
  {   
    // type check
    if( !(is_string($_POST['user1']) && is_string($_POST['pass1'])) )
    {
      Echo_Logon_Form('Error'); // possibly could get here if something was not sending as http...
      exit(1);
    }
    
    if( strlen($_POST['user1']) > 256 || strlen($_POST['pass1']) > 256 )
    {
      Echo_Logon_Form('Error Authenticating');
      exit(1);
    }

    $user = $_POST['user1'];
    $pass = $_POST['pass1'];    
    
    if(strlen($user) == 0 || strlen($pass) == 0)
    {
      Echo_Logon_Form('Error: Username/password is blank');   
      exit(1); 
    }
    
    // username validity
    if(!Noter_IsValidUsername($user))
    {
      Echo_Logon_Form('Error: Username contains illegal characters.');   
      exit(1); 
    }
    
    // usernames to lowercase
    $user = strtolower($user);
    
    if(Noter_EvalPassword($user, $pass))
    {
      session_regenerate_id(false); // move to a new session id (file) and dont delete the old...
      
      Noter_LogOnThisUser($user); // sets sess var
      
      //Cookie: sets the cookie which stores what user we are so as to autofill the username field upon the next logon
      setcookie(Noter_GetLogonCookieName(), $user);
      
      // Move them back to the index
      header('Location: .');
    }
    else // put them back on this page with a status
    {
      Echo_Logon_Form('Invalid username and/or password! Please try again.');   
    }
  }
  else 
  {
    Echo_Logon_Form(''); // Normal
  }
  
  ?>
  