<?php
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/
  include 'Fns.php';
  session_start();

  if(Noter_IsLoggedIn())
  {
    $domainStrGlobal = 'pri'; 
    $folderStrGlobal = '/';    
    $dataFolderStrGlobal = ''; 
    $metaFolderStrGlobal = ''; 
    $userStrGlobal = Noter_GetUserName();  
    $bSaveAndClose = false; // loop back to containing folder; false = loop back to editor with same document 

    // dom (domain) (pub)public or (pri)private
    if($_POST && isset($_POST['dom']) && is_string($_POST['dom']))
      $domainStrGlobal = $_POST['dom'];

    if($_POST && isset($_POST['fol']) && is_string($_POST['fol']))
      $folderStrGlobal = $_POST['fol'];  
    
    if($_POST && isset($_POST['saveandclosepressed']))
      $bSaveAndClose = true; 

    Noter_SanitizeBaseArgs($userStrGlobal, $domainStrGlobal, $folderStrGlobal);
    
    // NOW AT THIS POINT WE KNOW THE $folderStrGlobal IS SAFE
    
    Noter_SetDataMetaFolderStrings($userStrGlobal, $domainStrGlobal, $folderStrGlobal, $dataFolderStrGlobal, $metaFolderStrGlobal);  
    
// makenote specific
    $filenameStrGlobal = 'NewTextFile';
    $filetextStrGlobal = '';
    
    if($_POST && isset($_POST['title123']) && is_string($_POST['title123']) && Noter_IsValidNewFilename($_POST['title123']) )
      $filenameStrGlobal = $_POST['title123'];  

    if($_POST && isset($_POST['textarea123']) && is_string($_POST['textarea123']))
      $filetextStrGlobal = $_POST['textarea123'];  
    
    if(strlen($filenameStrGlobal) > 0 && strlen($filetextStrGlobal) > 0 ) // something to save
    {
      $actualFilenameWithExtensionStr = '';
      
      // only if theres no extension shall we add '.txt'
      $path_info1 = pathinfo($filenameStrGlobal);
      
      $path_info1_extension = ''; // default to no extension 
      
      if(isset($path_info1['extension']))
        $path_info1_extension = $path_info1['extension'] ;
      
      if( strcmp($path_info1_extension, '') === 0 )
      {
        // if the last char of name is a '.' then add 'txt, else add '.txt'
        if(substr($filenameStrGlobal, -1) == '.')
          $actualFilenameWithExtensionStr = $filenameStrGlobal . 'txt' ;
        else
          $actualFilenameWithExtensionStr = $filenameStrGlobal . '.txt' ;
        
        $dataOut = $dataFolderStrGlobal . $actualFilenameWithExtensionStr ;
        $metaOut = $metaFolderStrGlobal . $actualFilenameWithExtensionStr ;
      }
      else
      {
        $actualFilenameWithExtensionStr = $filenameStrGlobal ;
        
        $dataOut = $dataFolderStrGlobal . $actualFilenameWithExtensionStr  ;
        $metaOut = $metaFolderStrGlobal . $actualFilenameWithExtensionStr  ;
      }
      $outHandle = fopen($dataOut, 'w') or die("(makenote.php) Can not open file");
      fwrite($outHandle, $filetextStrGlobal) or die("(makenote.php) Could not write content to file!"); 
      fclose($outHandle); 

      // MIME and META files
      $theMimeType = my_mime_content_type($dataOut);
      CreateMetaFile($metaOut, $theMimeType);
      
      // Redirs (Save loops back; Save and Close goes to folder)
      if($bSaveAndClose)
        header('Location: .?dom=' . $domainStrGlobal . '&fol=' . rawurlencode($folderStrGlobal) );
      else // just save (loop back to editor)
        header('Location: .?dom=' . $domainStrGlobal . '&fol=' . rawurlencode($folderStrGlobal) 
          . '&op=edit' . '&item=' . rawurlencode($actualFilenameWithExtensionStr) );

      die();
    }
    header('Location: .?dom=' . $domainStrGlobal . '&fol=' . rawurlencode($folderStrGlobal) );
    die();
  }
  else
  {
    header('Location: logon.php'); // goto logon
    die();
  }
