<?php
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/
  include 'Fns.php';
  include 'AccountFns.php';
  
  
  function GetRandTail($len) 
  {
    if(!isset($len))
      $len = 16;
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';   
    $string = '';
    for ($i = 0; $i < $len; $i++) 
    {
      $string .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $string;
  }
  
  // rewrites the config with new lines changed...
  function ConfigWriter($sourceFilePath, $outputFilePath, $newDataDir, $newMetaDir, $instName, $saltValue)
  {
    $tempOutputFile = $outputFilePath . '.tmp';
    if(file_exists($tempOutputFile))
      unlink($tempOutputFile);
    
    $handleRead = fopen($sourceFilePath, "r");
    $handleWrite = fopen($tempOutputFile, 'w');
    if ($handleRead && $handleWrite) 
    {
      while (($lineStr = fgets($handleRead)) !== false)
      {
        // loops once per line from input
        $writeMe = '';
        
        if(strpos($lineStr, 'const NOTER_INST_NAME') !== false)          // instance Name
          $writeMe =        'const NOTER_INST_NAME = \'' . $instName . '\';' . "\r\n"; 
        else if(strpos($lineStr, 'const JUST_PASSWORD_SALT') !== false) 
          $writeMe =             'const JUST_PASSWORD_SALT = \'' . $saltValue . '\';'  . "\r\n"; // salt
        else if(strpos($lineStr, 'const DATA_CACHE_FOLDER') !== false) 
          $writeMe =             'const DATA_CACHE_FOLDER = \'' . $newDataDir . '\';' . "\r\n"; // data dir
        else if(strpos($lineStr, 'const META_CACHE_FOLDER') !== false) 
          $writeMe =             'const META_CACHE_FOLDER = \'' . $newMetaDir . '\';' . "\r\n"; //  meta dir
        else
          $writeMe = $lineStr; // write the line verbatim 
        
        fwrite($handleWrite, $writeMe);      
      }
      fclose($handleRead);
      fclose($handleWrite);
      
      shell_exec('mv ' . escapeshellarg($tempOutputFile) . ' ' . escapeshellarg($outputFilePath));
      shell_exec('chmod 775 ' . escapeshellarg($outputFilePath));    // rwxrwxr-x
      return true;
    }  
    return false;
  }
  
  function GenerateSetupLayout()
  {
    $cmdRows = '';
    
    $dirSuffix = GetRandTail(16);
    
    $markup="
    <div align=\"center\">
      <table width=\"500\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">

        <tr>
          <td height=\"64\" colspan=\"3\">
            <div align=\"center\">
              <h1 style=\"margin-bottom:0px;margin-top:0px;\">Noter</h1>
              <h3 style=\"margin-bottom:0px;margin-top:0px;\">v" . THE_VERSION . "</h3>
            </div>
          </td>
        </tr>

        <tr height=\"24\">
          <td colspan=\"3\">
          &nbsp;
          </td>
        </tr>

        <tr>
          <td height=\"48\" colspan=\"3\">
            <div align=\"center\">
              <h3 style=\"margin-bottom:0px;margin-top:0px;\">Setup Wizard</h3>
              <br> This first-time use wizard allows you to set passwords, rewrites \"Config.php\", and generates the data directories where user files/meta data are stored. <br> Settings can also be changed further via modification of \"Config.php\" afterwards.
            </div>
          </td>
        </tr>
        
        <tr height=24>
        </tr>
       
        <tr>
          <td width=\"440\">
            <div align=\"center\">
              <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
                <tr>
                  <td>
                    <form action=\"setup.php\" method=\"POST\" enctype=\"multipart/form-data\" TARGET=\"_parent\">
                      <p>&nbsp;
                      <p><b>Set 'admin' account password</b>
                      <p>
                      'admin' Password:&nbsp<input type=\"text\" name=\"pass1\" />
                      <p>
                      'admin' Password:&nbsp<input type=\"text\" name=\"pass2\" />(verify)
                      <p>&nbsp;
                      <p><b>Data Directory Locations (if unsure, leave as default)</b>
                      <p>
                      Data:&nbsp<input type=\"text\" size=\"30\" value=\"Data-" . $dirSuffix . "\" name=\"datfol\" />(contains uploaded files)
                      <p>
                      Meta:&nbsp<input type=\"text\" size=\"30\" value=\"Meta-" . $dirSuffix . "\" name=\"metfol\" />(metadata)
                      
                      <div align=\"center\">
                        <input type=\"submit\" value=\"Next\" />
                      </div>
                    </form> 
                  </td>
                </tr>
              </table>
            </div>
          </td>
        </tr>      
      </table>
    </div>
    ";
    
    echo ($markup);
  }
  
// MAIN Start
  if(file_exists('adminpw.temp'))
  {
    // 3.b This needed to be run during a second invocation of the script since Config.php needed to be reloaded. 
    $password = file_get_contents('adminpw.temp');
    unlink('adminpw.temp');
    
    //echo ("<br>Current Password File Path -> \"" . Noter_GetPasswordFile() . "\"\r\n");
    if(!file_exists(Noter_GetPasswordFile()))
    {
      touch(Noter_GetPasswordFile());
      echo ("<p>" . Noter_CreateUser('admin', $password) . "\r\n");
    }    
    
    echo("<p>
    <form action=\"setup.php\" method=\"GET\">
      <input type=\"submit\" value=\"Finish\" />
    </form>
    ");
  }
  else if(!file_exists(Noter_GetDataFolderPath()) && !file_exists(Noter_GetMetaFolderPath())) // then we need to do a litte setting-up
  {
    //Process Setup
    if($_POST && isset(
    $_POST['pass1'],
    $_POST['pass2'],
    $_POST['datfol'],
    $_POST['metfol']))
    {
      if(is_string($_POST['pass1']) && is_string($_POST['pass2']) && strcmp($_POST['pass1'], $_POST['pass2']) === 0 && strlen($_POST['pass1']) > 0 ) //passes match and are not blank
      {
        if(is_string($_POST['datfol']) && is_string($_POST['metfol']) ) // should do some validation but it should also be able to lie under any arbitrary path...
        {
          // 1. Create Data/Meta Folder
          //Make The Hub Directories
          $perms = 0775; 
          if(!mkdir($_POST['datfol'], $perms))
          {
            echo ("<br>Error: Unable to create Data directory! Check Permissions\r\n");
            exit(1);
          }
          if(!mkdir($_POST['metfol'], $perms))
          {
            echo ("<br>Error: Unable to create Meta directory! Check Permissions\r\n");
            exit(1);
          }
          // Make Pub/Users Directoreis
          if( !mkdir($_POST['datfol'] . DIRECTORY_SEPARATOR . 'Pub', $perms) || 
              !mkdir($_POST['datfol'] . DIRECTORY_SEPARATOR . 'Users', $perms) || 
              !mkdir($_POST['metfol'] . DIRECTORY_SEPARATOR . 'Pub', $perms) || 
              !mkdir($_POST['metfol'] . DIRECTORY_SEPARATOR . 'Users', $perms) )
          {
            echo ("<br>Error: Trouble encountered while creating subdirectories under Data and Meta folders. \r\n");
            exit(1);
          }          
          
          
          // 2. Set Config with Instname, Salt, Data, and Meta Folder values
          $instNameStr = 'Noter-' . GetRandTail(4) ;
          $saltStr = GetRandTail(16) ;
          if(ConfigWriter('Config.php', 'Config.php', $_POST['datfol'], $_POST['metfol'], $instNameStr, $saltStr) )
          {
            //echo("<br>Config Changed Sucessfully.\r\n");
          }   
          else
          {
            echo ("<br>Error: Trouble encountered while writing Config, check permissions. Terminating Setup. \r\n");
            exit(1);
          }
          
          // 3.a put pass in temp file          
          if ( !touch('adminpw.temp') || file_put_contents('adminpw.temp', $_POST['pass1']) === false )
          {
            echo("<br>Error: Could not create a temp file in current Noter working directory.\r\n");
            exit(1);
          }

          opcache_invalidate('Config.php'); // it was fun finding out that this was needed...

          header('Location: setup.php'); 
        }
        else
          echo("Error: The supplied directory names are illegal.");
      }
      else
        echo("Error: The Passwords do not match or are blank.");
    }
    else // Display Layout
    {
      GenerateSetupLayout();
    }    
  }
  else
    header('Location: .'); // goto root
  
  ?>