<?php
/*
*     License:  This  program  is  free  software; you can redistribute it and/or
*     modify it under the terms of the GNU General Public License as published by
*     the  Free Software Foundation; either version 3 of the License, or (at your
*     option)  any later version. This program is distributed in the hope that it
*     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
*     Public License for more details.
*/
  include 'Fns.php';
  session_start();

  if(Noter_IsLoggedIn())
  {
    //START
    $userStrGlobal = Noter_GetUserName(); 

    session_write_close();// No Session-dependant calls after here
    
    // Ignore user aborts and allow the script
    // to run forever
    ignore_user_abort(true);
    set_time_limit(0);

    if( !($_POST && isset($_POST['dom'],$_POST['fol'])))
    {
      echo ("<br>ERROR: Argument list incomplete.");
      exit(1);
    }
    
    $domainStrGlobal = 'pri'; // 'pri' or 'pub'
    $folderStrGlobal = '/';  // '/' or '/abc/' or '/abc/123/'
    
    //Derived from dom/folder
    $dataFolderStrGlobal = ''; // actual path on the system for data
    $metaFolderStrGlobal = ''; // actual path on the system for meta  

    if($_POST && isset($_POST['dom']) && is_string($_POST['dom']))
      $domainStrGlobal = $_POST['dom'];

    if($_POST && isset($_POST['fol']) && is_string($_POST['fol']))
      $folderStrGlobal = $_POST['fol'];
      
    $bWasGoodFolder = Noter_SanitizeBaseArgs($userStrGlobal, $domainStrGlobal, $folderStrGlobal);
    
    if (!$bWasGoodFolder) // dont' just dump the files in root if the folder string is bad.
    {
      echo ("<br>ERROR: Supplied path incorrect!");
      exit(1);
    }
    
    // NOW AT THIS POINT WE KNOW THE $folderStrGlobal IS SAFE, EITHER BY NEVER HAVING BEEN SUPPLIED OR FAILING VALIDATION CHECK, or working
    Noter_SetDataMetaFolderStrings($userStrGlobal, $domainStrGlobal, $folderStrGlobal, $dataFolderStrGlobal, $metaFolderStrGlobal);  


//upload_file specific
    $ErrorString = '';
    // Loop through each file (per-file upload loop)
    // ===============================================================================================================
    for($i=0; $i<count($_FILES['userfile']['name']); $i++)
    {
      $tmpFilePath = $_FILES['userfile']['tmp_name'][$i]; // where its stored currently, usually "/tmp/randomname"

      if ($tmpFilePath != '' && ($_FILES["userfile"]["size"][$i] > 0))//Make sure we have a filepath and some size!
      {
        $path_info1 = pathinfo($_FILES["userfile"]["name"][$i]);
        $path_info1_extension = strtolower($path_info1['extension']) ;
        $path_info1_filename = $path_info1['filename']; 
        
        if (strcasecmp("PHP", $path_info1['extension']) == 0) // no .phps allowed
        {
          $ErrorString .= "<br>Disallowed Extension: " . $_FILES["userfile"]["name"][$i] ;
          continue; 
        }
        
        if ($_FILES["userfile"]["error"][$i] > 0) // any errors in the associative array.
        {
          $ErrorString.="<br>Return Code:&nbsp;".$_FILES["userfile"]["error"][$i]."&nbsp;&nbsp;File:&nbsp;&nbsp;".$_FILES["userfile"]["name"][$i] ;
          continue;
        }
        else
        {
          if(0) // degugging
          {
            echo "<p>";
            echo "Upload: " . $_FILES["userfile"]["name"][$i] . "<br />";
            echo "Type: " . $_FILES["userfile"]["type"][$i] . "<br />";
            echo "Size: " . ($_FILES["userfile"]["size"][$i] / 1024) . " Kb<br />";
            echo "Temp file: " . $_FILES["userfile"]["tmp_name"][$i] . "<br />";
          }
          //echo (">>>>" . $_FILES["userfile"]["name"][$i]);
          //exit(1);
          $bValidOriginalFilename = Noter_IsValidNewFilename($_FILES["userfile"]["name"][$i]);
          
          $finalFilename = '' ;
          if($bValidOriginalFilename)
            $finalFilename = $path_info1_filename;
          else
            $finalFilename = 'NewFile';
          
          $finalExtension = '';
          if(strlen($path_info1_extension) > 0)
            $finalExtension = '.' . $path_info1_extension ;
          
          $finalFilename = Noter_NameAdjuster($dataFolderStrGlobal, $finalFilename, $finalExtension ) ;
          
          $finalFilePath = $dataFolderStrGlobal . $finalFilename . $finalExtension  ;            

          move_uploaded_file($_FILES["userfile"]["tmp_name"][$i], $finalFilePath);
          
          // MIME and META files
          $finalMetaFilePath = $metaFolderStrGlobal . $finalFilename . $finalExtension  ;
          $theMimeType = my_mime_content_type($finalFilePath);
          CreateMetaFile($finalMetaFilePath, $theMimeType);          
          
          if(!$bValidOriginalFilename)
          {
            $ErrorString.="<br><b>". htmlspecialchars($_FILES["userfile"]["name"][$i]) . "</b> Contains Illegal Characters, renaming to <b>" . htmlspecialchars($finalFilename . $finalExtension) . "</b>" ;
          }
        }
      }
    } // end of per-file loop...
    
    if( strlen($ErrorString) > 0 ) // had errors
    {
      echo ("<h3>Error Summary</h3><p>");
      echo ($ErrorString); // crude page, but for now summarizes everything
      $lnk = ".?dom=" . $domainStrGlobal . "&fol=" . rawurlencode($folderStrGlobal);
      echo ("<p><a href=\"" . htmlspecialchars($lnk) . "\">Return</a>");
    }
    else // good one
      header('Location: .?dom=' . $domainStrGlobal . '&fol=' . rawurlencode($folderStrGlobal) );    
  }
  else
  {
    header('Location: logon.php'); // goto logon
  }
  
?>