<?php

  /*
  *     License:  This  program  is  free  software; you can redistribute it and/or
  *     modify it under the terms of the GNU General Public License as published by
  *     the  Free Software Foundation; either version 3 of the License, or (at your
  *     option)  any later version. This program is distributed in the hope that it
  *     will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  *     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
  *     Public License for more details.
  */

  // JOFLA.NET 2023

  // SWAPhp (The simplest multi-user realtime text swapping notepad window knockoff.)

  const THE_VERSION = 'v0.5';

  const THE_FILE = 'cache.file';

  // program drops a file (THE_FILE) in the current folder, if current folder isn't read/writable bail.
  // TODO: maybe this should be in /tmp
  if(strpos(THE_FILE, DIRECTORY_SEPARATOR) === false) // doesnt contain a dir separator, so local
    $cur_dir = dirname(__FILE__); // cant use "THE_FILE" here cause it may be relative and not yet exist so realpath() fails
  else
    $cur_dir = dirname(THE_FILE);

  if(!is_readable($cur_dir) || !is_executable($cur_dir) || !is_writable($cur_dir))
    die("ERROR: directory for cache file '" . THE_FILE . "' is not readable/writable/executable, Please Fix!");

  function PrintPage()
  {
    echo("
      <!DOCTYPE html>
      <html>
        <head>
          <meta charset=\"UTF-8\">

          <title>SWAPhp</title>

          <script src=script.js defer></script>

          <style>
            html {
              font-size: 70.0%; }
            body {
              font-size: 1.5em;
              line-height: 1.6;
              font-weight: 400;
              font-family: \"HelveticaNeue\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;
              color: #2ad;
              background: #000; }
            textarea {

              outline: none !important;
              border:1px solid green;
              box-shadow: 0 0 10px #719ECE;

              color: #fff;
              background: #111; }
          </style>

        </head>

        <body>

        <div>
          <h3> SWAPhp ".THE_VERSION." <div id=\"statusdivtop\" style=\"float:right;\"></div></h3>


        </div>

          <textarea rows=\"32\" cols=\"999\" name=\"maintextarea\" id=\"maintextarea\" style=\"max-width:99%;\"></textarea>

          <div id=\"statusdivbottom\"></div>

        </body>
      </html>
      ");
  }

  function PrintErroneousJSON()
  {
    echo(
      json_encode(
        Array
        (
          "err"  => "1",
          "time" => "",
          "size" => "",
          "data" => ""
        ),
      JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT
      )
    );
  }

  function IsInteger($inStr)
  {
    if(
      is_string($inStr) &&
      (strcmp($inStr, strval(intval($inStr))) === 0) &&
      (intval($inStr) >= 0)
    )
      return true;
    return false;
  }

  function GetCacheModTime()
  {
    if(!is_file(THE_FILE))
      touch(THE_FILE);

    return filemtime(THE_FILE);
  }

  function GetCacheContents()
  {
    if(!is_file(THE_FILE))
      touch(THE_FILE);

    return file_get_contents(THE_FILE);
  }


// =======================================================================================================================
// ======== MAIN =========================================================================================================
// =======================================================================================================================

  if ($_SERVER['REQUEST_METHOD'] === 'POST') // UPDATING
  {
    $raw_body = file_get_contents('php://input');

    if(strlen($raw_body) <= (1024*1024*5)) // 5 meg filesize limit.
    {

      $data = json_decode($raw_body, true);

      $last_err = json_last_error();
      if(($last_err === JSON_ERROR_NONE) && isset($data['data']))
      {

        $uniqueSeedStr =
          strval(
            md5(time() . '.' . rand(100000000, 999999999))
          );

        $tempName = THE_FILE . '.' . $uniqueSeedStr . '.TEMP';

        if(file_put_contents($tempName, $data['data'], LOCK_EX) !== false)
        {
          if(rename($tempName, THE_FILE) === true) // rename is atomic
          {
            // success code path (original)
            echo(
              json_encode(
                Array
                (
                  "err"  => "0",
                  "time" => GetCacheModTime(),
                  "size" => filesize(THE_FILE),
                  "data" => "" //  no data since we've just updated it.
                ),
              JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT
              )
            );
          }
          else
          {
            error_log("Error: Failed to move (".$tempName.") to (".THE_FILE.").");
            PrintErroneousJSON();
          }
        }
        else
        {
          error_log("Error: file_put_contents() Failed on (".$tempName.").");
          PrintErroneousJSON();
        }
      }
      else
      {
        error_log("Error: POST data wasn't correct JSON or map key incorrect. (JSON ERR CODE $last_err)");
        PrintErroneousJSON();
      }
    }
    else
    {
      error_log("Error: POST data was too large.");
      PrintErroneousJSON();
    }
  }
  else
  if(isset($_GET['sync']) && is_string($_GET['sync'])) // SYNCHRONIZING
  {
    $syncParam = '';

    if(strlen($_GET['sync']) > 0)
    {
      if(IsInteger($_GET['sync'])) /* && preg_match() */
      {
        $syncParam = $_GET['sync'];

        // if the supplied syc val is less than (happened before) the sync on our current file, then send the new one, else send empty json.

        if($syncParam < GetCacheModTime())
        {
          //header("Content-Encoding: none"); // for testing disable compression
          echo(
            json_encode(
              Array
              (
                "err"  => "0",
                "time" => GetCacheModTime(),
                "size" => filesize(THE_FILE),
                "data" => GetCacheContents()
              ),
            JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT
            )
          );
        }
        else // NO CHANGES ON SERVER, SEND EMPTY FIELDS
        {
          echo(
            json_encode(
              Array
              (
                "err"  => "0",
                "time" => "",
                "size" => "",
                "data" => ""
              ),
            JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT
            )
          );
        }
      }
    }
  }
  else
  {
    PrintPage();
  }
