
  // JOFLA.NET 2023

  // SWAP main script file

  // everythings in seconds
  var updateInterval = 3; // how often we push pull

  var bEditsMade = false; // has SOME editing taken place...

  var lastTimestamp = 0; // epoch we last synce'd on


  function sleep(ms)
  {
    return new Promise(resolve => setTimeout(resolve, ms));
  }


  function StatusTopMessage(message, bFleeting) // call-in point.
  {
    StatusTopAppear(message);

    if(bFleeting)
    {
      sleep(2000).then(() => { StatusTopVanish(); });
    }
  }

  function StatusTopAppear(message)
  {
    var statusdivtop = document.getElementById("statusdivtop");

    statusdivtop.style.display = "block";

    statusdivtop.innerHTML = message;
  }

  function StatusTopVanish()
  {
    var statusdivtop = document.getElementById("statusdivtop");

    statusdivtop.style.display = "none";

    statusdivtop.innerHTML = "";
  }

  function eraseText()
  {
    document.getElementById("maintextarea").value = "";
  }

  function GetCurSec()
  {
    return parseInt( Date.now() / 1000 , 10); // current second, matches php's time()
  }

  function updateTextArea()
  {
    bEditsMade = true;
  }

  // BOTTOM STATUS
  // code = 0, good
  // code = 1, error
  function SetStatus(code, time, sizeBytes, forcedStringMsg)
  {
    if(forcedStringMsg === "")
    {
      document.getElementById("statusdivbottom").innerHTML =

      "Last Updated: " + (new Date(time * 1000)) + " (" + time + ")<br>" +
      "Size: " + sizeBytes + " (bytes)"
      ;
    }
    else
    {
      document.getElementById("statusdivbottom").innerHTML = forcedStringMsg;
    }
  }

  function Sync()
  {
    if(bEditsMade)
    {
      StatusTopMessage(" Updating.... ", false);

      // push the whole textarea to the server

      var pushme = document.getElementById("maintextarea").value

      // xhr
      var params = "";
      params = "?update=";
      var xhttp = new XMLHttpRequest();
      xhttp.open("POST", "." + params, true);
      xhttp.setRequestHeader("Content-Type", "application/json;charset=UTF-8");

      xhttp.onload = function () {

        bEditsMade = false;

        // update the time to the time we recieved response that we updated the server! sheesh, errors (TODO)
        var ResponseJSON = JSON.parse(xhttp.responseText);
        if(ResponseJSON["err"] == "0")
        {
          lastTimestamp = ResponseJSON["time"];

          SetStatus(0, ResponseJSON["time"], ResponseJSON["size"], "");
          StatusTopMessage(" Sent Update ✅ ", true);
        }
        else
        {
          SetStatus(1, 0, 0, "ERROR: Unable to Update Server, check error log.");
          StatusTopMessage(" ERROR ❗ ", false);
        }
      };
      xhttp.send(JSON.stringify({ "data": pushme }));

    }
    else
    {
      // just get current timestamp and tell server, if server's update is later,
      // expect a payload returned, else nothing new happened.

      // xhr
      var params = "";
      params = "?sync=" + lastTimestamp;
      var xhttp = new XMLHttpRequest();
      xhttp.open("GET", "." + params, true);

      xhttp.onload = function () {

        var ResponseJSON = JSON.parse(xhttp.responseText);

        if(ResponseJSON["time"] > lastTimestamp) // update only if server is 'later'
        {
          document.getElementById("maintextarea").value = ResponseJSON["data"];

          lastTimestamp = ResponseJSON["time"];

          SetStatus(0, ResponseJSON["time"], ResponseJSON["size"], "");
          StatusTopMessage(" Received Update 🚩 ", true);
        }

      };
      xhttp.send(); // execute
    }
  }

  // ======== MAIN ========

  eraseText(); // on load clear it

  Sync();

  var area = document.getElementById('maintextarea');
  if (area.addEventListener) {
    area.addEventListener('input', function() {
      updateTextArea();
    }, false);
  }

  var intervalHandle = setInterval(Sync, updateInterval * 1000); // time milliseconds
