<?php

  // Vanilla Poll App 
  // Joe Flamand

  include 'Poll.class.php';

  // Fns
  
  function PollFolderPath()
  {
    return 'polls';
  }
  
  function GenInit()
  {
    TouchPollFolder();
    
     // Create Poll with initial ID for Sanity Testing
    if(!is_file(PollFolderPath() . DIRECTORY_SEPARATOR . '00000001'))
    {
      $question = 'Is the derivative share requirement indexed according to cost and percentage analysis?';
      $firstPoll = new Poll(false, ReturnNextPollSequenceNumber(), 'Sample Poll', $question, Array('yes','no'), 'SYSTEM');
      $firstPoll->Marshallize();
    } 
  }
  
  function TouchPollFolder()
  {
    $targ = PollFolderPath();
    if(!is_dir($targ))
      mkdir($targ, 0777);
  }
  
  // (R) Return An Array of Poll Objects unserialized 
  function GetAllPolls()
  {
    $retArr = Array();
    $filesArr = glob(PollFolderPath() . DIRECTORY_SEPARATOR . '*');
    foreach($filesArr as $file)
    {
      if(is_file($file))
      {
        $basename = basename($file);
        $newPoll = new Poll(true, $basename);
        
        if(!$newPoll->bLoaded)
        {
          error_log("Error: Could not load Poll " . $basename);
          continue;
        }
        
        $retArr[] = $newPoll;
      }
    }
    return $retArr;
  }
  
  function ReturnNextPollSequenceNumber() // store the number in a file in local directory
  {
    $filename = 'pollidcounter';
    $retID = 0;
    
    if(!is_file($filename)) // then it was the same as if there was a file there with '00000000' inside
    {
      $retID = 1;
      file_put_contents($filename, 2);
    }
    else
    {
      $retID = intval(file_get_contents($filename));
      unlink($filename);
      file_put_contents($filename, ($retID + 1));
    }
    return PollIDToSequenceNumber($retID);
  }
  
  function PollIDToSequenceNumber($id)
  {
    return str_pad(strval($id), 8, '0', STR_PAD_LEFT);
  }
  
  function IsValidPollID($inStr)
  {
    if((strlen($inStr) == 8) && preg_match('/^\d+$/', $inStr))
      return true;
    else 
      return false;
  }
  
  function UserCookieName()
  {
    return 'userpollcookie';
  }
  function GenerateNewUserCookieValueString()
  {
    return strval(bin2hex(openssl_random_pseudo_bytes(32)));
  }
  function IsValidCookieValue($strIn)
  {
    if(ctype_xdigit($strIn))
      return true;
    else
      return false;
  }
  function AssesUserCookie() // if currently supplied, it validates it and returns it, if not i'll make a new one and return it 
  {
    $retValStr = '';
    
    $nameOfCookie = UserCookieName();
    
    if(
      isset($_COOKIE[$nameOfCookie]) && 
      is_string($_COOKIE[$nameOfCookie]) && 
      (strlen($_COOKIE[$nameOfCookie]) > 0) && 
      IsValidCookieValue($_COOKIE[$nameOfCookie])
    )
    {
      return $_COOKIE[$nameOfCookie]; // what was passed-in was fine 
    }
    else // generate a new valid one and set it and return it 
    {
      $newVal = GenerateNewUserCookieValueString();
      setcookie( $nameOfCookie , $newVal , time() + (3600 * 24 * 180) , '/', '', isset($_SERVER["HTTPS"]), true ); // send new cookie back to user 
      return $newVal;
    }
  }
  