<?php

  // Vanilla Poll App 
  // Joe Flamand

  // Poll Class
  
  class Poll
  {
    var $bLoaded; // denotes successful loading 
    
    var $pollGUID; // which id number (filename) is this poll? 
    var $pollPath; // realpath to file
    
    // serializeable fields
    var $titleStr; // shown in the polls index 
    var $questionStr;
    var $answersArr; // array of strings denoting poll answer options
    var $usersArr; // 'userGUID' => 'answerID' (where answer id is the index into answersArr)
    var $makerID; // 'userGUID' who created poll 
    
    function __construct($bFromDisk, $diskPollNumber, $title = '', $question = '', $ansArr = array(), $maker = '')
    {
      $this->bLoaded = false; // initialize to invalid state 
      
      // Format Poll number if needed...
      if(!IsValidPollID($diskPollNumber))
        $diskPollNumber = PollIDToSequenceNumber($diskPollNumber);
      
      $this->pollGUID = $diskPollNumber; // even though it initializes to whats fed in doesnt mean it'll validly load 
      $this->pollPath = getcwd() . DIRECTORY_SEPARATOR . 'polls' . DIRECTORY_SEPARATOR . $diskPollNumber; 
      
      $this->titleStr = '';
      $this->questionStr = '';
      $this->answersArr = Array(); 
      $this->usersArr = Array();
      $this->makerID = '';
      
      if($bFromDisk) // we're loading from disk
      {
        if(is_file($this->pollPath))
          $this->UnMarshallize($this->pollPath);
        else
          error_log("ERROR: Non-Existant Poll#: " . $diskPollNumber);
      }
      else // creating for first time
      {
        $this->titleStr = $title;
        $this->questionStr = $question;
        $this->answersArr = $ansArr;
        $this->makerID = $maker;
        
        $this->bLoaded = true;
      }
      
      if(isset($_GET['debug']))
      {
        echo("<pre>");
        print_r($this);
        echo("</pre>");
      }
    }
    
    function __destruct()
    {
    }
    
    function UnMarshallize($pathStr) // loads 'this' from disk 
    {
      if(($readData = file_get_contents($pathStr)) !== false)
      {
        $arr1 = unserialize($readData);
        
        if(is_array($arr1))
        {
          if(
            isset($arr1['title']) && 
            isset($arr1['question']) && 
            isset($arr1['answers']) && 
            isset($arr1['users']) && 
            isset($arr1['maker']) 
          )
          {
            if(!is_array($arr1['answers'])){
              $arr1['answers'] = Array(); // empty array
              error_log("answers was empty!");
            }
            if(!is_array($arr1['users'])){
              $arr1['users'] = Array(); // empty array
              error_log("users was empty");
            }
            
            $this->titleStr = $arr1['title'];
            $this->questionStr = $arr1['question'];
            $this->answersArr = $arr1['answers'];
            $this->usersArr = $arr1['users'];
            
            $this->makerID = $arr1['maker'];
            
            $this->bLoaded = true;
          }
          else
            error_log("Couldn't Unserialize Correctly!");
        }
      }
    }
    
    function Marshallize() // writes 'this' to disk
    {
      if($this->bLoaded)
      {
        $pathStr = $this->pollPath;
        
        if(file_exists($pathStr))
          unlink($pathStr);
      
        $serArr = Array();
        $serArr['title'] = $this->titleStr;
        $serArr['question'] = $this->questionStr;
        $serArr['answers'] = $this->answersArr;
        $serArr['users'] = $this->usersArr;
        $serArr['maker'] = $this->makerID;
        
        file_put_contents($pathStr, serialize($serArr));
      }
    }
    
    function PrintOut($bEcho = false)
    {
      $contents = "Poll " . print_r($this, true);
      if($bEcho)
      {
        echo("<pre>\r\n");
        echo($contents);
      }
      else
        error_log($contents);
    }
    
    function TouchUser($userStr, $answerID) // ret true (users voting 1st time), false (changing thier vote)
    {
      $bFirstTime = true;
      if(isset($this->usersArr[$userStr]))
        $bFirstTime = false;
        
      $this->usersArr[$userStr] = $answerID;
        
      return $bFirstTime;
    }
    
    function IsValidAnswerID($inStr) // if the supplied is a valid key to an existing answer of the answers array
    {
      if(isset($this->answersArr[$inStr]))
        return true;
      else
        return false;
    }
  }