<?php

  // Vanilla Poll App 
  // Joe Flamand

  include 'Fns.php';
  
  GenInit(); // general initializer
  
  $cookieValStr = AssesUserCookie();
  
  // POST handlers
  if(
    isset($_POST['pollid']) && 
    is_string($_POST['pollid']) && 
    IsValidPollID($_POST['pollid']) &&
    isset($_POST['answerid']) && 
    is_string($_POST['answerid'])
  ) // update user's answer
  {
    $answerID = $_POST['answerid'];
    $id = $_POST['pollid'];    
    $poll = new Poll(true, $id);
    if($poll->bLoaded && $poll->IsValidAnswerID($answerID))
    {
      $poll->usersArr[$cookieValStr] = $answerID;
      $poll->Marshallize();
    }
    header('Location: .?pollid=' . $id); // back to poll page
    die();
  }
  else
  if(isset($_POST['create'])) // create
  {
    if( // minimum necessary fields (title/question/firstanswer)
      isset($_POST['title']) && 
      is_string($_POST['title']) && (strlen($_POST['title']) > 0) &&
      isset($_POST['question']) && 
      is_string($_POST['question']) && (strlen($_POST['question']) > 0) &&
      isset($_POST['ans1']) && 
      is_string($_POST['ans1']) && (strlen($_POST['ans1']) > 0)
    )
    {
      $newTitle = $_POST['title'];
      $newQuestion = $_POST['question'];
      $ansArr = Array($_POST['ans1']);
      
      // optional additional answers
      if(isset($_POST['ans2']) && is_string($_POST['ans2']) && (strlen($_POST['ans2']) > 0))
        $ansArr[] = $_POST['ans2'];
      if(isset($_POST['ans3']) && is_string($_POST['ans3']) && (strlen($_POST['ans3']) > 0))
        $ansArr[] = $_POST['ans3'];
      if(isset($_POST['ans4']) && is_string($_POST['ans4']) && (strlen($_POST['ans4']) > 0))
        $ansArr[] = $_POST['ans4'];
      if(isset($_POST['ans5']) && is_string($_POST['ans5']) && (strlen($_POST['ans5']) > 0))
        $ansArr[] = $_POST['ans5'];
      
      $poll = new Poll(false, ReturnNextPollSequenceNumber(), $newTitle, $newQuestion, $ansArr, $cookieValStr);
      $poll->Marshallize();
    }
    
    header('Location: .'); // back to home
    die();
  }
  else
  if(
    isset($_POST['delete']) && 
    isset($_POST['pollid']) && 
    is_string($_POST['pollid']) && 
    IsValidPollID($_POST['pollid'])
  ) // delete
  {
    $poll = new Poll(true, $_POST['pollid']);
    if($poll->bLoaded)
    {
      if(is_file($poll->pollPath))
        unlink($poll->pollPath);
    }
    header('Location: .'); // back to home
    die();
  }
  
  // Read 
  
  // header
  echo("
  <!DOCTYPE html>
  <html lang=\"en-US\">
  <head>
  <meta charset=\"utf-8\">
  <title>Poll Application Program</title>
  </head>
  <body>
  ");
  
  // Paginations
  if(isset($_GET['delpage']) && isset($_GET['pollid']) && is_string($_GET['pollid']) && IsValidPollID($_GET['pollid']))
  {
    $poll = new Poll(true, $_GET['pollid']);
    $pollTitle = $poll->titleStr;
    
    if(strcmp($cookieValStr, $poll->makerID) === 0)
    {
      // Delete Page
      $markup = "
      <h3>Delete Poll</h3>
        <form action=\".\" method=\"POST\" accept-charset=\"UTF-8\">
          <input type=\"hidden\" name=\"delete\" value=\"\">
          <input type=\"hidden\" name=\"pollid\" value=\"".$_GET['pollid']."\">
          <i>Are you sure you want to delete the poll titled \"".$pollTitle."\"</i>
          <p>
          <input type=\"submit\" value=\"Delete Poll\">
        </form>
      
      ";
    }
    else
      $markup = "You are not authorized to delete this poll. ";
    echo($markup);
    echo("<p><a href=\".\">Return Home</a>");
  }
  else
  if(isset($_GET['pollid']) && is_string($_GET['pollid']) && IsValidPollID($_GET['pollid'])) // display specific poll 
  {
    $bShowRes = false; // if you've voted, show results 
    
    $id = $_GET['pollid'];
    $poll = new Poll(true, $id);
    
    if($poll->bLoaded)
    {
      $whichID = false;
      if(isset($poll->usersArr[$cookieValStr])) // we've answered already, fill in whichever one
      {
        $whichID = $poll->usersArr[$cookieValStr];
        
        // Create Result tally array
        $tallyArr = Array(); // [answerid] => [number of votes]
        foreach($poll->usersArr as $item) 
        {
          if(!isset($tallyArr[$item]))
            $tallyArr[$item] = 1;
          else
            $tallyArr[$item] = $tallyArr[$item] + 1;
        }
        
        $bShowRes = true;
      }
      
      // create radio buttons
      if($bShowRes)
        $radioMarkup = "        <table><tr><td><b>Answers:</b></td><td><b>Results:</b></td></tr>\r\n";
      else
        $radioMarkup = "        <table><tr><td><b>Answers:</b></td><td></td></tr>\r\n";
        
      $numAnswers = count($poll->usersArr); // num people answered
      foreach($poll->answersArr as $key => $answer)
      {
        $resMarkup = '';
        if($bShowRes)
        {
          if(!isset($tallyArr[$key])) // zero votes
            $resMarkup = ' <i>0 Votes 0.00%</i>';
          else
            $resMarkup = ' <i>' . $tallyArr[$key] . ' Votes '. round(((intval($tallyArr[$key])/intval($numAnswers))*100), 2) .'%</i>';
        }
        
        $checkedStr = '';
        if(($whichID !== false) && ($key == $whichID)) // check the answer we submitted for last time
          $checkedStr = " checked=\"checked\""; // set check

        $radioMarkup .= "        <tr><td><input type=radio name=answerid value=".htmlspecialchars($key) . $checkedStr . ">".htmlspecialchars($answer).'</td><td>'. $resMarkup . "</td><tr>\r\n";
      }
      $radioMarkup .= '        </table>';
      
      $markup = "
        <h3>" . htmlspecialchars($poll->titleStr) . "</h3>
        <p><b>Question:</b> " . htmlspecialchars($poll->questionStr) . "
        
        <form action=\".\" method=\"POST\" accept-charset=\"UTF-8\">
          <input type=\"hidden\" name=\"pollid\" value=\"" . $poll->pollGUID . "\">  
".$radioMarkup."
          <p>
            <input type=\"submit\" value=\"Submit Vote\">
        </form>
        
        <p><a href =\".\">Home</a>
      ";
      echo($markup);
    }
    else
    {
      echo("<h3>Error: Could not load this poll. ID: <i>".$id."</i></h3>");
      echo("<p><a href=\".\">Return Home</a>");
    }
  }
  else
  if(isset($_GET['createpage']))
  {
    // Create New Poll Form
    $newPollFormMarkup = "
    <h3>Create New Poll</h3>
      <form action=\".\" method=\"POST\" accept-charset=\"UTF-8\">
        <input type=\"hidden\" name=\"create\" value=\"\">
        <table>
          <tr><td>Title:</td><td><input type=\"text\" name=\"title\" value=\"\"></td></tr>
          <tr><td>Question:</td><td><input type=\"text\" name=\"question\" value=\"\"></td></tr>
          <tr><td>Answer 1:</td><td><input type=\"text\" name=\"ans1\" value=\"\"></td></tr>
          <tr><td>Answer 2:</td><td><input type=\"text\" name=\"ans2\" value=\"\"></td></tr>
          <tr><td>Answer 3:</td><td><input type=\"text\" name=\"ans3\" value=\"\"></td></tr>
          <tr><td>Answer 4:</td><td><input type=\"text\" name=\"ans4\" value=\"\"></td></tr>
          <tr><td>Answer 5:</td><td><input type=\"text\" name=\"ans5\" value=\"\"></td></tr>
        </table>
        <p>
        <input type=\"submit\" value=\"Create New Poll\">
      </form>
    
    ";
    echo($newPollFormMarkup);
    echo("<p><a href=\".\">Return Home</a>");
  }
  else // homepage
  {
    $pollArr = GetAllPolls(); // array of poll objects 
    
    $pollListingMarkup = "
    <ul>
";
    foreach($pollArr as $pollObj)
    {
      $isYoursMarkukp = '';
      if(strcmp($cookieValStr, $pollObj->makerID) === 0)
        $isYoursMarkukp = " (Your Poll) <a href=\".?delpage&amp;pollid=".$pollObj->pollGUID."\">Delete</a>";
      
      $pollListingMarkup .= "    <li><a href=\".?pollid=".$pollObj->pollGUID."\">" . htmlspecialchars($pollObj->titleStr) . "</a>" . $isYoursMarkukp . "\r\n";
    }
    $pollListingMarkup .= "
    </ul>
    ";
    
    echo("<h2>Available Polls</h2>
    ".$pollListingMarkup."
    ");
    
    echo("<p><a href=\".?createpage\">Create A Poll</a>");
  }
    
  //footer
  echo("
  </body>
  </html>
  ");
