#!/bin/bash

# logtrim.sh

# check arguments
if [ -z "$1" ]
then
  echo "logtrim: Missing First Operand. (trim limit)";
  exit;
fi

if [ -z "$2" ]
then
  echo "logtrim: Missing Second Operand. (full file path)";
  exit;
fi

# move to /var/log (ideally theres a ram drive there so making temp files there will hurt less.)
cd /var/log
#echo "Working in :"
#pwd

#echo "Currently Trimming $1";

linecount1="$(wc -l "$2" | head -n1 | awk '{print $1;}')";

myrandfilename="$(echo $RANDOM | md5sum | head -c 8).TMP";

#echo -e "My Random Eight: $myrandfilename\n"

tail -n $1 $2 > $myrandfilename

mv $myrandfilename $2

linecount2="$(wc -l "$2" | head -n1 | awk '{print $1;}')";

difference=$((linecount1-linecount2));

echo -e "($2) Trimmed: $difference Line(s).";

